/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.aop;

import com.jfinal.aop.Interceptor;
import com.jfinal.aop.InterceptorManager;
import io.jboot.utils.ClassUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class Interceptors {
    private List<InterceptorWarpper> warppers = new ArrayList<InterceptorWarpper>();
    private int minimalWeight = 1;
    private int currentWeight = 1;

    public Interceptors() {
    }

    public Interceptors(Interceptor[] inters) {
        if (inters != null && inters.length > 0) {
            for (Interceptor interceptor : inters) {
                this.add(interceptor);
            }
        }
    }

    public void add(Interceptor interceptor) {
        this.warppers.add(new InterceptorWarpper(interceptor, this.currentWeight++));
    }

    public void add(Class<? extends Interceptor> interceptorClass) {
        this.add(this.singleton(interceptorClass));
    }

    public void add(Interceptor interceptor, int weight) {
        this.warppers.add(new InterceptorWarpper(interceptor, weight));
    }

    public void add(Class<? extends Interceptor> interceptorClass, int weight) {
        this.add(this.singleton(interceptorClass), weight);
    }

    public void addIfNotExist(Interceptor interceptor) {
        if (!this.contains(interceptor)) {
            this.add(interceptor);
        }
    }

    public void addIfNotExist(Class<? extends Interceptor> interceptorClass) {
        if (!this.contains(interceptorClass)) {
            this.add(this.singleton(interceptorClass));
        }
    }

    public void addToFirst(Interceptor interceptor) {
        this.warppers.add(new InterceptorWarpper(interceptor, --this.minimalWeight));
    }

    public void addToFirst(Class<? extends Interceptor> interceptorClass) {
        this.addToFirst(this.singleton(interceptorClass));
    }

    public void addToFirstIfNotExist(Interceptor interceptor) {
        if (!this.contains(interceptor)) {
            this.warppers.add(new InterceptorWarpper(interceptor, --this.minimalWeight));
        }
    }

    public void addToFirstIfNotExist(Class<? extends Interceptor> interceptorClass) {
        if (!this.contains(interceptorClass)) {
            this.addToFirst(this.singleton(interceptorClass));
        }
    }

    public boolean addBefore(Interceptor interceptor, Predicate<? super Interceptor> filter) {
        Integer weight = null;
        for (InterceptorWarpper warpper : this.warppers) {
            if (!filter.test((Interceptor)warpper.interceptor)) continue;
            weight = warpper.weight;
            break;
        }
        if (weight != null) {
            for (InterceptorWarpper warpper : this.warppers) {
                if (warpper.weight >= weight) continue;
                warpper.weight--;
            }
            --this.minimalWeight;
            weight = weight - 1;
            this.warppers.add(new InterceptorWarpper(interceptor, weight));
            return true;
        }
        return false;
    }

    public boolean addBefore(Class<? extends Interceptor> interceptorClass, Predicate<? super Interceptor> filter) {
        return this.addBefore(this.singleton(interceptorClass), filter);
    }

    public boolean addBefore(Interceptor interceptor, Class<? extends Interceptor> toClass) {
        return this.addBefore(interceptor, (? super Interceptor interceptor1) -> interceptor1.getClass() == toClass);
    }

    public boolean addBefore(Class<? extends Interceptor> interceptorClass, Class<? extends Interceptor> toClass) {
        return this.addBefore(this.singleton(interceptorClass), toClass);
    }

    public boolean addAfter(Interceptor interceptor, Predicate<? super Interceptor> filter) {
        Integer weight = null;
        for (InterceptorWarpper warpper : this.warppers) {
            if (!filter.test((Interceptor)warpper.interceptor)) continue;
            weight = warpper.weight;
            break;
        }
        if (weight != null) {
            for (InterceptorWarpper warpper : this.warppers) {
                if (warpper.weight <= weight) continue;
                warpper.weight++;
            }
            ++this.currentWeight;
            weight = weight + 1;
            this.warppers.add(new InterceptorWarpper(interceptor, weight));
            return true;
        }
        return false;
    }

    public boolean addAfter(Class<? extends Interceptor> interceptorClass, Predicate<? super Interceptor> filter) {
        return this.addAfter(this.singleton(interceptorClass), filter);
    }

    public boolean addAfter(Interceptor interceptor, Class<? extends Interceptor> toClass) {
        return this.addAfter(interceptor, (? super Interceptor interceptor1) -> interceptor1.getClass() == toClass);
    }

    public boolean addAfter(Class<? extends Interceptor> interceptorClass, Class<? extends Interceptor> toClass) {
        return this.addAfter(this.singleton(interceptorClass), toClass);
    }

    public boolean remove(Interceptor interceptor) {
        return this.warppers.removeIf(interceptorWarpper -> ((InterceptorWarpper)interceptorWarpper).interceptor == interceptor);
    }

    public boolean remove(Predicate<? super Interceptor> predicate) {
        return this.warppers.removeIf(warpper -> predicate.test(((InterceptorWarpper)warpper).interceptor));
    }

    public boolean remove(Class<? extends Interceptor> clazz) {
        return this.warppers.removeIf(interceptorWarpper -> ((InterceptorWarpper)interceptorWarpper).interceptor.getClass() == clazz);
    }

    public Integer getWeight(Interceptor interceptor) {
        for (InterceptorWarpper warpper : this.warppers) {
            if (warpper.interceptor != interceptor) continue;
            return warpper.weight;
        }
        return null;
    }

    public Integer getWeight(Class<? extends Interceptor> clazz) {
        for (InterceptorWarpper warpper : this.warppers) {
            if (warpper.interceptor.getClass() != clazz) continue;
            return warpper.weight;
        }
        return null;
    }

    public List<Interceptor> toList() {
        this.warppers.sort(Comparator.comparingInt(InterceptorWarpper::getWeight));
        return this.warppers.stream().map(InterceptorWarpper::getInterceptor).collect(Collectors.toList());
    }

    public Interceptor[] toArray() {
        if (this.warppers == null || this.warppers.size() == 0) {
            return InterceptorManager.NULL_INTERS;
        }
        this.warppers.sort(Comparator.comparingInt(InterceptorWarpper::getWeight));
        Interceptor[] inters = new Interceptor[this.warppers.size()];
        for (int i = 0; i < this.warppers.size(); ++i) {
            inters[i] = this.warppers.get(i).getInterceptor();
        }
        return inters;
    }

    public boolean contains(Interceptor interceptor) {
        for (InterceptorWarpper warpper : this.warppers) {
            if (warpper.interceptor != interceptor) continue;
            return true;
        }
        return false;
    }

    public boolean contains(Class<? extends Interceptor> clazz) {
        for (InterceptorWarpper warpper : this.warppers) {
            if (warpper.interceptor.getClass() != clazz) continue;
            return true;
        }
        return false;
    }

    public int getMinimalWeight() {
        return this.minimalWeight;
    }

    public int getCurrentWeight() {
        return this.currentWeight;
    }

    private Interceptor singleton(Class<? extends Interceptor> interceptorClass) {
        return ClassUtil.singleton(interceptorClass, false, true);
    }

    public List<InterceptorWarpper> getWarppers() {
        return this.warppers;
    }

    static class InterceptorWarpper {
        private Interceptor interceptor;
        private int weight;

        public InterceptorWarpper(Interceptor interceptor, int weight) {
            this.interceptor = interceptor;
            this.weight = weight;
        }

        public Interceptor getInterceptor() {
            return this.interceptor;
        }

        public void setInterceptor(Interceptor interceptor) {
            this.interceptor = interceptor;
        }

        public int getWeight() {
            return this.weight;
        }

        public void setWeight(int weight) {
            this.weight = weight;
        }
    }
}

