/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.aop;

import com.jfinal.aop.Interceptor;
import io.jboot.aop.InterceptorBuilder;
import io.jboot.aop.InterceptorCache;
import io.jboot.aop.Interceptors;
import io.jboot.aop.annotation.AutoLoad;
import io.jboot.core.weight.WeightUtil;
import io.jboot.utils.ClassScanner;
import io.jboot.utils.ClassUtil;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Predicate;

public class InterceptorBuilderManager {
    private static InterceptorBuilderManager me = new InterceptorBuilderManager();
    private List<InterceptorBuilder> interceptorBuilders = new CopyOnWriteArrayList<InterceptorBuilder>();

    public static InterceptorBuilderManager me() {
        return me;
    }

    public InterceptorBuilderManager() {
        List<Class<InterceptorBuilder>> builderClasses = ClassScanner.scanSubClass(InterceptorBuilder.class, true);
        if (builderClasses != null) {
            for (Class<InterceptorBuilder> builderClass : builderClasses) {
                if (builderClass.getAnnotation(AutoLoad.class) == null) continue;
                this.addInterceptorBuilder(ClassUtil.newInstance(builderClass, false));
            }
            InterceptorCache.clear();
        }
    }

    public List<InterceptorBuilder> getInterceptorBuilders() {
        return this.interceptorBuilders;
    }

    public void addInterceptorBuilder(InterceptorBuilder interceptorBuilder) {
        if (interceptorBuilder == null) {
            throw new NullPointerException("interceptorBuilder must not be null.");
        }
        this.interceptorBuilders.add(interceptorBuilder);
        WeightUtil.sort(this.interceptorBuilders);
        InterceptorCache.clear();
    }

    public void addInterceptorBuilder(Collection<InterceptorBuilder> interceptorBuilders) {
        if (interceptorBuilders == null) {
            throw new NullPointerException("interceptorBuilder must not be null.");
        }
        this.interceptorBuilders.addAll(interceptorBuilders);
        WeightUtil.sort(this.interceptorBuilders);
        InterceptorCache.clear();
    }

    public void removeInterceptorBuilder(Predicate<? super InterceptorBuilder> filter) {
        if (this.interceptorBuilders != null && !this.interceptorBuilders.isEmpty() && this.interceptorBuilders.removeIf(filter)) {
            InterceptorCache.clear();
        }
    }

    public Interceptor[] build(Class<?> targetClass, Method method, Interceptor[] inters) {
        if (this.interceptorBuilders != null && this.interceptorBuilders.size() > 0) {
            Interceptors interceptors = new Interceptors(inters);
            for (InterceptorBuilder builder : this.interceptorBuilders) {
                builder.build(targetClass, method, interceptors);
            }
            return interceptors.toArray();
        }
        return inters;
    }
}

