/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.aop;

import com.jfinal.aop.Interceptor;
import com.jfinal.aop.Invocation;
import io.jboot.aop.InterceptorBuilder;
import io.jboot.aop.Interceptors;
import io.jboot.aop.annotation.AutoLoad;
import io.jboot.aop.annotation.DefaultValue;
import io.jboot.core.weight.Weight;
import io.jboot.utils.ObjectUtil;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;

@AutoLoad
@Weight(value=999)
public class DefaultValueInterceptor
implements Interceptor,
InterceptorBuilder {
    public void intercept(Invocation inv) {
        Parameter[] parameters = inv.getMethod().getParameters();
        for (int index = 0; index < parameters.length; ++index) {
            Object value;
            Object arg;
            DefaultValue defaultValue = parameters[index].getAnnotation(DefaultValue.class);
            if (defaultValue == null || (arg = inv.getArg(index)) != null && !DefaultValueInterceptor.isPrimitiveDefaultValue(arg, parameters[index].getType()) || (value = ObjectUtil.convert(defaultValue.value(), parameters[index].getType())) == null) continue;
            inv.setArg(index, value);
        }
        inv.invoke();
    }

    public static boolean isPrimitiveDefaultValue(Object value, Class<?> paraClass) {
        if (paraClass == Integer.TYPE || paraClass == Long.TYPE || paraClass == Float.TYPE || paraClass == Double.TYPE || paraClass == Short.TYPE) {
            return ((Number)value).intValue() == 0;
        }
        if (paraClass == Boolean.TYPE) {
            return (Boolean)value == false;
        }
        return false;
    }

    @Override
    public void build(Class<?> targetClass, Method method, Interceptors interceptors) {
        Parameter[] parameters = method.getParameters();
        if (parameters != null && parameters.length > 0) {
            for (Parameter p : parameters) {
                if (p.getAnnotation(DefaultValue.class) == null) continue;
                interceptors.addIfNotExist(this);
            }
        }
    }
}

