/*
 * Decompiled with CFR 0.152.
 */
package io.jboot;

import com.codahale.metrics.MetricRegistry;
import com.jfinal.aop.Aop;
import io.jboot.aop.JbootAopFactory;
import io.jboot.app.config.JbootConfigManager;
import io.jboot.components.cache.JbootCache;
import io.jboot.components.cache.JbootCacheManager;
import io.jboot.components.event.JbootEvent;
import io.jboot.components.event.JbootEventManager;
import io.jboot.components.mq.Jbootmq;
import io.jboot.components.mq.JbootmqManager;
import io.jboot.components.rpc.JbootrpcManager;
import io.jboot.components.rpc.JbootrpcReferenceConfig;
import io.jboot.components.serializer.JbootSerializer;
import io.jboot.components.serializer.JbootSerializerManager;
import io.jboot.support.metric.JbootMetricManager;
import io.jboot.support.redis.JbootRedis;
import io.jboot.support.redis.JbootRedisManager;
import io.jboot.utils.StrUtil;

public class Jboot {
    public static boolean isDevMode() {
        return JbootConfigManager.me().isDevMode();
    }

    public static JbootCache getCache() {
        return JbootCacheManager.me().getCache();
    }

    public static JbootCache getCache(String name) {
        return JbootCacheManager.me().getCache(name);
    }

    public static JbootRedis getRedis() {
        return JbootRedisManager.me().getRedis();
    }

    public static JbootRedis getRedis(String name) {
        return JbootRedisManager.me().getRedis(name);
    }

    public static MetricRegistry getMetric() {
        return JbootMetricManager.me().metric();
    }

    public static Jbootmq getMq() {
        return JbootmqManager.me().getJbootmq();
    }

    public static Jbootmq getMq(String name) {
        return JbootmqManager.me().getJbootmq(name);
    }

    public static JbootSerializer getSerializer() {
        return JbootSerializerManager.me().getSerializer();
    }

    public static JbootSerializer getSerializer(String name) {
        return JbootSerializerManager.me().getSerializer(name);
    }

    public static <T> T config(Class<T> clazz) {
        return JbootConfigManager.me().get(clazz);
    }

    public static <T> T config(Class<T> clazz, String prefix) {
        return JbootConfigManager.me().get(clazz, prefix, null);
    }

    public static <T> T config(Class<T> clazz, String prefix, String file) {
        return JbootConfigManager.me().get(clazz, prefix, file);
    }

    public static String configValue(String key) {
        return JbootConfigManager.me().getConfigValue(key);
    }

    public static String configValue(String key, String defaultValue) {
        String value = Jboot.configValue(key);
        return StrUtil.isNotBlank(value) ? value : defaultValue;
    }

    public static <T> T service(Class<T> clazz) {
        return Jboot.service(clazz, new JbootrpcReferenceConfig());
    }

    public static <T> T service(Class<T> clazz, JbootrpcReferenceConfig config) {
        return JbootrpcManager.me().getJbootrpc().serviceObtain(clazz, config);
    }

    public static void sendEvent(JbootEvent event) {
        JbootEventManager.me().pulish(event);
    }

    public static void sendEvent(String action, Object data) {
        Jboot.sendEvent(new JbootEvent(action, data));
    }

    public static <T> T getBean(Class<T> clazz) {
        return (T)Aop.get(clazz);
    }

    public static <T> T getBean(String name) {
        return JbootAopFactory.me().getBean(name);
    }
}

