/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds.internal.sds;

import io.grpc.ForwardingChannelBuilder;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.netty.shaded.io.grpc.netty.InternalNettyChannelBuilder;
import io.grpc.netty.shaded.io.grpc.netty.InternalProtocolNegotiator;
import io.grpc.netty.shaded.io.grpc.netty.NettyChannelBuilder;
import io.grpc.xds.internal.sds.SdsProtocolNegotiators;
import java.net.SocketAddress;
import javax.annotation.CheckReturnValue;

public final class XdsChannelBuilder
extends ForwardingChannelBuilder<XdsChannelBuilder> {
    private final NettyChannelBuilder delegate;
    private InternalProtocolNegotiator.ProtocolNegotiator fallbackProtocolNegotiator;

    private XdsChannelBuilder(NettyChannelBuilder delegate) {
        this.delegate = delegate;
    }

    @CheckReturnValue
    public static XdsChannelBuilder forAddress(SocketAddress serverAddress) {
        return new XdsChannelBuilder(NettyChannelBuilder.forAddress((SocketAddress)serverAddress));
    }

    @CheckReturnValue
    public static XdsChannelBuilder forAddress(String host, int port) {
        return new XdsChannelBuilder(NettyChannelBuilder.forAddress((String)host, (int)port));
    }

    @CheckReturnValue
    public static XdsChannelBuilder forTarget(String target) {
        return new XdsChannelBuilder(NettyChannelBuilder.forTarget((String)target));
    }

    public XdsChannelBuilder fallbackProtocolNegotiator(InternalProtocolNegotiator.ProtocolNegotiator fallbackProtocolNegotiator) {
        this.fallbackProtocolNegotiator = fallbackProtocolNegotiator;
        return this;
    }

    protected ManagedChannelBuilder<?> delegate() {
        return this.delegate;
    }

    public ManagedChannel build() {
        InternalNettyChannelBuilder.setProtocolNegotiatorFactory((NettyChannelBuilder)this.delegate, (InternalNettyChannelBuilder.ProtocolNegotiatorFactory)SdsProtocolNegotiators.clientProtocolNegotiatorFactory(this.fallbackProtocolNegotiator));
        return this.delegate.build();
    }
}

