/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds.internal.sds;

import com.google.common.base.Preconditions;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContext;
import io.grpc.xds.EnvoyServerProtoData;
import io.grpc.xds.internal.sds.Closeable;
import io.grpc.xds.internal.sds.SslContextProvider;
import io.grpc.xds.internal.sds.TlsContextManager;

public final class SslContextProviderSupplier
implements Closeable {
    private final EnvoyServerProtoData.UpstreamTlsContext upstreamTlsContext;
    private final TlsContextManager tlsContextManager;
    private SslContextProvider sslContextProvider;
    private boolean shutdown;

    public SslContextProviderSupplier(EnvoyServerProtoData.UpstreamTlsContext upstreamTlsContext, TlsContextManager tlsContextManager) {
        this.upstreamTlsContext = upstreamTlsContext;
        this.tlsContextManager = tlsContextManager;
    }

    public EnvoyServerProtoData.UpstreamTlsContext getUpstreamTlsContext() {
        return this.upstreamTlsContext;
    }

    public synchronized void updateSslContext(final SslContextProvider.Callback callback) {
        Preconditions.checkNotNull((Object)callback, (Object)"callback");
        Preconditions.checkState((!this.shutdown ? 1 : 0) != 0, (Object)"Supplier is shutdown!");
        if (this.sslContextProvider == null) {
            this.sslContextProvider = this.tlsContextManager.findOrCreateClientSslContextProvider(this.upstreamTlsContext);
        }
        final SslContextProvider toRelease = this.tlsContextManager.findOrCreateClientSslContextProvider(this.upstreamTlsContext);
        this.sslContextProvider.addCallback(new SslContextProvider.Callback(callback.getExecutor()){

            @Override
            public void updateSecret(SslContext sslContext) {
                callback.updateSecret(sslContext);
                SslContextProviderSupplier.this.tlsContextManager.releaseClientSslContextProvider(toRelease);
            }

            @Override
            public void onException(Throwable throwable) {
                callback.onException(throwable);
                SslContextProviderSupplier.this.tlsContextManager.releaseClientSslContextProvider(toRelease);
            }
        });
    }

    @Override
    public synchronized void close() {
        if (this.sslContextProvider != null) {
            this.tlsContextManager.releaseClientSslContextProvider(this.sslContextProvider);
        }
        this.shutdown = true;
    }
}

