/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds.internal.sds;

import com.google.common.base.Preconditions;
import com.google.protobuf.ProtocolStringList;
import io.grpc.Status;
import io.grpc.netty.shaded.io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.shaded.io.netty.handler.ssl.ApplicationProtocolConfig;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContext;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContextBuilder;
import io.grpc.xds.internal.sds.SdsClient;
import io.grpc.xds.internal.sds.SslContextProvider;
import io.grpc.xds.internal.sds.trust.SdsTrustManagerFactory;
import io.grpc.xds.shaded.io.envoyproxy.envoy.api.v2.auth.CertificateValidationContext;
import io.grpc.xds.shaded.io.envoyproxy.envoy.api.v2.auth.CommonTlsContext;
import io.grpc.xds.shaded.io.envoyproxy.envoy.api.v2.auth.DownstreamTlsContext;
import io.grpc.xds.shaded.io.envoyproxy.envoy.api.v2.auth.SdsSecretConfig;
import io.grpc.xds.shaded.io.envoyproxy.envoy.api.v2.auth.Secret;
import io.grpc.xds.shaded.io.envoyproxy.envoy.api.v2.auth.TlsCertificate;
import io.grpc.xds.shaded.io.envoyproxy.envoy.api.v2.auth.UpstreamTlsContext;
import io.grpc.xds.shaded.io.envoyproxy.envoy.api.v2.core.Node;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.CertStoreException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.net.ssl.TrustManagerFactory;

final class SdsSslContextProvider<K>
extends SslContextProvider<K>
implements SdsClient.SecretWatcher {
    private static final Logger logger = Logger.getLogger(SdsSslContextProvider.class.getName());
    @Nullable
    private final SdsClient certSdsClient;
    @Nullable
    private final SdsClient validationContextSdsClient;
    @Nullable
    private final SdsSecretConfig certSdsConfig;
    @Nullable
    private final SdsSecretConfig validationContextSdsConfig;
    @Nullable
    private final CertificateValidationContext staticCertificateValidationContext;
    private final List<CallbackPair> pendingCallbacks = new ArrayList<CallbackPair>();
    @Nullable
    private TlsCertificate tlsCertificate;
    @Nullable
    private CertificateValidationContext certificateValidationContext;
    @Nullable
    private SslContext sslContext;

    private SdsSslContextProvider(Node node, SdsSecretConfig certSdsConfig, SdsSecretConfig validationContextSdsConfig, CertificateValidationContext staticCertValidationContext, Executor watcherExecutor, Executor channelExecutor, boolean server, K source) {
        super(source, server);
        this.certSdsConfig = certSdsConfig;
        this.validationContextSdsConfig = validationContextSdsConfig;
        this.staticCertificateValidationContext = staticCertValidationContext;
        if (certSdsConfig != null && certSdsConfig.isInitialized()) {
            this.certSdsClient = SdsClient.Factory.createSdsClient(certSdsConfig, node, watcherExecutor, channelExecutor);
            this.certSdsClient.start();
            this.certSdsClient.watchSecret(this);
        } else {
            this.certSdsClient = null;
        }
        if (validationContextSdsConfig != null && validationContextSdsConfig.isInitialized()) {
            this.validationContextSdsClient = SdsClient.Factory.createSdsClient(validationContextSdsConfig, node, watcherExecutor, channelExecutor);
            this.validationContextSdsClient.start();
            this.validationContextSdsClient.watchSecret(this);
        } else {
            this.validationContextSdsClient = null;
        }
    }

    static SdsSslContextProvider<UpstreamTlsContext> getProviderForClient(UpstreamTlsContext upstreamTlsContext, Node node, Executor watcherExecutor, Executor channelExecutor) {
        Preconditions.checkNotNull((Object)upstreamTlsContext, (Object)"upstreamTlsContext");
        CommonTlsContext commonTlsContext = upstreamTlsContext.getCommonTlsContext();
        SdsSecretConfig validationContextSdsConfig = null;
        CertificateValidationContext staticCertValidationContext = null;
        if (commonTlsContext.hasCombinedValidationContext()) {
            CommonTlsContext.CombinedCertificateValidationContext combinedValidationContext = commonTlsContext.getCombinedValidationContext();
            if (combinedValidationContext.hasValidationContextSdsSecretConfig()) {
                validationContextSdsConfig = combinedValidationContext.getValidationContextSdsSecretConfig();
            }
            if (combinedValidationContext.hasDefaultValidationContext()) {
                staticCertValidationContext = combinedValidationContext.getDefaultValidationContext();
            }
        } else if (commonTlsContext.hasValidationContextSdsSecretConfig()) {
            validationContextSdsConfig = commonTlsContext.getValidationContextSdsSecretConfig();
        } else if (commonTlsContext.hasValidationContext()) {
            staticCertValidationContext = commonTlsContext.getValidationContext();
        }
        SdsSecretConfig certSdsConfig = null;
        if (commonTlsContext.getTlsCertificateSdsSecretConfigsCount() > 0) {
            certSdsConfig = commonTlsContext.getTlsCertificateSdsSecretConfigs(0);
        }
        return new SdsSslContextProvider<UpstreamTlsContext>(node, certSdsConfig, validationContextSdsConfig, staticCertValidationContext, watcherExecutor, channelExecutor, false, upstreamTlsContext);
    }

    static SdsSslContextProvider<DownstreamTlsContext> getProviderForServer(DownstreamTlsContext downstreamTlsContext, Node node, Executor watcherExecutor, Executor channelExecutor) {
        Preconditions.checkNotNull((Object)downstreamTlsContext, (Object)"downstreamTlsContext");
        CommonTlsContext commonTlsContext = downstreamTlsContext.getCommonTlsContext();
        SdsSecretConfig certSdsConfig = null;
        if (commonTlsContext.getTlsCertificateSdsSecretConfigsCount() > 0) {
            certSdsConfig = commonTlsContext.getTlsCertificateSdsSecretConfigs(0);
        }
        SdsSecretConfig validationContextSdsConfig = null;
        if (commonTlsContext.hasValidationContextSdsSecretConfig()) {
            validationContextSdsConfig = commonTlsContext.getValidationContextSdsSecretConfig();
        }
        return new SdsSslContextProvider<DownstreamTlsContext>(node, certSdsConfig, validationContextSdsConfig, null, watcherExecutor, channelExecutor, true, downstreamTlsContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addCallback(SslContextProvider.Callback callback, Executor executor) {
        Preconditions.checkNotNull((Object)callback, (Object)"callback");
        Preconditions.checkNotNull((Object)executor, (Object)"executor");
        SslContext sslContextCopy = this.sslContext;
        if (sslContextCopy != null) {
            this.callPerformCallback(callback, executor, sslContextCopy);
        } else {
            List<CallbackPair> list = this.pendingCallbacks;
            synchronized (list) {
                this.pendingCallbacks.add(new CallbackPair(callback, executor));
            }
        }
    }

    private void callPerformCallback(SslContextProvider.Callback callback, Executor executor, final SslContext sslContextCopy) {
        this.performCallback(new SslContextProvider.SslContextGetter(){

            @Override
            public SslContext get() {
                return sslContextCopy;
            }
        }, callback, executor);
    }

    @Override
    public synchronized void onSecretChanged(Secret secretUpdate) {
        Preconditions.checkNotNull((Object)secretUpdate);
        if (secretUpdate.hasTlsCertificate()) {
            Preconditions.checkState((boolean)secretUpdate.getName().equals(this.certSdsConfig.getName()), (Object)"tlsCert names don't match");
            logger.log(Level.FINEST, "onSecretChanged certSdsConfig.name={0}", this.certSdsConfig.getName());
            this.tlsCertificate = secretUpdate.getTlsCertificate();
            if (this.certificateValidationContext != null || this.validationContextSdsConfig == null) {
                this.updateSslContext();
            }
        } else if (secretUpdate.hasValidationContext()) {
            Preconditions.checkState((boolean)secretUpdate.getName().equals(this.validationContextSdsConfig.getName()), (Object)"validationContext names don't match");
            logger.log(Level.FINEST, "onSecretChanged validationContextSdsConfig.name={0}", this.validationContextSdsConfig.getName());
            this.certificateValidationContext = secretUpdate.getValidationContext();
            if (this.tlsCertificate != null || this.certSdsConfig == null) {
                this.updateSslContext();
            }
        } else {
            throw new UnsupportedOperationException("Unexpected secret type:" + (Object)((Object)secretUpdate.getTypeCase()));
        }
    }

    private void updateSslContext() {
        try {
            SslContext sslContextCopy;
            CommonTlsContext commonTlsContext;
            SslContextBuilder sslContextBuilder;
            CertificateValidationContext localCertValidationContext = this.mergeStaticAndDynamicCertContexts();
            if (this.server) {
                logger.log(Level.FINEST, "for server");
                sslContextBuilder = GrpcSslContexts.forServer((InputStream)this.tlsCertificate.getCertificateChain().getInlineBytes().newInput(), (InputStream)this.tlsCertificate.getPrivateKey().getInlineBytes().newInput(), this.tlsCertificate.hasPassword() ? this.tlsCertificate.getPassword().getInlineString() : null);
                if (localCertValidationContext != null) {
                    sslContextBuilder.trustManager((TrustManagerFactory)((Object)new SdsTrustManagerFactory(localCertValidationContext)));
                }
            } else {
                logger.log(Level.FINEST, "for client");
                sslContextBuilder = GrpcSslContexts.forClient().trustManager((TrustManagerFactory)((Object)new SdsTrustManagerFactory(localCertValidationContext)));
                if (this.tlsCertificate != null) {
                    sslContextBuilder.keyManager(this.tlsCertificate.getCertificateChain().getInlineBytes().newInput(), this.tlsCertificate.getPrivateKey().getInlineBytes().newInput(), this.tlsCertificate.hasPassword() ? this.tlsCertificate.getPassword().getInlineString() : null);
                }
            }
            if ((commonTlsContext = this.getCommonTlsContext()) != null && commonTlsContext.getAlpnProtocolsCount() > 0) {
                ProtocolStringList alpnList = commonTlsContext.getAlpnProtocolsList();
                ApplicationProtocolConfig apn = new ApplicationProtocolConfig(ApplicationProtocolConfig.Protocol.ALPN, ApplicationProtocolConfig.SelectorFailureBehavior.NO_ADVERTISE, ApplicationProtocolConfig.SelectedListenerFailureBehavior.ACCEPT, (Iterable)alpnList);
                sslContextBuilder.applicationProtocolConfig(apn);
            }
            this.sslContext = sslContextCopy = sslContextBuilder.build();
            this.makePendingCallbacks(sslContextCopy);
        }
        catch (IOException | CertStoreException | CertificateException e) {
            logger.log(Level.SEVERE, "exception in updateSslContext", e);
        }
    }

    private CertificateValidationContext mergeStaticAndDynamicCertContexts() {
        if (this.staticCertificateValidationContext == null) {
            return this.certificateValidationContext;
        }
        if (this.certificateValidationContext == null) {
            return this.staticCertificateValidationContext;
        }
        CertificateValidationContext.Builder localCertContextBuilder = this.certificateValidationContext.toBuilder();
        return localCertContextBuilder.mergeFrom(this.staticCertificateValidationContext).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void makePendingCallbacks(SslContext sslContextCopy) {
        List<CallbackPair> list = this.pendingCallbacks;
        synchronized (list) {
            for (CallbackPair pair : this.pendingCallbacks) {
                this.callPerformCallback(pair.callback, pair.executor, sslContextCopy);
            }
            this.pendingCallbacks.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onError(Status error) {
        List<CallbackPair> list = this.pendingCallbacks;
        synchronized (list) {
            for (CallbackPair callbackPair : this.pendingCallbacks) {
                callbackPair.callback.onException((Throwable)error.asException());
            }
            this.pendingCallbacks.clear();
        }
    }

    @Override
    void close() {
        if (this.certSdsClient != null) {
            this.certSdsClient.cancelSecretWatch(this);
            this.certSdsClient.shutdown();
        }
        if (this.validationContextSdsClient != null) {
            this.validationContextSdsClient.cancelSecretWatch(this);
            this.validationContextSdsClient.shutdown();
        }
    }

    private static class CallbackPair {
        private final SslContextProvider.Callback callback;
        private final Executor executor;

        private CallbackPair(SslContextProvider.Callback callback, Executor executor) {
            this.callback = callback;
            this.executor = executor;
        }
    }
}

