/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import io.grpc.Internal;
import io.grpc.LoadBalancer;
import io.grpc.LoadBalancerProvider;
import io.grpc.LoadBalancerRegistry;
import io.grpc.NameResolver;
import io.grpc.Status;
import io.grpc.internal.JsonUtil;
import io.grpc.internal.ServiceConfigUtil;
import io.grpc.xds.WeightedTargetLoadBalancer;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@Internal
public final class WeightedTargetLoadBalancerProvider
extends LoadBalancerProvider {
    @Nullable
    private final LoadBalancerRegistry lbRegistry;

    public WeightedTargetLoadBalancerProvider() {
        this(null);
    }

    @VisibleForTesting
    WeightedTargetLoadBalancerProvider(@Nullable LoadBalancerRegistry lbRegistry) {
        this.lbRegistry = lbRegistry;
    }

    public boolean isAvailable() {
        return true;
    }

    public int getPriority() {
        return 5;
    }

    public String getPolicyName() {
        return "weighted_target_experimental";
    }

    public LoadBalancer newLoadBalancer(LoadBalancer.Helper helper) {
        return new WeightedTargetLoadBalancer(helper);
    }

    public NameResolver.ConfigOrError parseLoadBalancingPolicyConfig(Map<String, ?> rawConfig) {
        try {
            Map targets = JsonUtil.getObject(rawConfig, (String)"targets");
            if (targets == null || targets.isEmpty()) {
                return NameResolver.ConfigOrError.fromError((Status)Status.INTERNAL.withDescription("No targets provided for weighted_target LB policy:\n " + rawConfig));
            }
            LinkedHashMap<String, WeightedPolicySelection> parsedChildConfigs = new LinkedHashMap<String, WeightedPolicySelection>();
            for (String name : targets.keySet()) {
                Map rawWeightedTarget = JsonUtil.getObject((Map)targets, (String)name);
                if (rawWeightedTarget == null || rawWeightedTarget.isEmpty()) {
                    return NameResolver.ConfigOrError.fromError((Status)Status.INTERNAL.withDescription("No config for target " + name + " in weighted_target LB policy:\n " + rawConfig));
                }
                Integer weight = JsonUtil.getNumberAsInteger((Map)rawWeightedTarget, (String)"weight");
                if (weight == null || weight < 1) {
                    return NameResolver.ConfigOrError.fromError((Status)Status.INTERNAL.withDescription("Wrong weight for target " + name + " in weighted_target LB policy:\n " + rawConfig));
                }
                List childConfigCandidates = ServiceConfigUtil.unwrapLoadBalancingConfigList((List)JsonUtil.getListOfObjects((Map)rawWeightedTarget, (String)"childPolicy"));
                if (childConfigCandidates == null || childConfigCandidates.isEmpty()) {
                    return NameResolver.ConfigOrError.fromError((Status)Status.INTERNAL.withDescription("No child policy for target " + name + " in weighted_target LB policy:\n " + rawConfig));
                }
                LoadBalancerRegistry lbRegistry = this.lbRegistry == null ? LoadBalancerRegistry.getDefaultRegistry() : this.lbRegistry;
                NameResolver.ConfigOrError selectedConfig = ServiceConfigUtil.selectLbPolicyFromList((List)childConfigCandidates, (LoadBalancerRegistry)lbRegistry);
                if (selectedConfig.getError() != null) {
                    return selectedConfig;
                }
                ServiceConfigUtil.PolicySelection policySelection = (ServiceConfigUtil.PolicySelection)selectedConfig.getConfig();
                parsedChildConfigs.put(name, new WeightedPolicySelection(weight, policySelection));
            }
            return NameResolver.ConfigOrError.fromConfig((Object)new WeightedTargetConfig(parsedChildConfigs));
        }
        catch (RuntimeException e) {
            return NameResolver.ConfigOrError.fromError((Status)Status.fromThrowable((Throwable)e).withDescription("Failed to parse weighted_target LB config: " + rawConfig));
        }
    }

    static final class WeightedTargetConfig {
        final Map<String, WeightedPolicySelection> targets;

        @VisibleForTesting
        WeightedTargetConfig(Map<String, WeightedPolicySelection> targets) {
            this.targets = targets;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            WeightedTargetConfig that = (WeightedTargetConfig)o;
            return Objects.equals(this.targets, that.targets);
        }

        public int hashCode() {
            return Objects.hashCode(this.targets);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("targets", this.targets).toString();
        }
    }

    static final class WeightedPolicySelection {
        final int weight;
        final ServiceConfigUtil.PolicySelection policySelection;

        @VisibleForTesting
        WeightedPolicySelection(int weight, ServiceConfigUtil.PolicySelection policySelection) {
            this.weight = weight;
            this.policySelection = policySelection;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            WeightedPolicySelection that = (WeightedPolicySelection)o;
            return this.weight == that.weight && Objects.equals(this.policySelection, that.policySelection);
        }

        public int hashCode() {
            return Objects.hash(this.weight, this.policySelection);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("weight", this.weight).add("policySelection", (Object)this.policySelection).toString();
        }
    }
}

