/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.grpclb;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import io.grpc.grpclb.GrpclbState;
import javax.annotation.Nullable;

final class GrpclbConfig {
    private final GrpclbState.Mode mode;
    @Nullable
    private final String serviceName;
    private final long fallbackTimeoutMs;

    private GrpclbConfig(GrpclbState.Mode mode, @Nullable String serviceName, long fallbackTimeoutMs) {
        this.mode = (GrpclbState.Mode)((Object)Preconditions.checkNotNull((Object)((Object)mode), (Object)"mode"));
        this.serviceName = serviceName;
        this.fallbackTimeoutMs = fallbackTimeoutMs;
    }

    static GrpclbConfig create(GrpclbState.Mode mode) {
        return GrpclbConfig.create(mode, null, GrpclbState.FALLBACK_TIMEOUT_MS);
    }

    static GrpclbConfig create(GrpclbState.Mode mode, @Nullable String serviceName, long fallbackTimeoutMs) {
        Preconditions.checkArgument((fallbackTimeoutMs > 0L ? 1 : 0) != 0, (String)"Invalid timeout (%s)", (long)fallbackTimeoutMs);
        return new GrpclbConfig(mode, serviceName, fallbackTimeoutMs);
    }

    GrpclbState.Mode getMode() {
        return this.mode;
    }

    long getFallbackTimeoutMs() {
        return this.fallbackTimeoutMs;
    }

    @Nullable
    String getServiceName() {
        return this.serviceName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GrpclbConfig that = (GrpclbConfig)o;
        return this.mode == that.mode && Objects.equal((Object)this.serviceName, (Object)that.serviceName) && this.fallbackTimeoutMs == that.fallbackTimeoutMs;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.mode, this.serviceName, this.fallbackTimeoutMs});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("mode", (Object)this.mode).add("serviceName", (Object)this.serviceName).add("fallbackTimeoutMs", this.fallbackTimeoutMs).toString();
    }
}

