/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.internal;

import com.google.common.base.Preconditions;
import io.grpc.Metadata;
import io.grpc.Status;
import io.grpc.internal.ClientStreamListener;
import io.grpc.internal.NoopClientStream;

public final class FailingClientStream
extends NoopClientStream {
    private boolean started;
    private final Status error;

    public FailingClientStream(Status error) {
        Preconditions.checkArgument((!error.isOk() ? 1 : 0) != 0, (Object)"error must not be OK");
        this.error = error;
    }

    @Override
    public void start(ClientStreamListener listener) {
        Preconditions.checkState((!this.started ? 1 : 0) != 0, (Object)"already started");
        this.started = true;
        listener.closed(this.error, new Metadata());
    }

    Status getError() {
        return this.error;
    }
}

