/*
 * Decompiled with CFR 0.152.
 */
package org.nlpcn.es4sql.spatial;

import com.google.common.base.Joiner;
import java.util.ArrayList;

public class WktToGeoJsonConverter {
    public static String toGeoJson(String wkt) {
        int startOfCoordinates = (wkt = wkt.toLowerCase()).indexOf("(");
        if (startOfCoordinates == -1) {
            throw new IllegalArgumentException("not valid wkt");
        }
        String wktType = wkt.substring(0, startOfCoordinates).trim();
        wkt = wkt.substring(startOfCoordinates);
        String type = "";
        String coordinates = "";
        switch (wktType) {
            case "point": {
                type = "Point";
                coordinates = WktToGeoJsonConverter.pointCoordinatesFromWkt(wkt);
                break;
            }
            case "polygon": {
                type = "Polygon";
                coordinates = WktToGeoJsonConverter.polygonCoordinatesFromWkt(wkt);
                break;
            }
            case "linestring": {
                type = "LineString";
                coordinates = WktToGeoJsonConverter.lineStringCoordinatesFromWkt(wkt);
                break;
            }
            case "multipolygon": {
                type = "MultiPolygon";
                coordinates = WktToGeoJsonConverter.multiPolygonCoordinatesFromWkt(wkt);
                break;
            }
            case "multipoint": {
                type = "MultiPoint";
                coordinates = WktToGeoJsonConverter.multiPointCoordinatesFromWkt(wkt);
                break;
            }
            case "multilinestring": {
                type = "MultiLineString";
                coordinates = WktToGeoJsonConverter.multiLineStringCoordinatesFromWkt(wkt);
                break;
            }
            default: {
                throw new IllegalArgumentException("not supported wkt type");
            }
        }
        return WktToGeoJsonConverter.buildGeoJson(type, coordinates);
    }

    private static String multiLineStringCoordinatesFromWkt(String wkt) {
        wkt = WktToGeoJsonConverter.removeBrackets(wkt, 1);
        String lineStringsWithPipeSeparator = wkt.replaceAll("\\s*\\)\\s*,\\s*\\(", ")|(");
        String[] lineStrings = lineStringsWithPipeSeparator.split("\\|");
        Object[] coordinates = new String[lineStrings.length];
        for (int i = 0; i < lineStrings.length; ++i) {
            coordinates[i] = WktToGeoJsonConverter.lineStringCoordinatesFromWkt(lineStrings[i]);
        }
        String multiLineStringCoordinates = Joiner.on((String)",").join(coordinates);
        return String.format("[%s]", multiLineStringCoordinates);
    }

    private static String multiPointCoordinatesFromWkt(String wkt) {
        wkt = WktToGeoJsonConverter.removeBrackets(wkt, 1);
        boolean isSecondVersionMultiPoint = wkt.contains("(");
        String coordinates = "";
        if (isSecondVersionMultiPoint) {
            wkt = wkt.replaceAll("\\(|\\)", "");
        }
        coordinates = WktToGeoJsonConverter.getJsonArrayFromListOfPoints(wkt);
        return coordinates;
    }

    private static String multiPolygonCoordinatesFromWkt(String wkt) {
        wkt = WktToGeoJsonConverter.removeBrackets(wkt, 1);
        String polygonsWithPipeSeparator = wkt.replaceAll("\\s*\\)\\s*\\)\\s*,\\s*\\(\\s*\\(\\s*", "))|((");
        String[] polygons = polygonsWithPipeSeparator.split("\\|");
        Object[] polygonsCoordinates = new String[polygons.length];
        for (int i = 0; i < polygons.length; ++i) {
            polygonsCoordinates[i] = WktToGeoJsonConverter.polygonCoordinatesFromWkt(polygons[i]);
        }
        String coordinates = Joiner.on((String)",").join(polygonsCoordinates);
        return String.format("[%s]", coordinates);
    }

    private static String lineStringCoordinatesFromWkt(String wkt) {
        wkt = WktToGeoJsonConverter.removeBrackets(wkt, 1);
        return WktToGeoJsonConverter.getJsonArrayFromListOfPoints(wkt);
    }

    private static String polygonCoordinatesFromWkt(String wkt) {
        String coordinates;
        boolean polygonContainsInnerHoles = (wkt = WktToGeoJsonConverter.removeBrackets(wkt, 2)).contains("(");
        if (polygonContainsInnerHoles) {
            String[] polygons = wkt.split("\\s*\\)\\s*,\\s*\\(\\s*");
            Object[] coordinatesOfPolygons = new String[polygons.length];
            for (int i = 0; i < polygons.length; ++i) {
                String polygonCoordinates = WktToGeoJsonConverter.getJsonArrayFromListOfPoints(polygons[i]);
                coordinatesOfPolygons[i] = polygonCoordinates;
            }
            coordinates = Joiner.on((String)",").join(coordinatesOfPolygons);
        } else {
            coordinates = WktToGeoJsonConverter.getJsonArrayFromListOfPoints(wkt);
        }
        return String.format("[%s]", coordinates);
    }

    private static String getJsonArrayFromListOfPoints(String pointsInWkt) {
        String[] points = pointsInWkt.split(",");
        ArrayList<String> coordinates = new ArrayList<String>();
        for (String point : points) {
            coordinates.add(WktToGeoJsonConverter.extractCoordinateFromPoint(point));
        }
        String joinedCoordinates = Joiner.on((String)",").join(coordinates);
        return String.format("[%s]", joinedCoordinates);
    }

    private static String buildGeoJson(String type, String coordinates) {
        return String.format("{\"type\":\"%s\", \"coordinates\": %s}", type, coordinates);
    }

    public static String pointCoordinatesFromWkt(String wkt) {
        wkt = WktToGeoJsonConverter.removeBrackets(wkt, 1);
        return WktToGeoJsonConverter.extractCoordinateFromPoint(wkt);
    }

    private static String extractCoordinateFromPoint(String point) {
        String pointPattern = "(\\s*)([0-9\\.]+)(\\s*)([0-9\\.]+)(\\s*)";
        return point.replaceAll(pointPattern, "[$2,$4]");
    }

    private static String removeBrackets(String wkt, int num) {
        String result = wkt;
        for (int i = 0; i < num; ++i) {
            int lastClosingBrackets = result.lastIndexOf(")");
            int firstOpenBrackets = result.indexOf("(");
            if (lastClosingBrackets == -1 || firstOpenBrackets == -1) {
                throw new IllegalArgumentException("not enough brackets");
            }
            result = result.substring(firstOpenBrackets + 1, lastClosingBrackets);
        }
        return result;
    }
}

