/*
 * Decompiled with CFR 0.152.
 */
package org.nlpcn.es4sql.query.maker;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.ValuesSourceAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.children.ChildrenBuilder;
import org.elasticsearch.search.aggregations.bucket.geogrid.GeoHashGridBuilder;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramBuilder;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramInterval;
import org.elasticsearch.search.aggregations.bucket.histogram.Histogram;
import org.elasticsearch.search.aggregations.bucket.histogram.HistogramBuilder;
import org.elasticsearch.search.aggregations.bucket.nested.NestedBuilder;
import org.elasticsearch.search.aggregations.bucket.range.RangeBuilder;
import org.elasticsearch.search.aggregations.bucket.range.date.DateRangeBuilder;
import org.elasticsearch.search.aggregations.bucket.terms.TermsBuilder;
import org.elasticsearch.search.aggregations.metrics.ValuesSourceMetricsAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.avg.AvgBuilder;
import org.elasticsearch.search.aggregations.metrics.cardinality.CardinalityBuilder;
import org.elasticsearch.search.aggregations.metrics.geobounds.GeoBoundsBuilder;
import org.elasticsearch.search.aggregations.metrics.max.MaxBuilder;
import org.elasticsearch.search.aggregations.metrics.min.MinBuilder;
import org.elasticsearch.search.aggregations.metrics.percentiles.PercentilesBuilder;
import org.elasticsearch.search.aggregations.metrics.scripted.ScriptedMetricBuilder;
import org.elasticsearch.search.aggregations.metrics.stats.StatsBuilder;
import org.elasticsearch.search.aggregations.metrics.stats.extended.ExtendedStatsBuilder;
import org.elasticsearch.search.aggregations.metrics.sum.SumBuilder;
import org.elasticsearch.search.aggregations.metrics.tophits.TopHitsBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.nlpcn.es4sql.Util;
import org.nlpcn.es4sql.domain.Field;
import org.nlpcn.es4sql.domain.KVValue;
import org.nlpcn.es4sql.domain.MethodField;
import org.nlpcn.es4sql.domain.Where;
import org.nlpcn.es4sql.exception.SqlParseException;
import org.nlpcn.es4sql.parse.ChildrenType;
import org.nlpcn.es4sql.parse.NestedType;
import org.nlpcn.es4sql.query.maker.QueryMaker;

public class AggMaker {
    private Map<String, KVValue> groupMap = new HashMap<String, KVValue>();
    private static final String TIME_FARMAT = "yyyy-MM-dd HH:mm:ss";

    public AggregationBuilder<?> makeGroupAgg(Field field) throws SqlParseException {
        if (field instanceof MethodField) {
            MethodField methodField = (MethodField)field;
            if (methodField.getName().equals("filter")) {
                Map<String, Object> paramsAsMap = methodField.getParamsAsMap();
                Where where = (Where)paramsAsMap.get("where");
                return AggregationBuilders.filter((String)paramsAsMap.get("alias").toString()).filter((QueryBuilder)QueryMaker.explan(where));
            }
            return this.makeRangeGroup(methodField);
        }
        TermsBuilder termsBuilder = (TermsBuilder)AggregationBuilders.terms((String)field.getName()).field(field.getName());
        this.groupMap.put(field.getName(), new KVValue("KEY", termsBuilder));
        return termsBuilder;
    }

    public AbstractAggregationBuilder makeFieldAgg(MethodField field, AbstractAggregationBuilder parent) throws SqlParseException {
        this.groupMap.put(field.getAlias(), new KVValue("FIELD", parent));
        field.setAlias(this.fixAlias(field.getAlias()));
        switch (field.getName().toUpperCase()) {
            case "SUM": {
                SumBuilder builder = AggregationBuilders.sum((String)field.getAlias());
                return this.addFieldToAgg(field, (ValuesSourceMetricsAggregationBuilder)builder);
            }
            case "MAX": {
                MaxBuilder builder = AggregationBuilders.max((String)field.getAlias());
                return this.addFieldToAgg(field, (ValuesSourceMetricsAggregationBuilder)builder);
            }
            case "MIN": {
                MinBuilder builder = AggregationBuilders.min((String)field.getAlias());
                return this.addFieldToAgg(field, (ValuesSourceMetricsAggregationBuilder)builder);
            }
            case "AVG": {
                AvgBuilder builder = AggregationBuilders.avg((String)field.getAlias());
                return this.addFieldToAgg(field, (ValuesSourceMetricsAggregationBuilder)builder);
            }
            case "STATS": {
                StatsBuilder builder = AggregationBuilders.stats((String)field.getAlias());
                return this.addFieldToAgg(field, (ValuesSourceMetricsAggregationBuilder)builder);
            }
            case "EXTENDED_STATS": {
                ExtendedStatsBuilder builder = AggregationBuilders.extendedStats((String)field.getAlias());
                return this.addFieldToAgg(field, (ValuesSourceMetricsAggregationBuilder)builder);
            }
            case "PERCENTILES": {
                PercentilesBuilder builder = AggregationBuilders.percentiles((String)field.getAlias());
                this.addSpecificPercentiles(builder, field.getParams());
                return this.addFieldToAgg(field, (ValuesSourceMetricsAggregationBuilder)builder);
            }
            case "TOPHITS": {
                return this.makeTopHitsAgg(field);
            }
            case "SCRIPTED_METRIC": {
                return this.scriptedMetric(field);
            }
            case "COUNT": {
                this.groupMap.put(field.getAlias(), new KVValue("COUNT", parent));
                return this.makeCountAgg(field);
            }
        }
        throw new SqlParseException("the agg function not to define !");
    }

    private void addSpecificPercentiles(PercentilesBuilder percentilesBuilder, List<KVValue> params) {
        ArrayList<Double> percentiles = new ArrayList<Double>();
        for (KVValue kValue : params) {
            if (!kValue.value.getClass().equals(BigDecimal.class)) continue;
            BigDecimal percentile = (BigDecimal)kValue.value;
            percentiles.add(percentile.doubleValue());
        }
        if (percentiles.size() > 0) {
            double[] percentilesArr = new double[percentiles.size()];
            int i = 0;
            for (Double percentile : percentiles) {
                percentilesArr[i] = percentile;
                ++i;
            }
            percentilesBuilder.percentiles(percentilesArr);
        }
    }

    private String fixAlias(String alias) {
        return alias.replaceAll("\\[", "(").replaceAll("\\]", ")");
    }

    private AbstractAggregationBuilder addFieldToAgg(MethodField field, ValuesSourceMetricsAggregationBuilder builder) {
        KVValue kvValue = field.getParams().get(0);
        if (kvValue.key != null && kvValue.key.equals("script")) {
            return builder.script(new Script(((MethodField)kvValue.value).getParams().get(1).toString()));
        }
        if (kvValue.key != null && (kvValue.key.equals("nested") || kvValue.key.equals("reverse_nested"))) {
            NestedBuilder nestedBuilder;
            NestedType nestedType = (NestedType)kvValue.value;
            builder.field(nestedType.field);
            String nestedAggName = nestedType.field + "@NESTED";
            if (nestedType.isReverse()) {
                if (nestedType.path != null && nestedType.path.startsWith("~")) {
                    String realPath = nestedType.path.substring(1);
                    NestedBuilder nestedBuilder2 = AggregationBuilders.nested((String)nestedAggName).path(realPath);
                    nestedBuilder2 = nestedBuilder2.subAggregation((AbstractAggregationBuilder)builder);
                    return AggregationBuilders.reverseNested((String)(nestedAggName + "_REVERSED")).subAggregation((AbstractAggregationBuilder)nestedBuilder2);
                }
                nestedBuilder = AggregationBuilders.reverseNested((String)nestedAggName).path(nestedType.path);
            } else {
                nestedBuilder = AggregationBuilders.nested((String)nestedAggName).path(nestedType.path);
            }
            return nestedBuilder.subAggregation((AbstractAggregationBuilder)builder);
        }
        if (kvValue.key != null && kvValue.key.equals("children")) {
            ChildrenType childrenType = (ChildrenType)kvValue.value;
            builder.field(childrenType.field);
            String childrenAggName = childrenType.field + "@CHILDREN";
            ChildrenBuilder childrenBuilder = AggregationBuilders.children((String)childrenAggName).childType(childrenType.childType);
            return childrenBuilder;
        }
        return builder.field(kvValue.toString());
    }

    private AggregationBuilder<?> makeRangeGroup(MethodField field) throws SqlParseException {
        switch (field.getName().toLowerCase()) {
            case "range": {
                return this.rangeBuilder(field);
            }
            case "date_histogram": {
                return this.dateHistogram(field);
            }
            case "date_range": {
                return this.dateRange(field);
            }
            case "month": {
                return this.dateRange(field);
            }
            case "histogram": {
                return this.histogram(field);
            }
            case "geohash_grid": {
                return this.geohashGrid(field);
            }
            case "geo_bounds": {
                return this.geoBounds(field);
            }
            case "terms": {
                return this.termsAgg(field);
            }
        }
        throw new SqlParseException("can define this method " + field);
    }

    private AggregationBuilder<?> geoBounds(MethodField field) throws SqlParseException {
        String aggName = this.gettAggNameFromParamsOrAlias(field);
        GeoBoundsBuilder boundsBuilder = AggregationBuilders.geoBounds((String)aggName);
        String value = null;
        block13: for (KVValue kv : field.getParams()) {
            value = kv.value.toString();
            switch (kv.key.toLowerCase()) {
                case "field": {
                    boundsBuilder.field(value);
                    continue block13;
                }
                case "wrap_longitude": {
                    boundsBuilder.wrapLongitude(Boolean.getBoolean(value));
                    continue block13;
                }
                case "alias": 
                case "nested": 
                case "reverse_nested": 
                case "children": {
                    continue block13;
                }
            }
            throw new SqlParseException("geo_bounds err or not define field " + kv.toString());
        }
        return boundsBuilder;
    }

    private AggregationBuilder<?> termsAgg(MethodField field) throws SqlParseException {
        String aggName = this.gettAggNameFromParamsOrAlias(field);
        TermsBuilder terms = AggregationBuilders.terms((String)aggName);
        String value = null;
        block17: for (KVValue kv : field.getParams()) {
            value = kv.value.toString();
            switch (kv.key.toLowerCase()) {
                case "field": {
                    terms.field(value);
                    continue block17;
                }
                case "size": {
                    terms.size(Integer.parseInt(value));
                    continue block17;
                }
                case "shard_size": {
                    terms.shardSize(Integer.parseInt(value));
                    continue block17;
                }
                case "min_doc_count": {
                    terms.minDocCount((long)Integer.parseInt(value));
                    continue block17;
                }
                case "alias": 
                case "nested": 
                case "reverse_nested": 
                case "children": {
                    continue block17;
                }
            }
            throw new SqlParseException("terms aggregation err or not define field " + kv.toString());
        }
        return terms;
    }

    private AbstractAggregationBuilder scriptedMetric(MethodField field) throws SqlParseException {
        String aggName = this.gettAggNameFromParamsOrAlias(field);
        ScriptedMetricBuilder scriptedMetricBuilder = AggregationBuilders.scriptedMetric((String)aggName);
        Map<String, Object> scriptedMetricParams = field.getParamsAsMap();
        if (!(scriptedMetricParams.containsKey("map_script") || scriptedMetricParams.containsKey("map_script_id") || scriptedMetricParams.containsKey("map_script_file"))) {
            throw new SqlParseException("scripted metric parameters must contain map_script/map_script_id/map_script_file parameter");
        }
        HashMap<String, Object> scriptAdditionalParams = new HashMap<String, Object>();
        HashMap<String, Object> reduceScriptAdditionalParams = new HashMap<String, Object>();
        block33: for (Map.Entry<String, Object> param : scriptedMetricParams.entrySet()) {
            String paramValue = param.getValue().toString();
            if (param.getKey().startsWith("@")) {
                if (param.getKey().startsWith("@reduce_")) {
                    reduceScriptAdditionalParams.put(param.getKey().replace("@reduce_", ""), param.getValue());
                    continue;
                }
                scriptAdditionalParams.put(param.getKey().replace("@", ""), param.getValue());
                continue;
            }
            if (reduceScriptAdditionalParams.size() == 0) {
                reduceScriptAdditionalParams = null;
            }
            switch (param.getKey().toLowerCase()) {
                case "map_script": {
                    scriptedMetricBuilder.mapScript(new Script(paramValue));
                    continue block33;
                }
                case "map_script_id": {
                    scriptedMetricBuilder.mapScript(new Script(paramValue, ScriptService.ScriptType.INDEXED, null, null));
                    continue block33;
                }
                case "map_script_file": {
                    scriptedMetricBuilder.mapScript(new Script(paramValue, ScriptService.ScriptType.FILE, null, null));
                    continue block33;
                }
                case "init_script": {
                    scriptedMetricBuilder.initScript(new Script(paramValue));
                    continue block33;
                }
                case "init_script_id": {
                    scriptedMetricBuilder.initScript(new Script(paramValue, ScriptService.ScriptType.INDEXED, null, null));
                    continue block33;
                }
                case "init_script_file": {
                    scriptedMetricBuilder.initScript(new Script(paramValue, ScriptService.ScriptType.FILE, null, null));
                    continue block33;
                }
                case "combine_script": {
                    scriptedMetricBuilder.combineScript(new Script(paramValue));
                    continue block33;
                }
                case "combine_script_id": {
                    scriptedMetricBuilder.combineScript(new Script(paramValue, ScriptService.ScriptType.INDEXED, null, null));
                    continue block33;
                }
                case "combine_script_file": {
                    scriptedMetricBuilder.combineScript(new Script(paramValue, ScriptService.ScriptType.FILE, null, null));
                    continue block33;
                }
                case "reduce_script": {
                    scriptedMetricBuilder.reduceScript(new Script(paramValue, ScriptService.ScriptType.INLINE, null, reduceScriptAdditionalParams));
                    continue block33;
                }
                case "reduce_script_id": {
                    scriptedMetricBuilder.reduceScript(new Script(paramValue, ScriptService.ScriptType.INDEXED, null, reduceScriptAdditionalParams));
                    continue block33;
                }
                case "reduce_script_file": {
                    scriptedMetricBuilder.reduceScript(new Script(paramValue, ScriptService.ScriptType.FILE, null, reduceScriptAdditionalParams));
                    continue block33;
                }
                case "alias": 
                case "nested": 
                case "reverse_nested": 
                case "children": {
                    continue block33;
                }
            }
            throw new SqlParseException("scripted_metric err or not define field " + param.getKey());
        }
        if (scriptAdditionalParams.size() > 0) {
            scriptAdditionalParams.put("_agg", new HashMap());
            scriptedMetricBuilder.params(scriptAdditionalParams);
        }
        return scriptedMetricBuilder;
    }

    private AggregationBuilder<?> geohashGrid(MethodField field) throws SqlParseException {
        String aggName = this.gettAggNameFromParamsOrAlias(field);
        GeoHashGridBuilder geoHashGrid = AggregationBuilders.geohashGrid((String)aggName);
        String value = null;
        block17: for (KVValue kv : field.getParams()) {
            value = kv.value.toString();
            switch (kv.key.toLowerCase()) {
                case "precision": {
                    geoHashGrid.precision(Integer.parseInt(value));
                    continue block17;
                }
                case "field": {
                    geoHashGrid.field(value);
                    continue block17;
                }
                case "size": {
                    geoHashGrid.size(Integer.parseInt(value));
                    continue block17;
                }
                case "shard_size": {
                    geoHashGrid.shardSize(Integer.parseInt(value));
                    continue block17;
                }
                case "alias": 
                case "nested": 
                case "reverse_nested": 
                case "children": {
                    continue block17;
                }
            }
            throw new SqlParseException("geohash grid err or not define field " + kv.toString());
        }
        return geoHashGrid;
    }

    private ValuesSourceAggregationBuilder<?> dateRange(MethodField field) {
        String alias = this.gettAggNameFromParamsOrAlias(field);
        DateRangeBuilder dateRange = AggregationBuilders.dateRange((String)alias).format(TIME_FARMAT);
        String value = null;
        ArrayList<String> ranges = new ArrayList<String>();
        for (KVValue kv : field.getParams()) {
            value = kv.value.toString();
            if ("field".equals(kv.key)) {
                dateRange.field(value);
                continue;
            }
            if ("format".equals(kv.key)) {
                dateRange.format(value);
                continue;
            }
            if ("from".equals(kv.key)) {
                dateRange.addUnboundedFrom(kv.value);
                continue;
            }
            if ("to".equals(kv.key)) {
                dateRange.addUnboundedTo(kv.value);
                continue;
            }
            if ("alias".equals(kv.key) || "nested".equals(kv.key) || "children".equals(kv.key)) continue;
            ranges.add(value);
        }
        for (int i = 1; i < ranges.size(); ++i) {
            dateRange.addRange(ranges.get(i - 1), ranges.get(i));
        }
        return dateRange;
    }

    private DateHistogramBuilder dateHistogram(MethodField field) throws SqlParseException {
        String alias = this.gettAggNameFromParamsOrAlias(field);
        DateHistogramBuilder dateHistogram = AggregationBuilders.dateHistogram((String)alias).format(TIME_FARMAT);
        String value = null;
        block17: for (KVValue kv : field.getParams()) {
            value = kv.value.toString();
            switch (kv.key.toLowerCase()) {
                case "interval": {
                    dateHistogram.interval(new DateHistogramInterval(kv.value.toString()));
                    continue block17;
                }
                case "field": {
                    dateHistogram.field(value);
                    continue block17;
                }
                case "format": {
                    dateHistogram.format(value);
                    continue block17;
                }
                case "time_zone": {
                    dateHistogram.timeZone(value);
                    continue block17;
                }
                case "alias": 
                case "nested": 
                case "reverse_nested": 
                case "children": {
                    continue block17;
                }
            }
            throw new SqlParseException("date range err or not define field " + kv.toString());
        }
        return dateHistogram;
    }

    private String gettAggNameFromParamsOrAlias(MethodField field) {
        String alias = field.getAlias();
        for (KVValue kv : field.getParams()) {
            if (kv.key == null || !kv.key.equals("alias")) continue;
            alias = kv.value.toString();
        }
        return alias;
    }

    private HistogramBuilder histogram(MethodField field) throws SqlParseException {
        String aggName = this.gettAggNameFromParamsOrAlias(field);
        HistogramBuilder histogram = AggregationBuilders.histogram((String)aggName);
        String value = null;
        block30: for (KVValue kv : field.getParams()) {
            value = kv.value.toString();
            switch (kv.key.toLowerCase()) {
                case "interval": {
                    histogram.interval(Long.parseLong(value));
                    continue block30;
                }
                case "field": {
                    histogram.field(value);
                    continue block30;
                }
                case "min_doc_count": {
                    histogram.minDocCount(Long.parseLong(value));
                    continue block30;
                }
                case "extended_bounds": {
                    String[] bounds = value.split(":");
                    if (bounds.length != 2) continue block30;
                    histogram.extendedBounds(Long.valueOf(bounds[0]), Long.valueOf(bounds[1]));
                    continue block30;
                }
                case "alias": 
                case "nested": 
                case "reverse_nested": 
                case "children": {
                    continue block30;
                }
                case "order": {
                    Histogram.Order order = null;
                    switch (value) {
                        case "key_desc": {
                            order = Histogram.Order.KEY_DESC;
                            break;
                        }
                        case "count_asc": {
                            order = Histogram.Order.COUNT_ASC;
                            break;
                        }
                        case "count_desc": {
                            order = Histogram.Order.COUNT_DESC;
                            break;
                        }
                        default: {
                            order = Histogram.Order.KEY_ASC;
                        }
                    }
                    histogram.order(order);
                    continue block30;
                }
            }
            throw new SqlParseException("histogram err or not define field " + kv.toString());
        }
        return histogram;
    }

    private RangeBuilder rangeBuilder(MethodField field) {
        LinkedList<KVValue> params = new LinkedList<KVValue>(field.getParams());
        String fieldName = params.poll().toString();
        double[] ds = Util.KV2DoubleArr(params);
        RangeBuilder range = (RangeBuilder)AggregationBuilders.range((String)field.getAlias()).field(fieldName);
        for (int i = 1; i < ds.length; ++i) {
            range.addRange(ds[i - 1], ds[i]);
        }
        return range;
    }

    private AbstractAggregationBuilder makeCountAgg(MethodField field) {
        if ("DISTINCT".equals(field.getOption())) {
            CardinalityBuilder builders = (CardinalityBuilder)AggregationBuilders.cardinality((String)field.getAlias()).field(field.getParams().get((int)0).value.toString());
            if (field.getParams().size() > 1) {
                Integer precision_threshold = (Integer)field.getParams().get((int)1).value;
                builders.precisionThreshold((long)precision_threshold.intValue());
            }
            return builders;
        }
        String fieldName = field.getParams().get((int)0).value.toString();
        if ("*".equals(fieldName)) {
            return AggregationBuilders.count((String)field.getAlias()).field("_index");
        }
        return AggregationBuilders.count((String)field.getAlias()).field(fieldName);
    }

    private AbstractAggregationBuilder makeTopHitsAgg(MethodField field) {
        String alias = this.gettAggNameFromParamsOrAlias(field);
        TopHitsBuilder topHits = AggregationBuilders.topHits((String)alias);
        List<KVValue> params = field.getParams();
        block13: for (KVValue kv : params) {
            switch (kv.key) {
                case "from": {
                    topHits.setFrom(((Integer)kv.value).intValue());
                    continue block13;
                }
                case "size": {
                    topHits.setSize(((Integer)kv.value).intValue());
                    continue block13;
                }
                case "alias": 
                case "nested": 
                case "reverse_nested": 
                case "children": {
                    continue block13;
                }
            }
            topHits.addSort(kv.key, SortOrder.valueOf((String)kv.value.toString().toUpperCase()));
        }
        return topHits;
    }

    public Map<String, KVValue> getGroupMap() {
        return this.groupMap;
    }
}

