/*
 * Decompiled with CFR 0.152.
 */
package org.nlpcn.es4sql.query;

import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.admin.indices.get.GetIndexRequest;
import org.elasticsearch.action.admin.indices.get.GetIndexRequestBuilder;
import org.elasticsearch.client.Client;
import org.nlpcn.es4sql.exception.SqlParseException;
import org.nlpcn.es4sql.query.QueryAction;
import org.nlpcn.es4sql.query.SqlElasticRequestBuilder;

public class ShowQueryAction
extends QueryAction {
    private String sql;

    public ShowQueryAction(Client client, String sql) {
        super(client, null);
        this.sql = sql;
    }

    @Override
    public SqlElasticRequestBuilder explain() throws SqlParseException {
        String sql = this.sql.replaceAll("\\s+", " ");
        String indexName = sql.split(" ")[1];
        String type = null;
        if (indexName.contains("/")) {
            String[] indexAndType = indexName.split("\\/");
            indexName = indexAndType[0];
            type = indexAndType[1];
        }
        final GetIndexRequestBuilder indexRequestBuilder = this.client.admin().indices().prepareGetIndex();
        if (!indexName.equals("*")) {
            indexRequestBuilder.addIndices(new String[]{indexName});
            if (type != null && !type.equals("")) {
                indexRequestBuilder.setTypes(new String[]{type});
            }
        }
        indexRequestBuilder.addFeatures(new GetIndexRequest.Feature[]{GetIndexRequest.Feature.MAPPINGS});
        return new SqlElasticRequestBuilder(){

            @Override
            public ActionRequest request() {
                return indexRequestBuilder.request();
            }

            @Override
            public String explain() {
                return indexRequestBuilder.toString();
            }

            @Override
            public ActionResponse get() {
                return indexRequestBuilder.get();
            }

            @Override
            public ActionRequestBuilder getBuilder() {
                return indexRequestBuilder;
            }
        };
    }
}

