/*
 * Decompiled with CFR 0.152.
 */
package org.nlpcn.es4sql.query;

import java.util.ArrayList;
import java.util.Map;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.Client;
import org.elasticsearch.search.highlight.HighlightBuilder;
import org.nlpcn.es4sql.domain.Query;
import org.nlpcn.es4sql.domain.Select;
import org.nlpcn.es4sql.domain.hints.Hint;
import org.nlpcn.es4sql.domain.hints.HintType;
import org.nlpcn.es4sql.exception.SqlParseException;
import org.nlpcn.es4sql.query.SqlElasticRequestBuilder;

public abstract class QueryAction {
    protected Query query;
    protected Client client;

    public QueryAction(Client client, Query query) {
        this.client = client;
        this.query = query;
    }

    public QueryAction(Query query) {
        this.query = query;
    }

    protected void updateRequestWithIndexAndRoutingOptions(Select select, SearchRequestBuilder request) {
        for (Hint hint : select.getHints()) {
            if (hint.getType() == HintType.IGNORE_UNAVAILABLE) {
                request.setIndicesOptions(IndicesOptions.fromOptions((boolean)true, (boolean)false, (boolean)true, (boolean)false, (IndicesOptions)IndicesOptions.strictExpandOpenAndForbidClosed()));
            }
            if (hint.getType() != HintType.ROUTINGS) continue;
            Object[] routings = hint.getParams();
            String[] routingsAsStringArray = new String[routings.length];
            for (int i = 0; i < routings.length; ++i) {
                routingsAsStringArray[i] = routings[i].toString();
            }
            request.setRouting(routingsAsStringArray);
        }
    }

    protected void updateRequestWithHighlight(Select select, SearchRequestBuilder request) {
        for (Hint hint : select.getHints()) {
            HighlightBuilder.Field highlightField;
            if (hint.getType() != HintType.HIGHLIGHT || (highlightField = this.parseHighlightField(hint.getParams())) == null) continue;
            request.addHighlightedField(highlightField);
        }
    }

    protected HighlightBuilder.Field parseHighlightField(Object[] params) {
        if (params == null || params.length == 0 || params.length > 2) {
            // empty if block
        }
        HighlightBuilder.Field field = new HighlightBuilder.Field(params[0].toString());
        if (params.length == 1) {
            return field;
        }
        Map highlightParams = (Map)params[1];
        for (Map.Entry param : highlightParams.entrySet()) {
            switch ((String)param.getKey()) {
                case "type": {
                    field.highlighterType((String)param.getValue());
                    break;
                }
                case "boundary_chars": {
                    field.boundaryChars(this.fromArrayListToCharArray((ArrayList)param.getValue()));
                    break;
                }
                case "boundary_max_scan": {
                    field.boundaryMaxScan(((Integer)param.getValue()).intValue());
                    break;
                }
                case "force_source": {
                    field.forceSource(((Boolean)param.getValue()).booleanValue());
                    break;
                }
                case "fragmenter": {
                    field.fragmenter((String)param.getValue());
                    break;
                }
                case "fragment_offset": {
                    field.fragmentOffset(((Integer)param.getValue()).intValue());
                    break;
                }
                case "fragment_size": {
                    field.fragmentSize(((Integer)param.getValue()).intValue());
                    break;
                }
                case "highlight_filter": {
                    field.highlightFilter(((Boolean)param.getValue()).booleanValue());
                    break;
                }
                case "matched_fields": {
                    field.matchedFields(((ArrayList)param.getValue()).toArray(new String[((ArrayList)param.getValue()).size()]));
                    break;
                }
                case "no_match_size": {
                    field.noMatchSize((Integer)param.getValue());
                    break;
                }
                case "num_of_fragments": {
                    field.numOfFragments(((Integer)param.getValue()).intValue());
                    break;
                }
                case "order": {
                    field.order((String)param.getValue());
                    break;
                }
                case "phrase_limit": {
                    field.phraseLimit((Integer)param.getValue());
                    break;
                }
                case "post_tags": {
                    field.postTags(((ArrayList)param.getValue()).toArray(new String[((ArrayList)param.getValue()).size()]));
                    break;
                }
                case "pre_tags": {
                    field.preTags(((ArrayList)param.getValue()).toArray(new String[((ArrayList)param.getValue()).size()]));
                    break;
                }
                case "require_field_match": {
                    field.requireFieldMatch(((Boolean)param.getValue()).booleanValue());
                }
            }
        }
        return field;
    }

    private char[] fromArrayListToCharArray(ArrayList arrayList) {
        char[] chars = new char[arrayList.size()];
        int i = 0;
        for (Object item : arrayList) {
            chars[i] = item.toString().charAt(0);
            ++i;
        }
        return chars;
    }

    public abstract SqlElasticRequestBuilder explain() throws SqlParseException;

    public SqlElasticRequestBuilder explain(SearchRequestBuilder requestBuilder) throws SqlParseException {
        throw new UnsupportedOperationException("action not support explain");
    }
}

