/*
 * Decompiled with CFR 0.152.
 */
package org.nlpcn.es4sql.query;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.expr.SQLQueryExpr;
import com.alibaba.druid.sql.ast.statement.SQLDeleteStatement;
import com.alibaba.druid.sql.ast.statement.SQLJoinTableSource;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlSelectQueryBlock;
import com.alibaba.druid.sql.dialect.mysql.parser.MySqlStatementParser;
import com.alibaba.druid.sql.parser.Lexer;
import com.alibaba.druid.sql.parser.ParserException;
import com.alibaba.druid.sql.parser.SQLStatementParser;
import com.alibaba.druid.sql.parser.Token;
import java.sql.SQLFeatureNotSupportedException;
import java.util.ArrayList;
import org.elasticsearch.client.Client;
import org.elasticsearch.plugin.nlpcn.ElasticResultHandler;
import org.elasticsearch.plugin.nlpcn.QueryActionElasticExecutor;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.nlpcn.es4sql.domain.Delete;
import org.nlpcn.es4sql.domain.JoinSelect;
import org.nlpcn.es4sql.domain.Select;
import org.nlpcn.es4sql.exception.SqlParseException;
import org.nlpcn.es4sql.parse.ElasticLexer;
import org.nlpcn.es4sql.parse.ElasticSqlExprParser;
import org.nlpcn.es4sql.parse.SqlParser;
import org.nlpcn.es4sql.parse.SubQueryExpression;
import org.nlpcn.es4sql.query.AggregationQueryAction;
import org.nlpcn.es4sql.query.DefaultQueryAction;
import org.nlpcn.es4sql.query.DeleteQueryAction;
import org.nlpcn.es4sql.query.QueryAction;
import org.nlpcn.es4sql.query.ShowQueryAction;
import org.nlpcn.es4sql.query.join.ESJoinQueryActionFactory;

public class ESActionFactory {
    public static QueryAction create(Client client, String sql) throws SqlParseException, SQLFeatureNotSupportedException {
        sql = sql.replaceAll("\n", " ");
        String firstWord = sql.substring(0, sql.indexOf(32));
        switch (firstWord.toUpperCase()) {
            case "SELECT": {
                SQLQueryExpr sqlExpr = (SQLQueryExpr)ESActionFactory.toSqlExpr(sql);
                if (ESActionFactory.isJoin(sqlExpr, sql)) {
                    JoinSelect joinSelect = new SqlParser().parseJoinSelect(sqlExpr);
                    ESActionFactory.handleSubQueries(client, joinSelect.getFirstTable());
                    ESActionFactory.handleSubQueries(client, joinSelect.getSecondTable());
                    return ESJoinQueryActionFactory.createJoinAction(client, joinSelect);
                }
                Select select = new SqlParser().parseSelect(sqlExpr);
                ESActionFactory.handleSubQueries(client, select);
                return ESActionFactory.handleSelect(client, select);
            }
            case "DELETE": {
                SQLStatementParser parser = ESActionFactory.createSqlStatementParser(sql);
                SQLDeleteStatement deleteStatement = parser.parseDeleteStatement();
                Delete delete = new SqlParser().parseDelete(deleteStatement);
                return new DeleteQueryAction(client, delete);
            }
            case "SHOW": {
                return new ShowQueryAction(client, sql);
            }
        }
        throw new SQLFeatureNotSupportedException(String.format("Unsupported query: %s", sql));
    }

    private static void handleSubQueries(Client client, Select select) throws SqlParseException {
        if (select.containsSubQueries()) {
            for (SubQueryExpression subQueryExpression : select.getSubQueries()) {
                QueryAction queryAction = ESActionFactory.handleSelect(client, subQueryExpression.getSelect());
                ESActionFactory.executeAndFillSubQuery(client, subQueryExpression, queryAction);
            }
        }
    }

    private static void executeAndFillSubQuery(Client client, SubQueryExpression subQueryExpression, QueryAction queryAction) throws SqlParseException {
        Object queryResult;
        ArrayList<Object> values = new ArrayList<Object>();
        try {
            queryResult = QueryActionElasticExecutor.executeAnyAction(client, queryAction);
        }
        catch (Exception e) {
            throw new SqlParseException("could not execute SubQuery: " + e.getMessage());
        }
        String returnField = subQueryExpression.getReturnField();
        if (queryResult instanceof SearchHits) {
            SearchHits hits = (SearchHits)queryResult;
            for (SearchHit hit : hits) {
                values.add(ElasticResultHandler.getFieldValue(hit, returnField));
            }
        } else {
            throw new SqlParseException("on sub queries only support queries that return Hits and not aggregations");
        }
        subQueryExpression.setValues(values.toArray());
    }

    private static QueryAction handleSelect(Client client, Select select) {
        if (select.isAgg) {
            return new AggregationQueryAction(client, select);
        }
        return new DefaultQueryAction(client, select);
    }

    private static SQLStatementParser createSqlStatementParser(String sql) {
        ElasticLexer lexer = new ElasticLexer(sql);
        lexer.nextToken();
        return new MySqlStatementParser((Lexer)lexer);
    }

    private static boolean isJoin(SQLQueryExpr sqlExpr, String sql) {
        MySqlSelectQueryBlock query = (MySqlSelectQueryBlock)sqlExpr.getSubQuery().getQuery();
        return query.getFrom() instanceof SQLJoinTableSource && sql.toLowerCase().contains("join");
    }

    private static SQLExpr toSqlExpr(String sql) {
        ElasticSqlExprParser parser = new ElasticSqlExprParser(sql);
        SQLExpr expr = parser.expr();
        if (parser.getLexer().token() != Token.EOF) {
            throw new ParserException("illegal sql expr : " + sql);
        }
        return expr;
    }
}

