/*
 * Decompiled with CFR 0.152.
 */
package org.nlpcn.es4sql.query;

import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.search.sort.SortOrder;
import org.nlpcn.es4sql.domain.Field;
import org.nlpcn.es4sql.domain.KVValue;
import org.nlpcn.es4sql.domain.MethodField;
import org.nlpcn.es4sql.domain.Order;
import org.nlpcn.es4sql.domain.Select;
import org.nlpcn.es4sql.domain.Where;
import org.nlpcn.es4sql.domain.hints.Hint;
import org.nlpcn.es4sql.domain.hints.HintType;
import org.nlpcn.es4sql.exception.SqlParseException;
import org.nlpcn.es4sql.query.QueryAction;
import org.nlpcn.es4sql.query.SqlElasticSearchRequestBuilder;
import org.nlpcn.es4sql.query.maker.QueryMaker;

public class DefaultQueryAction
extends QueryAction {
    private final Select select;
    private SearchRequestBuilder request;

    public DefaultQueryAction(Client client, Select select) {
        super(client, select);
        this.select = select;
    }

    public DefaultQueryAction(Select select) {
        super(select);
        this.select = select;
    }

    @Override
    public SqlElasticSearchRequestBuilder explain() throws SqlParseException {
        SearchRequestBuilder requestBuilder = this.client.prepareSearch(new String[0]);
        return this.explain(requestBuilder);
    }

    @Override
    public SqlElasticSearchRequestBuilder explain(SearchRequestBuilder requestBuilder) throws SqlParseException {
        this.request = requestBuilder;
        this.setIndicesAndTypes();
        this.setFields(this.select.getFields());
        this.setWhere(this.select.getWhere());
        this.setSorts(this.select.getOrderBys());
        this.setLimit(this.select.getOffset(), this.select.getRowCount());
        boolean usedScroll = this.useScrollIfNeeded(this.select.isOrderdSelect());
        if (!usedScroll) {
            this.request.setSearchType(SearchType.DFS_QUERY_THEN_FETCH);
        }
        this.updateRequestWithIndexAndRoutingOptions(this.select, this.request);
        this.updateRequestWithHighlight(this.select, this.request);
        SqlElasticSearchRequestBuilder sqlElasticRequestBuilder = new SqlElasticSearchRequestBuilder(this.request);
        return sqlElasticRequestBuilder;
    }

    private boolean useScrollIfNeeded(boolean existsOrderBy) {
        Hint scrollHint = null;
        for (Hint hint : this.select.getHints()) {
            if (hint.getType() != HintType.USE_SCROLL) continue;
            scrollHint = hint;
            break;
        }
        if (scrollHint != null) {
            int scrollSize = (Integer)scrollHint.getParams()[0];
            int timeoutInMilli = (Integer)scrollHint.getParams()[1];
            if (!existsOrderBy) {
                this.request.setSearchType(SearchType.SCAN);
            }
            this.request.setScroll(new TimeValue((long)timeoutInMilli)).setSize(scrollSize);
        }
        return scrollHint != null;
    }

    private void setIndicesAndTypes() {
        this.request.setIndices(this.query.getIndexArr());
        String[] typeArr = this.query.getTypeArr();
        if (typeArr != null) {
            this.request.setTypes(typeArr);
        }
    }

    private void setFields(List<Field> fields) throws SqlParseException {
        if (this.select.getFields().size() > 0) {
            ArrayList<String> includeFields = new ArrayList<String>();
            ArrayList<String> excludeFields = new ArrayList<String>();
            for (Field field : fields) {
                if (field instanceof MethodField) {
                    MethodField method = (MethodField)field;
                    if (method.getName().toLowerCase().equals("script")) {
                        this.handleScriptField(method);
                        continue;
                    }
                    if (method.getName().equalsIgnoreCase("include")) {
                        for (KVValue kvValue : method.getParams()) {
                            includeFields.add(kvValue.value.toString());
                        }
                        continue;
                    }
                    if (!method.getName().equalsIgnoreCase("exclude")) continue;
                    for (KVValue kvValue : method.getParams()) {
                        excludeFields.add(kvValue.value.toString());
                    }
                    continue;
                }
                if (!(field instanceof Field)) continue;
                includeFields.add(field.getName());
            }
            this.request.setFetchSource(includeFields.toArray(new String[includeFields.size()]), excludeFields.toArray(new String[excludeFields.size()]));
        }
    }

    private void handleScriptField(MethodField method) throws SqlParseException {
        List<KVValue> params = method.getParams();
        if (params.size() == 2) {
            this.request.addScriptField(params.get((int)0).value.toString(), new Script(params.get((int)1).value.toString()));
        } else if (params.size() == 3) {
            this.request.addScriptField(params.get((int)0).value.toString(), new Script(params.get((int)1).value.toString(), ScriptService.ScriptType.INLINE, params.get((int)2).value.toString(), null));
        } else {
            throw new SqlParseException("scripted_field only allows script(name,script) or script(name,lang,script)");
        }
    }

    private void setWhere(Where where) throws SqlParseException {
        if (where != null) {
            BoolQueryBuilder boolQuery = QueryMaker.explan(where);
            this.request.setQuery((QueryBuilder)boolQuery);
        }
    }

    private void setSorts(List<Order> orderBys) {
        for (Order order : orderBys) {
            this.request.addSort(order.getName(), SortOrder.valueOf((String)order.getType()));
        }
    }

    private void setLimit(int from, int size) {
        this.request.setFrom(from);
        if (size > -1) {
            this.request.setSize(size);
        }
    }

    public SearchRequestBuilder getRequestBuilder() {
        return this.request;
    }
}

