/*
 * Decompiled with CFR 0.152.
 */
package org.nlpcn.es4sql.query;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.client.Client;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.bucket.children.ChildrenBuilder;
import org.elasticsearch.search.aggregations.bucket.nested.NestedBuilder;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.nlpcn.es4sql.domain.Field;
import org.nlpcn.es4sql.domain.KVValue;
import org.nlpcn.es4sql.domain.MethodField;
import org.nlpcn.es4sql.domain.Order;
import org.nlpcn.es4sql.domain.Select;
import org.nlpcn.es4sql.domain.Where;
import org.nlpcn.es4sql.domain.hints.Hint;
import org.nlpcn.es4sql.domain.hints.HintType;
import org.nlpcn.es4sql.exception.SqlParseException;
import org.nlpcn.es4sql.query.QueryAction;
import org.nlpcn.es4sql.query.SqlElasticSearchRequestBuilder;
import org.nlpcn.es4sql.query.maker.AggMaker;
import org.nlpcn.es4sql.query.maker.QueryMaker;

public class AggregationQueryAction
extends QueryAction {
    private final Select select;
    private AggMaker aggMaker = new AggMaker();
    private SearchRequestBuilder request;

    public AggregationQueryAction(Client client, Select select) {
        super(client, select);
        this.select = select;
    }

    public AggregationQueryAction(Select select) {
        super(select);
        this.select = select;
    }

    @Override
    public SqlElasticSearchRequestBuilder explain() throws SqlParseException {
        SearchRequestBuilder requestBuilder = this.client.prepareSearch(new String[0]);
        return this.explain(requestBuilder);
    }

    @Override
    public SqlElasticSearchRequestBuilder explain(SearchRequestBuilder requestBuilder) throws SqlParseException {
        this.request = requestBuilder;
        this.setIndicesAndTypes();
        this.setWhere(this.select.getWhere());
        AggregationBuilder<?> lastAgg = null;
        for (List<Field> groupBy : this.select.getGroupBys()) {
            if (groupBy.isEmpty()) continue;
            Field field = groupBy.get(0);
            lastAgg = this.aggMaker.makeGroupAgg(field);
            if (lastAgg != null && lastAgg instanceof TermsBuilder && !(field instanceof MethodField)) {
                ((TermsBuilder)lastAgg).size(this.select.getRowCount());
            }
            if (field.isNested()) {
                AggregationBuilder nestedBuilder = this.createNestedAggregation(field);
                if (this.insertFilterIfExistsAfter(lastAgg, groupBy, nestedBuilder, 1)) {
                    groupBy.remove(1);
                } else {
                    nestedBuilder.subAggregation(lastAgg);
                }
                this.request.addAggregation(this.wrapNestedIfNeeded(nestedBuilder, field.isReverseNested()));
            } else if (field.isChildren()) {
                AggregationBuilder childrenBuilder = this.createChildrenAggregation(field);
                if (this.insertFilterIfExistsAfter(lastAgg, groupBy, childrenBuilder, 1)) {
                    groupBy.remove(1);
                } else {
                    childrenBuilder.subAggregation(lastAgg);
                }
                this.request.addAggregation((AbstractAggregationBuilder)childrenBuilder);
            } else {
                this.request.addAggregation(lastAgg);
            }
            for (int i = 1; i < groupBy.size(); ++i) {
                field = (Field)groupBy.get(i);
                AggregationBuilder<?> subAgg = this.aggMaker.makeGroupAgg(field);
                if (subAgg instanceof TermsBuilder && !(field instanceof MethodField)) {
                    ((TermsBuilder)subAgg).size(0);
                }
                if (field.isNested()) {
                    AggregationBuilder nestedBuilder = this.createNestedAggregation(field);
                    if (this.insertFilterIfExistsAfter(subAgg, groupBy, nestedBuilder, i + 1)) {
                        groupBy.remove(i + 1);
                        ++i;
                    } else {
                        nestedBuilder.subAggregation(subAgg);
                    }
                    lastAgg.subAggregation(this.wrapNestedIfNeeded(nestedBuilder, field.isReverseNested()));
                } else if (field.isChildren()) {
                    AggregationBuilder childrenBuilder = this.createChildrenAggregation(field);
                    if (this.insertFilterIfExistsAfter(subAgg, groupBy, childrenBuilder, i + 1)) {
                        groupBy.remove(i + 1);
                        ++i;
                    } else {
                        childrenBuilder.subAggregation(subAgg);
                    }
                    lastAgg.subAggregation((AbstractAggregationBuilder)childrenBuilder);
                } else {
                    lastAgg.subAggregation(subAgg);
                }
                lastAgg = subAgg;
            }
        }
        Map<String, KVValue> groupMap = this.aggMaker.getGroupMap();
        if (this.select.getFields().size() > 0) {
            this.setFields(this.select.getFields());
            this.explanFields(this.request, this.select.getFields(), lastAgg);
        }
        if (lastAgg != null && this.select.getOrderBys().size() > 0) {
            for (Order order : this.select.getOrderBys()) {
                KVValue temp = groupMap.get(order.getName());
                if (temp != null) {
                    TermsBuilder termsBuilder = (TermsBuilder)temp.value;
                    switch (temp.key) {
                        case "COUNT": {
                            termsBuilder.order(Terms.Order.count((boolean)this.isASC(order)));
                            break;
                        }
                        case "KEY": {
                            termsBuilder.order(Terms.Order.term((boolean)this.isASC(order)));
                            this.request.addSort(order.getName(), SortOrder.valueOf((String)order.getType()));
                            break;
                        }
                        case "FIELD": {
                            termsBuilder.order(Terms.Order.aggregation((String)order.getName(), (boolean)this.isASC(order)));
                            break;
                        }
                        default: {
                            throw new SqlParseException(order.getName() + " can not to order");
                        }
                    }
                    continue;
                }
                this.request.addSort(order.getName(), SortOrder.valueOf((String)order.getType()));
            }
        }
        this.setLimitFromHint(this.select.getHints());
        this.request.setSearchType(SearchType.DEFAULT);
        this.updateRequestWithIndexAndRoutingOptions(this.select, this.request);
        this.updateRequestWithHighlight(this.select, this.request);
        SqlElasticSearchRequestBuilder sqlElasticRequestBuilder = new SqlElasticSearchRequestBuilder(this.request);
        return sqlElasticRequestBuilder;
    }

    private AbstractAggregationBuilder wrapNestedIfNeeded(AggregationBuilder nestedBuilder, boolean reverseNested) {
        if (!reverseNested) {
            return nestedBuilder;
        }
        if (reverseNested && !(nestedBuilder instanceof NestedBuilder)) {
            return nestedBuilder;
        }
        return AggregationBuilders.reverseNested((String)(nestedBuilder.getName() + "_REVERSED")).subAggregation((AbstractAggregationBuilder)nestedBuilder);
    }

    private AggregationBuilder createNestedAggregation(Field field) {
        String nestedPath = field.getNestedPath();
        if (field.isReverseNested()) {
            if (nestedPath == null || !nestedPath.startsWith("~")) {
                return AggregationBuilders.reverseNested((String)this.getNestedAggName(field)).path(nestedPath);
            }
            nestedPath = nestedPath.substring(1);
        }
        NestedBuilder nestedBuilder = AggregationBuilders.nested((String)this.getNestedAggName(field)).path(nestedPath);
        return nestedBuilder;
    }

    private AggregationBuilder createChildrenAggregation(Field field) {
        String childType = field.getChildType();
        ChildrenBuilder childrenBuilder = AggregationBuilders.children((String)this.getChildrenAggName(field)).childType(childType);
        return childrenBuilder;
    }

    private String getNestedAggName(Field field) {
        String nestedPath;
        String prefix = field instanceof MethodField ? ((nestedPath = field.getNestedPath()) != null ? nestedPath : field.getAlias()) : field.getName();
        return prefix + "@NESTED";
    }

    private String getChildrenAggName(Field field) {
        String childType;
        String prefix = field instanceof MethodField ? ((childType = field.getChildType()) != null ? childType : field.getAlias()) : field.getName();
        return prefix + "@CHILDREN";
    }

    private boolean insertFilterIfExistsAfter(AggregationBuilder<?> agg, List<Field> groupBy, AggregationBuilder builder, int nextPosition) throws SqlParseException {
        if (groupBy.size() <= nextPosition) {
            return false;
        }
        Field filterFieldCandidate = groupBy.get(nextPosition);
        if (!(filterFieldCandidate instanceof MethodField)) {
            return false;
        }
        MethodField methodField = (MethodField)filterFieldCandidate;
        if (!methodField.getName().toLowerCase().equals("filter")) {
            return false;
        }
        builder.subAggregation((AbstractAggregationBuilder)this.aggMaker.makeGroupAgg(filterFieldCandidate).subAggregation(agg));
        return true;
    }

    private AggregationBuilder<?> updateAggIfNested(AggregationBuilder<?> lastAgg, Field field) {
        if (field.isNested()) {
            lastAgg = AggregationBuilders.nested((String)(field.getName() + "Nested")).path(field.getNestedPath()).subAggregation(lastAgg);
        }
        return lastAgg;
    }

    private boolean isASC(Order order) {
        return "ASC".equals(order.getType());
    }

    private void setFields(List<Field> fields) {
        if (this.select.getFields().size() > 0) {
            ArrayList<String> includeFields = new ArrayList<String>();
            for (Field field : fields) {
                if (field == null) continue;
                includeFields.add(field.getName());
            }
            this.request.setFetchSource(includeFields.toArray(new String[includeFields.size()]), null);
        }
    }

    private void explanFields(SearchRequestBuilder request, List<Field> fields, AggregationBuilder<?> groupByAgg) throws SqlParseException {
        for (Field field : fields) {
            if (field instanceof MethodField) {
                AbstractAggregationBuilder makeAgg = this.aggMaker.makeFieldAgg((MethodField)field, (AbstractAggregationBuilder)groupByAgg);
                if (groupByAgg != null) {
                    groupByAgg.subAggregation(makeAgg);
                    continue;
                }
                request.addAggregation(makeAgg);
                continue;
            }
            if (field instanceof Field) {
                request.addField(field.getName());
                continue;
            }
            throw new SqlParseException("it did not support this field method " + field);
        }
    }

    private void setWhere(Where where) throws SqlParseException {
        if (where != null) {
            BoolQueryBuilder whereQuery = QueryMaker.explan(where);
            this.request.setQuery((QueryBuilder)whereQuery);
        }
    }

    private void setIndicesAndTypes() {
        this.request.setIndices(this.query.getIndexArr());
        String[] typeArr = this.query.getTypeArr();
        if (typeArr != null) {
            this.request.setTypes(typeArr);
        }
    }

    private void setLimitFromHint(List<Hint> hints) {
        int from = 0;
        int size = 0;
        for (Hint hint : hints) {
            if (hint.getType() != HintType.DOCS_WITH_AGGREGATION) continue;
            Integer[] params = (Integer[])hint.getParams();
            if (params.length > 1) {
                from = params[0];
                size = params[1];
                break;
            }
            if (params.length != 1) break;
            size = params[0];
            break;
        }
        this.request.setFrom(from);
        this.request.setSize(size);
    }
}

