/*
 * Decompiled with CFR 0.152.
 */
package org.nlpcn.es4sql.parse;

import com.alibaba.druid.sql.ast.SQLCommentHint;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLOrderBy;
import com.alibaba.druid.sql.ast.SQLOrderingSpecification;
import com.alibaba.druid.sql.ast.expr.SQLBetweenExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOperator;
import com.alibaba.druid.sql.ast.expr.SQLCharExpr;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLInListExpr;
import com.alibaba.druid.sql.ast.expr.SQLInSubQueryExpr;
import com.alibaba.druid.sql.ast.expr.SQLListExpr;
import com.alibaba.druid.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.druid.sql.ast.expr.SQLNotExpr;
import com.alibaba.druid.sql.ast.expr.SQLNullExpr;
import com.alibaba.druid.sql.ast.expr.SQLNumericLiteralExpr;
import com.alibaba.druid.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.druid.sql.ast.expr.SQLQueryExpr;
import com.alibaba.druid.sql.ast.expr.SQLTextLiteralExpr;
import com.alibaba.druid.sql.ast.expr.SQLVariantRefExpr;
import com.alibaba.druid.sql.ast.statement.SQLDeleteStatement;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLJoinTableSource;
import com.alibaba.druid.sql.ast.statement.SQLSelectGroupByClause;
import com.alibaba.druid.sql.ast.statement.SQLSelectItem;
import com.alibaba.druid.sql.ast.statement.SQLSelectOrderByItem;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.alibaba.druid.sql.dialect.mysql.ast.expr.MySqlSelectGroupByExpr;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlSelectQueryBlock;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nlpcn.es4sql.domain.Condition;
import org.nlpcn.es4sql.domain.Delete;
import org.nlpcn.es4sql.domain.Field;
import org.nlpcn.es4sql.domain.From;
import org.nlpcn.es4sql.domain.JoinSelect;
import org.nlpcn.es4sql.domain.Select;
import org.nlpcn.es4sql.domain.TableOnJoinSelect;
import org.nlpcn.es4sql.domain.Where;
import org.nlpcn.es4sql.domain.hints.Hint;
import org.nlpcn.es4sql.domain.hints.HintFactory;
import org.nlpcn.es4sql.exception.SqlParseException;
import org.nlpcn.es4sql.parse.ChildrenType;
import org.nlpcn.es4sql.parse.FieldMaker;
import org.nlpcn.es4sql.parse.NestedType;
import org.nlpcn.es4sql.parse.SQLParensIdentifierExpr;
import org.nlpcn.es4sql.parse.ScriptFilter;
import org.nlpcn.es4sql.parse.SubQueryExpression;
import org.nlpcn.es4sql.spatial.SpatialParamsFactory;

public class SqlParser {
    public Select parseSelect(SQLQueryExpr mySqlExpr) throws SqlParseException {
        MySqlSelectQueryBlock query = (MySqlSelectQueryBlock)mySqlExpr.getSubQuery().getQuery();
        Select select = this.parseSelect(query);
        return select;
    }

    private Select parseSelect(MySqlSelectQueryBlock query) throws SqlParseException {
        Select select = new Select();
        this.findSelect(query, select, null);
        select.getFrom().addAll(this.findFrom(query.getFrom()));
        select.setWhere(this.findWhere(query.getWhere()));
        select.fillSubQueries();
        select.getHints().addAll(this.parseHints(query.getHints()));
        this.findLimit(query.getLimit(), select);
        this.findOrderBy(query, select);
        this.findGroupBy(query, select);
        return select;
    }

    public Delete parseDelete(SQLDeleteStatement deleteStatement) throws SqlParseException {
        Delete delete = new Delete();
        delete.getFrom().addAll(this.findFrom(deleteStatement.getTableSource()));
        delete.setWhere(this.findWhere(deleteStatement.getWhere()));
        return delete;
    }

    private Where findWhere(SQLExpr where) throws SqlParseException {
        if (where == null) {
            return null;
        }
        Where myWhere = Where.newInstance();
        this.parseWhere(where, myWhere);
        return myWhere;
    }

    private boolean isCond(SQLBinaryOpExpr expr) {
        SQLExpr leftSide = expr.getLeft();
        if (leftSide instanceof SQLMethodInvokeExpr) {
            return this.isAllowedMethodOnConditionLeft((SQLMethodInvokeExpr)leftSide, expr.getOperator());
        }
        return leftSide instanceof SQLIdentifierExpr || leftSide instanceof SQLPropertyExpr || leftSide instanceof SQLVariantRefExpr;
    }

    private boolean isAllowedMethodOnConditionLeft(SQLMethodInvokeExpr method, SQLBinaryOperator operator) {
        return (method.getMethodName().toLowerCase().equals("nested") || method.getMethodName().toLowerCase().equals("children")) && !operator.isLogical();
    }

    public void parseWhere(SQLExpr expr, Where where) throws SqlParseException {
        if (expr instanceof SQLBinaryOpExpr && !this.isCond((SQLBinaryOpExpr)expr)) {
            SQLBinaryOpExpr bExpr = (SQLBinaryOpExpr)expr;
            this.routeCond(bExpr, bExpr.getLeft(), where);
            this.routeCond(bExpr, bExpr.getRight(), where);
        } else if (expr instanceof SQLNotExpr) {
            this.parseWhere(((SQLNotExpr)expr).getExpr(), where);
            this.negateWhere(where);
        } else {
            this.explanCond("AND", expr, where);
        }
    }

    private void routeCond(SQLBinaryOpExpr bExpr, SQLExpr sub, Where where) throws SqlParseException {
        if (sub instanceof SQLBinaryOpExpr && !this.isCond((SQLBinaryOpExpr)sub)) {
            SQLBinaryOpExpr binarySub = (SQLBinaryOpExpr)sub;
            if (binarySub.getOperator().priority != bExpr.getOperator().priority) {
                Where subWhere = new Where(bExpr.getOperator().name);
                where.addWhere(subWhere);
                this.parseWhere((SQLExpr)binarySub, subWhere);
            } else {
                this.parseWhere((SQLExpr)binarySub, where);
            }
        } else if (sub instanceof SQLNotExpr) {
            Where subWhere = new Where(bExpr.getOperator().name);
            where.addWhere(subWhere);
            this.parseWhere(((SQLNotExpr)sub).getExpr(), subWhere);
            this.negateWhere(subWhere);
        } else {
            this.explanCond(bExpr.getOperator().name, sub, where);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void explanCond(String opear, SQLExpr expr, Where where) throws SqlParseException {
        if (expr instanceof SQLBinaryOpExpr) {
            SQLMethodInvokeExpr method;
            String methodName;
            ChildrenType childrenType;
            SQLBinaryOpExpr soExpr = (SQLBinaryOpExpr)expr;
            boolean methodAsOpear = false;
            boolean isNested = false;
            boolean isChildren = false;
            NestedType nestedType = new NestedType();
            if (nestedType.tryFillFromExpr(soExpr.getLeft())) {
                soExpr.setLeft((SQLExpr)new SQLIdentifierExpr(nestedType.field));
                isNested = true;
            }
            if ((childrenType = new ChildrenType()).tryFillFromExpr(soExpr.getLeft())) {
                soExpr.setLeft((SQLExpr)new SQLIdentifierExpr(childrenType.field));
                isChildren = true;
            }
            if (soExpr.getRight() instanceof SQLMethodInvokeExpr && Condition.OPEAR.methodNameToOpear.containsKey(methodName = (method = (SQLMethodInvokeExpr)soExpr.getRight()).getMethodName().toLowerCase())) {
                Object[] methodParametersValue = this.getMethodValuesWithSubQueries(method);
                Condition condition = null;
                condition = isNested ? new Condition(Where.CONN.valueOf(opear), soExpr.getLeft().toString(), Condition.OPEAR.methodNameToOpear.get(methodName), (Object)methodParametersValue, (Object)nestedType) : (isChildren ? new Condition(Where.CONN.valueOf(opear), soExpr.getLeft().toString(), Condition.OPEAR.methodNameToOpear.get(methodName), (Object)methodParametersValue, (Object)childrenType) : new Condition(Where.CONN.valueOf(opear), soExpr.getLeft().toString(), Condition.OPEAR.methodNameToOpear.get(methodName), (Object)methodParametersValue, null));
                where.addWhere(condition);
                return;
            }
            if (methodAsOpear) return;
            Condition condition = null;
            condition = isNested ? new Condition(Where.CONN.valueOf(opear), soExpr.getLeft().toString(), soExpr.getOperator().name, this.parseValue(soExpr.getRight()), (Object)nestedType) : (isChildren ? new Condition(Where.CONN.valueOf(opear), soExpr.getLeft().toString(), soExpr.getOperator().name, this.parseValue(soExpr.getRight()), (Object)childrenType) : new Condition(Where.CONN.valueOf(opear), soExpr.getLeft().toString(), soExpr.getOperator().name, this.parseValue(soExpr.getRight()), null));
            where.addWhere(condition);
            return;
        } else if (expr instanceof SQLInListExpr) {
            ChildrenType childrenType;
            SQLInListExpr siExpr = (SQLInListExpr)expr;
            String leftSide = siExpr.getExpr().toString();
            boolean isNested = false;
            boolean isChildren = false;
            NestedType nestedType = new NestedType();
            if (nestedType.tryFillFromExpr(siExpr.getExpr())) {
                leftSide = nestedType.field;
                isNested = false;
            }
            if ((childrenType = new ChildrenType()).tryFillFromExpr(siExpr.getExpr())) {
                leftSide = childrenType.field;
                isChildren = true;
            }
            Condition condition = null;
            condition = isNested ? new Condition(Where.CONN.valueOf(opear), leftSide, siExpr.isNot() ? "NOT IN" : "IN", (Object)this.parseValue(siExpr.getTargetList()), (Object)nestedType) : (isChildren ? new Condition(Where.CONN.valueOf(opear), leftSide, siExpr.isNot() ? "NOT IN" : "IN", (Object)this.parseValue(siExpr.getTargetList()), (Object)childrenType) : new Condition(Where.CONN.valueOf(opear), leftSide, siExpr.isNot() ? "NOT IN" : "IN", (Object)this.parseValue(siExpr.getTargetList()), null));
            where.addWhere(condition);
            return;
        } else if (expr instanceof SQLBetweenExpr) {
            ChildrenType childrenType;
            SQLBetweenExpr between = (SQLBetweenExpr)expr;
            String leftSide = between.getTestExpr().toString();
            boolean isNested = false;
            boolean isChildren = false;
            NestedType nestedType = new NestedType();
            if (nestedType.tryFillFromExpr(between.getTestExpr())) {
                leftSide = nestedType.field;
                isNested = true;
            }
            if ((childrenType = new ChildrenType()).tryFillFromExpr(between.getTestExpr())) {
                leftSide = childrenType.field;
                isChildren = true;
            }
            Condition condition = null;
            condition = isNested ? new Condition(Where.CONN.valueOf(opear), leftSide, between.isNot() ? "NOT BETWEEN" : "BETWEEN", (Object)new Object[]{this.parseValue(between.beginExpr), this.parseValue(between.endExpr)}, (Object)nestedType) : (isChildren ? new Condition(Where.CONN.valueOf(opear), leftSide, between.isNot() ? "NOT BETWEEN" : "BETWEEN", (Object)new Object[]{this.parseValue(between.beginExpr), this.parseValue(between.endExpr)}, (Object)childrenType) : new Condition(Where.CONN.valueOf(opear), leftSide, between.isNot() ? "NOT BETWEEN" : "BETWEEN", (Object)new Object[]{this.parseValue(between.beginExpr), this.parseValue(between.endExpr)}, null));
            where.addWhere(condition);
            return;
        } else if (expr instanceof SQLMethodInvokeExpr) {
            SQLMethodInvokeExpr methodExpr = (SQLMethodInvokeExpr)expr;
            List methodParameters = methodExpr.getParameters();
            String methodName = methodExpr.getMethodName();
            if (SpatialParamsFactory.isAllowedMethod(methodName)) {
                ChildrenType childrenType;
                String fieldName = ((SQLExpr)methodParameters.get(0)).toString();
                boolean isNested = false;
                boolean isChildren = false;
                NestedType nestedType = new NestedType();
                if (nestedType.tryFillFromExpr((SQLExpr)methodParameters.get(0))) {
                    fieldName = nestedType.field;
                    isNested = true;
                }
                if ((childrenType = new ChildrenType()).tryFillFromExpr((SQLExpr)methodParameters.get(0))) {
                    fieldName = childrenType.field;
                    isChildren = true;
                }
                Object spatialParamsObject = SpatialParamsFactory.generateSpatialParamsObject(methodName, methodParameters);
                Condition condition = null;
                condition = isNested ? new Condition(Where.CONN.valueOf(opear), fieldName, methodName, spatialParamsObject, (Object)nestedType) : (isChildren ? new Condition(Where.CONN.valueOf(opear), fieldName, methodName, spatialParamsObject, (Object)childrenType) : new Condition(Where.CONN.valueOf(opear), fieldName, methodName, spatialParamsObject, null));
                where.addWhere(condition);
                return;
            } else if (methodName.toLowerCase().equals("nested")) {
                NestedType nestedType = new NestedType();
                if (!nestedType.tryFillFromExpr(expr)) {
                    throw new SqlParseException("could not fill nested from expr:" + expr);
                }
                Condition condition = new Condition(Where.CONN.valueOf(opear), nestedType.path, methodName.toUpperCase(), (Object)nestedType.where);
                where.addWhere(condition);
                return;
            } else if (methodName.toLowerCase().equals("children")) {
                ChildrenType childrenType = new ChildrenType();
                if (!childrenType.tryFillFromExpr(expr)) {
                    throw new SqlParseException("could not fill children from expr:" + expr);
                }
                Condition condition = new Condition(Where.CONN.valueOf(opear), childrenType.childType, methodName.toUpperCase(), (Object)childrenType.where);
                where.addWhere(condition);
                return;
            } else {
                if (!methodName.toLowerCase().equals("script")) throw new SqlParseException("unsupported method: " + methodName);
                ScriptFilter scriptFilter = new ScriptFilter();
                if (!scriptFilter.tryParseFromMethodExpr(methodExpr)) {
                    throw new SqlParseException("could not parse script filter");
                }
                Condition condition = new Condition(Where.CONN.valueOf(opear), null, "SCRIPT", (Object)scriptFilter);
                where.addWhere(condition);
            }
            return;
        } else {
            ChildrenType childrenType;
            if (!(expr instanceof SQLInSubQueryExpr)) throw new SqlParseException("err find condition " + expr.getClass());
            SQLInSubQueryExpr sqlIn = (SQLInSubQueryExpr)expr;
            Select innerSelect = this.parseSelect((MySqlSelectQueryBlock)sqlIn.getSubQuery().getQuery());
            if (innerSelect.getFields() == null) throw new SqlParseException("should only have one return field in subQuery");
            if (innerSelect.getFields().size() != 1) {
                throw new SqlParseException("should only have one return field in subQuery");
            }
            SubQueryExpression subQueryExpression = new SubQueryExpression(innerSelect);
            String leftSide = sqlIn.getExpr().toString();
            boolean isNested = false;
            boolean isChildren = false;
            NestedType nestedType = new NestedType();
            if (nestedType.tryFillFromExpr(sqlIn.getExpr())) {
                leftSide = nestedType.field;
                isNested = true;
            }
            if ((childrenType = new ChildrenType()).tryFillFromExpr(sqlIn.getExpr())) {
                leftSide = childrenType.field;
                isChildren = true;
            }
            Condition condition = null;
            condition = isNested ? new Condition(Where.CONN.valueOf(opear), leftSide, sqlIn.isNot() ? "NOT IN" : "IN", (Object)subQueryExpression, (Object)nestedType) : (isChildren ? new Condition(Where.CONN.valueOf(opear), leftSide, sqlIn.isNot() ? "NOT IN" : "IN", (Object)subQueryExpression, (Object)childrenType) : new Condition(Where.CONN.valueOf(opear), leftSide, sqlIn.isNot() ? "NOT IN" : "IN", (Object)subQueryExpression, null));
            where.addWhere(condition);
        }
    }

    private Object[] getMethodValuesWithSubQueries(SQLMethodInvokeExpr method) throws SqlParseException {
        ArrayList<Object> values = new ArrayList<Object>();
        for (SQLExpr innerExpr : method.getParameters()) {
            if (innerExpr instanceof SQLQueryExpr) {
                Select select = this.parseSelect((MySqlSelectQueryBlock)((SQLQueryExpr)innerExpr).getSubQuery().getQuery());
                values.add(new SubQueryExpression(select));
                continue;
            }
            if (innerExpr instanceof SQLTextLiteralExpr) {
                values.add(((SQLTextLiteralExpr)innerExpr).getText());
                continue;
            }
            values.add(innerExpr);
        }
        return values.toArray();
    }

    private Object[] parseValue(List<SQLExpr> targetList) throws SqlParseException {
        Object[] value = new Object[targetList.size()];
        for (int i = 0; i < targetList.size(); ++i) {
            value[i] = this.parseValue(targetList.get(i));
        }
        return value;
    }

    private Object parseValue(SQLExpr expr) throws SqlParseException {
        if (expr instanceof SQLNumericLiteralExpr) {
            return ((SQLNumericLiteralExpr)expr).getNumber();
        }
        if (expr instanceof SQLCharExpr) {
            return ((SQLCharExpr)expr).getText();
        }
        if (expr instanceof SQLMethodInvokeExpr) {
            return expr;
        }
        if (expr instanceof SQLNullExpr) {
            return null;
        }
        if (expr instanceof SQLIdentifierExpr) {
            return expr;
        }
        if (expr instanceof SQLPropertyExpr) {
            return expr;
        }
        throw new SqlParseException(String.format("Failed to parse SqlExpression of type %s. expression value: %s", expr.getClass(), expr));
    }

    private void findSelect(MySqlSelectQueryBlock query, Select select, String tableAlias) throws SqlParseException {
        List selectList = query.getSelectList();
        for (SQLSelectItem sqlSelectItem : selectList) {
            Field field = FieldMaker.makeField(sqlSelectItem.getExpr(), sqlSelectItem.getAlias(), tableAlias);
            select.addField(field);
        }
    }

    private void findGroupBy(MySqlSelectQueryBlock query, Select select) throws SqlParseException {
        SQLSelectGroupByClause groupBy = query.getGroupBy();
        if (groupBy == null) {
            return;
        }
        List items = groupBy.getItems();
        ArrayList<SQLExpr> standardGroupBys = new ArrayList<SQLExpr>();
        for (SQLExpr sqlExpr : items) {
            if (sqlExpr instanceof MySqlSelectGroupByExpr) {
                MySqlSelectGroupByExpr sqlSelectGroupByExpr = (MySqlSelectGroupByExpr)sqlExpr;
                sqlExpr = sqlSelectGroupByExpr.getExpr();
            }
            if ((sqlExpr instanceof SQLParensIdentifierExpr || !(sqlExpr instanceof SQLIdentifierExpr) && !(sqlExpr instanceof SQLMethodInvokeExpr)) && !standardGroupBys.isEmpty()) {
                select.addGroupBy(this.convertExprsToFields(standardGroupBys));
                standardGroupBys = new ArrayList();
            }
            if (sqlExpr instanceof SQLParensIdentifierExpr) {
                select.addGroupBy(FieldMaker.makeField(sqlExpr, null, null));
                continue;
            }
            if (sqlExpr instanceof SQLListExpr) {
                SQLListExpr listExpr = (SQLListExpr)sqlExpr;
                select.addGroupBy(this.convertExprsToFields(listExpr.getItems()));
                continue;
            }
            standardGroupBys.add(sqlExpr);
        }
        if (!standardGroupBys.isEmpty()) {
            select.addGroupBy(this.convertExprsToFields(standardGroupBys));
        }
    }

    private List<Field> convertExprsToFields(List<? extends SQLExpr> exprs) throws SqlParseException {
        ArrayList<Field> fields = new ArrayList<Field>(exprs.size());
        for (SQLExpr sQLExpr : exprs) {
            fields.add(FieldMaker.makeField(sQLExpr, null, null));
        }
        return fields;
    }

    private String sameAliasWhere(Where where, String ... aliases) throws SqlParseException {
        if (where == null) {
            return null;
        }
        if (where instanceof Condition) {
            Condition condition = (Condition)where;
            String fieldName = condition.getName();
            for (String alias : aliases) {
                String prefix = alias + ".";
                if (!fieldName.startsWith(prefix)) continue;
                return alias;
            }
            throw new SqlParseException(String.format("fieldName : %s on codition:%s does not contain alias", fieldName, condition.toString()));
        }
        ArrayList<String> sameAliases = new ArrayList<String>();
        if (where.getWheres() != null && where.getWheres().size() > 0) {
            for (Where innerWhere : where.getWheres()) {
                sameAliases.add(this.sameAliasWhere(innerWhere, aliases));
            }
        }
        if (sameAliases.contains(null)) {
            return null;
        }
        String firstAlias = (String)sameAliases.get(0);
        for (String alias : sameAliases) {
            if (alias.equals(firstAlias)) continue;
            return null;
        }
        return firstAlias;
    }

    private void findOrderBy(MySqlSelectQueryBlock query, Select select) throws SqlParseException {
        SQLOrderBy orderBy = query.getOrderBy();
        if (orderBy == null) {
            return;
        }
        List items = orderBy.getItems();
        this.addOrderByToSelect(select, items, null);
    }

    private void addOrderByToSelect(Select select, List<SQLSelectOrderByItem> items, String alias) throws SqlParseException {
        for (SQLSelectOrderByItem sqlSelectOrderByItem : items) {
            SQLExpr expr = sqlSelectOrderByItem.getExpr();
            String orderByName = FieldMaker.makeField(expr, null, null).toString();
            if (sqlSelectOrderByItem.getType() == null) {
                sqlSelectOrderByItem.setType(SQLOrderingSpecification.ASC);
            }
            String type = sqlSelectOrderByItem.getType().toString();
            orderByName = orderByName.replace("`", "");
            if (alias != null) {
                orderByName = orderByName.replaceFirst(alias + "\\.", "");
            }
            select.addOrderBy(orderByName, type);
        }
    }

    private void findLimit(MySqlSelectQueryBlock.Limit limit, Select select) {
        if (limit == null) {
            return;
        }
        select.setRowCount(Integer.parseInt(limit.getRowCount().toString()));
        if (limit.getOffset() != null) {
            select.setOffset(Integer.parseInt(limit.getOffset().toString()));
        }
    }

    private List<From> findFrom(SQLTableSource from) {
        boolean isSqlExprTable = from.getClass().isAssignableFrom(SQLExprTableSource.class);
        if (isSqlExprTable) {
            SQLExprTableSource fromExpr = (SQLExprTableSource)from;
            String[] split = fromExpr.getExpr().toString().split(",");
            ArrayList<From> fromList = new ArrayList<From>();
            for (String source : split) {
                fromList.add(new From(source.trim(), fromExpr.getAlias()));
            }
            return fromList;
        }
        SQLJoinTableSource joinTableSource = (SQLJoinTableSource)from;
        ArrayList<From> fromList = new ArrayList<From>();
        fromList.addAll(this.findFrom(joinTableSource.getLeft()));
        fromList.addAll(this.findFrom(joinTableSource.getRight()));
        return fromList;
    }

    public JoinSelect parseJoinSelect(SQLQueryExpr sqlExpr) throws SqlParseException {
        MySqlSelectQueryBlock query = (MySqlSelectQueryBlock)sqlExpr.getSubQuery().getQuery();
        List<From> joinedFrom = this.findJoinedFrom(query.getFrom());
        if (joinedFrom.size() != 2) {
            throw new RuntimeException("currently supports only 2 tables join");
        }
        JoinSelect joinSelect = this.createBasicJoinSelectAccordingToTableSource((SQLJoinTableSource)query.getFrom());
        List<Hint> hints = this.parseHints(query.getHints());
        joinSelect.setHints(hints);
        String firstTableAlias = joinedFrom.get(0).getAlias();
        String secondTableAlias = joinedFrom.get(1).getAlias();
        Map<String, Where> aliasToWhere = this.splitAndFindWhere(query.getWhere(), firstTableAlias, secondTableAlias);
        Map<String, List<SQLSelectOrderByItem>> aliasToOrderBy = this.splitAndFindOrder(query.getOrderBy(), firstTableAlias, secondTableAlias);
        List<Condition> connectedConditions = this.getConditionsFlatten(joinSelect.getConnectedWhere());
        joinSelect.setConnectedConditions(connectedConditions);
        this.fillTableSelectedJoin(joinSelect.getFirstTable(), query, joinedFrom.get(0), aliasToWhere.get(firstTableAlias), aliasToOrderBy.get(firstTableAlias), connectedConditions);
        this.fillTableSelectedJoin(joinSelect.getSecondTable(), query, joinedFrom.get(1), aliasToWhere.get(secondTableAlias), aliasToOrderBy.get(secondTableAlias), connectedConditions);
        this.updateJoinLimit(query.getLimit(), joinSelect);
        return joinSelect;
    }

    private Map<String, List<SQLSelectOrderByItem>> splitAndFindOrder(SQLOrderBy orderBy, String firstTableAlias, String secondTableAlias) throws SqlParseException {
        HashMap<String, List<SQLSelectOrderByItem>> aliasToOrderBys = new HashMap<String, List<SQLSelectOrderByItem>>();
        aliasToOrderBys.put(firstTableAlias, new ArrayList());
        aliasToOrderBys.put(secondTableAlias, new ArrayList());
        if (orderBy == null) {
            return aliasToOrderBys;
        }
        List orderByItems = orderBy.getItems();
        for (SQLSelectOrderByItem orderByItem : orderByItems) {
            if (orderByItem.getExpr().toString().startsWith(firstTableAlias + ".")) {
                ((List)aliasToOrderBys.get(firstTableAlias)).add(orderByItem);
                continue;
            }
            if (orderByItem.getExpr().toString().startsWith(secondTableAlias + ".")) {
                ((List)aliasToOrderBys.get(secondTableAlias)).add(orderByItem);
                continue;
            }
            throw new SqlParseException("order by field on join request should have alias before, got " + orderByItem.getExpr().toString());
        }
        return aliasToOrderBys;
    }

    private void updateJoinLimit(MySqlSelectQueryBlock.Limit limit, JoinSelect joinSelect) {
        if (limit != null && limit.getRowCount() != null) {
            int sizeLimit = Integer.parseInt(limit.getRowCount().toString());
            joinSelect.setTotalLimit(sizeLimit);
        }
    }

    private List<Hint> parseHints(List<SQLCommentHint> sqlHints) throws SqlParseException {
        ArrayList<Hint> hints = new ArrayList<Hint>();
        for (SQLCommentHint sqlHint : sqlHints) {
            Hint hint = HintFactory.getHintFromString(sqlHint.getText());
            if (hint == null) continue;
            hints.add(hint);
        }
        return hints;
    }

    private JoinSelect createBasicJoinSelectAccordingToTableSource(SQLJoinTableSource joinTableSource) throws SqlParseException {
        JoinSelect joinSelect = new JoinSelect();
        if (joinTableSource.getCondition() != null) {
            Where where = Where.newInstance();
            this.parseWhere(joinTableSource.getCondition(), where);
            joinSelect.setConnectedWhere(where);
        }
        SQLJoinTableSource.JoinType joinType = joinTableSource.getJoinType();
        joinSelect.setJoinType(joinType);
        return joinSelect;
    }

    private Map<String, Where> splitAndFindWhere(SQLExpr whereExpr, String firstTableAlias, String secondTableAlias) throws SqlParseException {
        Where where = this.findWhere(whereExpr);
        return this.splitWheres(where, firstTableAlias, secondTableAlias);
    }

    private void fillTableSelectedJoin(TableOnJoinSelect tableOnJoin, MySqlSelectQueryBlock query, From tableFrom, Where where, List<SQLSelectOrderByItem> orderBys, List<Condition> conditions) throws SqlParseException {
        String alias = tableFrom.getAlias();
        this.fillBasicTableSelectJoin(tableOnJoin, tableFrom, where, orderBys, query);
        tableOnJoin.setConnectedFields(this.getConnectedFields(conditions, alias));
        tableOnJoin.setSelectedFields(new ArrayList<Field>(tableOnJoin.getFields()));
        tableOnJoin.setAlias(alias);
        tableOnJoin.fillSubQueries();
    }

    private List<Field> getConnectedFields(List<Condition> conditions, String alias) throws SqlParseException {
        ArrayList<Field> fields = new ArrayList<Field>();
        String prefix = alias + ".";
        for (Condition condition : conditions) {
            int indexOfDot;
            if (condition.getName().startsWith(prefix)) {
                fields.add(new Field(condition.getName().replaceFirst(prefix, ""), null));
                continue;
            }
            if (!(condition.getValue() instanceof SQLPropertyExpr || condition.getValue() instanceof SQLIdentifierExpr || condition.getValue() instanceof String)) {
                throw new SqlParseException("conditions on join should be one side is firstTable second Other , condition was:" + condition.toString());
            }
            String aliasDotValue = condition.getValue().toString();
            String owner = aliasDotValue.substring(0, indexOfDot = aliasDotValue.indexOf("."));
            if (!owner.equals(alias)) continue;
            fields.add(new Field(aliasDotValue.substring(indexOfDot + 1), null));
        }
        return fields;
    }

    private void fillBasicTableSelectJoin(TableOnJoinSelect select, From from, Where where, List<SQLSelectOrderByItem> orderBys, MySqlSelectQueryBlock query) throws SqlParseException {
        select.getFrom().add(from);
        this.findSelect(query, select, from.getAlias());
        select.setWhere(where);
        this.addOrderByToSelect(select, orderBys, from.getAlias());
    }

    private List<Condition> getJoinConditionsFlatten(SQLJoinTableSource from) throws SqlParseException {
        ArrayList<Condition> conditions = new ArrayList<Condition>();
        if (from.getCondition() == null) {
            return conditions;
        }
        Where where = Where.newInstance();
        this.parseWhere(from.getCondition(), where);
        this.addIfConditionRecursive(where, conditions);
        return conditions;
    }

    private List<Condition> getConditionsFlatten(Where where) throws SqlParseException {
        ArrayList<Condition> conditions = new ArrayList<Condition>();
        if (where == null) {
            return conditions;
        }
        this.addIfConditionRecursive(where, conditions);
        return conditions;
    }

    private Map<String, Where> splitWheres(Where where, String ... aliases) throws SqlParseException {
        HashMap<String, Where> aliasToWhere = new HashMap<String, Where>();
        for (String alias : aliases) {
            aliasToWhere.put(alias, null);
        }
        if (where == null) {
            return aliasToWhere;
        }
        String allWhereFromSameAlias = this.sameAliasWhere(where, aliases);
        if (allWhereFromSameAlias != null) {
            this.removeAliasPrefix(where, allWhereFromSameAlias);
            aliasToWhere.put(allWhereFromSameAlias, where);
            return aliasToWhere;
        }
        for (Where innerWhere : where.getWheres()) {
            String sameAlias = this.sameAliasWhere(innerWhere, aliases);
            if (sameAlias == null) {
                throw new SqlParseException("Currently support only one hierarchy on different tables where");
            }
            this.removeAliasPrefix(innerWhere, sameAlias);
            Where aliasCurrentWhere = (Where)aliasToWhere.get(sameAlias);
            if (aliasCurrentWhere == null) {
                aliasToWhere.put(sameAlias, innerWhere);
                continue;
            }
            Where andWhereContainer = Where.newInstance();
            andWhereContainer.addWhere(aliasCurrentWhere);
            andWhereContainer.addWhere(innerWhere);
            aliasToWhere.put(sameAlias, andWhereContainer);
        }
        return aliasToWhere;
    }

    private void removeAliasPrefix(Where where, String alias) {
        if (where instanceof Condition) {
            Condition cond = (Condition)where;
            String fieldName = cond.getName();
            String aliasPrefix = alias + ".";
            cond.setName(cond.getName().replaceFirst(aliasPrefix, ""));
            return;
        }
        for (Where innerWhere : where.getWheres()) {
            this.removeAliasPrefix(innerWhere, alias);
        }
    }

    private void addIfConditionRecursive(Where where, List<Condition> conditions) throws SqlParseException {
        if (where instanceof Condition) {
            Condition cond = (Condition)where;
            if (!(cond.getValue() instanceof SQLIdentifierExpr || cond.getValue() instanceof SQLPropertyExpr || cond.getValue() instanceof String)) {
                throw new SqlParseException("conditions on join should be one side is secondTable OPEAR firstTable, condition was:" + cond.toString());
            }
            conditions.add(cond);
        }
        for (Where innerWhere : where.getWheres()) {
            this.addIfConditionRecursive(innerWhere, conditions);
        }
    }

    private List<From> findJoinedFrom(SQLTableSource from) {
        SQLJoinTableSource joinTableSource = (SQLJoinTableSource)from;
        ArrayList<From> fromList = new ArrayList<From>();
        fromList.addAll(this.findFrom(joinTableSource.getLeft()));
        fromList.addAll(this.findFrom(joinTableSource.getRight()));
        return fromList;
    }

    private void negateWhere(Where where) throws SqlParseException {
        for (Where sub : where.getWheres()) {
            if (sub instanceof Condition) {
                Condition cond = (Condition)sub;
                cond.setOpear(cond.getOpear().negative());
            } else {
                this.negateWhere(sub);
            }
            sub.setConn(sub.getConn().negative());
        }
    }
}

