/*
 * Decompiled with CFR 0.152.
 */
package org.nlpcn.es4sql.parse;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.expr.SQLAggregateExpr;
import com.alibaba.druid.sql.ast.expr.SQLAggregateOption;
import com.alibaba.druid.sql.ast.expr.SQLAllColumnExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLCharExpr;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.druid.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.druid.sql.ast.expr.SQLQueryExpr;
import com.alibaba.druid.sql.ast.expr.SQLValuableExpr;
import com.alibaba.druid.sql.ast.expr.SQLVariantRefExpr;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.nlpcn.es4sql.Util;
import org.nlpcn.es4sql.domain.Field;
import org.nlpcn.es4sql.domain.KVValue;
import org.nlpcn.es4sql.domain.MethodField;
import org.nlpcn.es4sql.domain.Where;
import org.nlpcn.es4sql.exception.SqlParseException;
import org.nlpcn.es4sql.parse.ChildrenType;
import org.nlpcn.es4sql.parse.NestedType;
import org.nlpcn.es4sql.parse.SqlParser;

public class FieldMaker {
    public static Field makeField(SQLExpr expr, String alias, String tableAlias) throws SqlParseException {
        if (expr instanceof SQLIdentifierExpr || expr instanceof SQLPropertyExpr || expr instanceof SQLVariantRefExpr) {
            return FieldMaker.handleIdentifier(expr, alias, tableAlias);
        }
        if (expr instanceof SQLQueryExpr) {
            throw new SqlParseException("unknow field name : " + expr);
        }
        if (expr instanceof SQLBinaryOpExpr) {
            return FieldMaker.makeScriptMethodField((SQLBinaryOpExpr)expr, alias);
        }
        if (!(expr instanceof SQLAllColumnExpr)) {
            if (expr instanceof SQLMethodInvokeExpr) {
                SQLMethodInvokeExpr mExpr = (SQLMethodInvokeExpr)expr;
                String methodName = mExpr.getMethodName();
                if (methodName.equalsIgnoreCase("nested") || methodName.equalsIgnoreCase("reverse_nested")) {
                    NestedType nestedType = new NestedType();
                    if (nestedType.tryFillFromExpr((SQLExpr)mExpr)) {
                        return FieldMaker.handleIdentifier(nestedType, alias, tableAlias);
                    }
                } else if (methodName.equalsIgnoreCase("children")) {
                    ChildrenType childrenType = new ChildrenType();
                    if (childrenType.tryFillFromExpr((SQLExpr)mExpr)) {
                        return FieldMaker.handleIdentifier(childrenType, alias, tableAlias);
                    }
                } else if (methodName.equalsIgnoreCase("filter")) {
                    return FieldMaker.makeFilterMethodField(mExpr, alias);
                }
                return FieldMaker.makeMethodField(methodName, mExpr.getParameters(), null, alias);
            }
            if (expr instanceof SQLAggregateExpr) {
                SQLAggregateExpr sExpr = (SQLAggregateExpr)expr;
                return FieldMaker.makeMethodField(sExpr.getMethodName(), sExpr.getArguments(), sExpr.getOption(), alias);
            }
            throw new SqlParseException("unknown field name : " + expr);
        }
        return null;
    }

    private static Field makeFilterMethodField(SQLMethodInvokeExpr filterMethod, String alias) throws SqlParseException {
        List parameters = filterMethod.getParameters();
        int parametersSize = parameters.size();
        if (parametersSize != 1 && parametersSize != 2) {
            throw new SqlParseException("filter group by field should only have one or 2 parameters filter(Expr) or filter(name,Expr)");
        }
        String filterAlias = filterMethod.getMethodName();
        SQLExpr exprToCheck = null;
        if (parametersSize == 1) {
            exprToCheck = (SQLExpr)parameters.get(0);
            filterAlias = "filter(" + exprToCheck.toString().replaceAll("\n", " ") + ")";
        }
        if (parametersSize == 2) {
            filterAlias = Util.extendedToString((SQLExpr)parameters.get(0));
            exprToCheck = (SQLExpr)parameters.get(1);
        }
        Where where = Where.newInstance();
        new SqlParser().parseWhere(exprToCheck, where);
        if (where.getWheres().size() == 0) {
            throw new SqlParseException("unable to parse filter where.");
        }
        ArrayList<KVValue> methodParameters = new ArrayList<KVValue>();
        methodParameters.add(new KVValue("where", where));
        methodParameters.add(new KVValue("alias", filterAlias + "@FILTER"));
        return new MethodField("filter", methodParameters, null, alias);
    }

    private static Field handleIdentifier(NestedType nestedType, String alias, String tableAlias) {
        Field field = FieldMaker.handleIdentifier((SQLExpr)new SQLIdentifierExpr(nestedType.field), alias, tableAlias);
        field.setNested(nestedType);
        field.setChildren(null);
        return field;
    }

    private static Field handleIdentifier(ChildrenType childrenType, String alias, String tableAlias) {
        Field field = FieldMaker.handleIdentifier((SQLExpr)new SQLIdentifierExpr(childrenType.field), alias, tableAlias);
        field.setNested(null);
        field.setChildren(childrenType);
        return field;
    }

    private static Field makeScriptMethodField(SQLBinaryOpExpr binaryExpr, String alias) throws SqlParseException {
        ArrayList<SQLExpr> params = new ArrayList<SQLExpr>();
        String scriptFieldAlias = alias == null || alias.equals("") ? binaryExpr.toString() : alias;
        params.add((SQLExpr)new SQLCharExpr(scriptFieldAlias));
        Object left = FieldMaker.getScriptValue(binaryExpr.getLeft());
        Object right = FieldMaker.getScriptValue(binaryExpr.getRight());
        String script = String.format("%s %s %s", left, binaryExpr.getOperator().getName(), right);
        params.add((SQLExpr)new SQLCharExpr(script));
        return FieldMaker.makeMethodField("script", params, null, null);
    }

    private static Object getScriptValue(SQLExpr expr) throws SqlParseException {
        if (expr instanceof SQLIdentifierExpr || expr instanceof SQLPropertyExpr || expr instanceof SQLVariantRefExpr) {
            return "doc['" + expr.toString() + "'].value";
        }
        if (expr instanceof SQLValuableExpr) {
            return ((SQLValuableExpr)expr).getValue();
        }
        throw new SqlParseException("could not parse sqlBinaryOpExpr need to be identifier/valuable got" + expr.getClass().toString() + " with value:" + expr.toString());
    }

    private static Field handleIdentifier(SQLExpr expr, String alias, String tableAlias) {
        String aliasPrefix;
        String name = expr.toString().replace("`", "");
        if (tableAlias == null) {
            return new Field(name, alias);
        }
        if (tableAlias != null && name.startsWith(aliasPrefix = tableAlias + ".")) {
            name = name.replaceFirst(aliasPrefix, "");
            return new Field(name, alias);
        }
        return null;
    }

    private static MethodField makeMethodField(String name, List<SQLExpr> arguments, SQLAggregateOption option, String alias) throws SqlParseException {
        LinkedList<KVValue> paramers = new LinkedList<KVValue>();
        for (SQLExpr object : arguments) {
            if (object instanceof SQLBinaryOpExpr) {
                SQLBinaryOpExpr binaryOpExpr = (SQLBinaryOpExpr)object;
                if (!binaryOpExpr.getOperator().getName().equals("=")) {
                    paramers.add(new KVValue("script", FieldMaker.makeScriptMethodField(binaryOpExpr, null)));
                    continue;
                }
                SQLExpr right = binaryOpExpr.getRight();
                Object value = Util.expr2Object(right);
                paramers.add(new KVValue(binaryOpExpr.getLeft().toString(), value));
                continue;
            }
            if (object instanceof SQLMethodInvokeExpr) {
                SQLMethodInvokeExpr mExpr = (SQLMethodInvokeExpr)object;
                String methodName = mExpr.getMethodName().toLowerCase();
                if (methodName.equals("script")) {
                    KVValue script = new KVValue("script", FieldMaker.makeMethodField(mExpr.getMethodName(), mExpr.getParameters(), null, alias));
                    paramers.add(script);
                    continue;
                }
                if (methodName.equals("nested") || methodName.equals("reverse_nested")) {
                    NestedType nestedType = new NestedType();
                    if (!nestedType.tryFillFromExpr(object)) {
                        throw new SqlParseException("failed parsing nested expr " + object);
                    }
                    paramers.add(new KVValue("nested", nestedType));
                    continue;
                }
                if (methodName.equals("children")) {
                    ChildrenType childrenType = new ChildrenType();
                    if (!childrenType.tryFillFromExpr(object)) {
                        throw new SqlParseException("failed parsing children expr " + object);
                    }
                    paramers.add(new KVValue("children", childrenType));
                    if (childrenType.field == null) continue;
                    paramers.add(new KVValue("field", childrenType.field));
                    continue;
                }
                throw new SqlParseException("only support script/nested/children as inner functions");
            }
            paramers.add(new KVValue(Util.expr2Object(object)));
        }
        return new MethodField(name, paramers, option == null ? null : option.name(), alias);
    }
}

