/*
 * Decompiled with CFR 0.152.
 */
package org.nlpcn.es4sql.parse;

import com.alibaba.druid.sql.ast.SQLCommentHint;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.expr.SQLExistsExpr;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLNotExpr;
import com.alibaba.druid.sql.dialect.mysql.parser.MySqlExprParser;
import com.alibaba.druid.sql.parser.Lexer;
import com.alibaba.druid.sql.parser.ParserException;
import com.alibaba.druid.sql.parser.Token;
import java.util.List;
import org.nlpcn.es4sql.parse.ElasticLexer;
import org.nlpcn.es4sql.parse.SQLOdbcExpr;
import org.nlpcn.es4sql.parse.SQLParensIdentifierExpr;

public class ElasticSqlExprParser
extends MySqlExprParser {
    public ElasticSqlExprParser(Lexer lexer) {
        super(lexer);
    }

    public ElasticSqlExprParser(String sql) {
        this((Lexer)new ElasticLexer(sql));
        this.lexer.nextToken();
    }

    public void parseHints(List hints) {
        while (this.lexer.token() == Token.HINT) {
            hints.add(new SQLCommentHint(this.lexer.stringVal()));
            this.lexer.nextToken();
        }
    }

    public SQLExpr primary() {
        if (this.lexer.token() == Token.LBRACE) {
            this.lexer.nextToken();
            boolean foundRBrace = false;
            if (this.lexer.stringVal().equals("ts")) {
                String current = this.lexer.stringVal();
                do {
                    this.lexer.token();
                    if (current.equals(Token.RBRACE.name())) {
                        foundRBrace = true;
                        break;
                    }
                    this.lexer.nextToken();
                    current = this.lexer.token().name();
                } while (!foundRBrace && !current.trim().equals(""));
                if (foundRBrace) {
                    SQLOdbcExpr sdle = new SQLOdbcExpr(this.lexer.stringVal());
                    this.accept(Token.RBRACE);
                    return sdle;
                }
                throw new ParserException("Error. Unable to find closing RBRACE");
            }
            throw new ParserException("Error. Unable to parse ODBC Literal Timestamp");
        }
        if (this.lexer.token() == Token.LBRACKET) {
            StringBuilder identifier = new StringBuilder();
            this.lexer.nextToken();
            String prefix = "";
            while (this.lexer.token() != Token.RBRACKET) {
                if (this.lexer.token() != Token.IDENTIFIER && this.lexer.token() != Token.INDEX && this.lexer.token() != Token.LITERAL_CHARS) {
                    throw new ParserException("All items between Brackets should be identifiers , got:" + this.lexer.token());
                }
                identifier.append(prefix);
                identifier.append(this.lexer.stringVal());
                prefix = " ";
                this.lexer.nextToken();
            }
            this.accept(Token.RBRACKET);
            return new SQLIdentifierExpr(identifier.toString());
        }
        if (this.lexer.token() == Token.NOT) {
            SQLNotExpr sqlExpr;
            this.lexer.nextToken();
            if (this.lexer.token() == Token.EXISTS) {
                this.lexer.nextToken();
                this.accept(Token.LPAREN);
                sqlExpr = new SQLExistsExpr(this.createSelectParser().select(), true);
                this.accept(Token.RPAREN);
            } else {
                if (this.lexer.token() == Token.LPAREN) {
                    this.lexer.nextToken();
                    SQLExpr notTarget = this.expr();
                    this.accept(Token.RPAREN);
                    SQLNotExpr sqlExpr2 = new SQLNotExpr(notTarget);
                    return this.primaryRest((SQLExpr)sqlExpr2);
                }
                SQLExpr restExpr = this.relational();
                sqlExpr = new SQLNotExpr(restExpr);
            }
            return sqlExpr;
        }
        boolean parenWrapped = this.lexer.token() == Token.LPAREN;
        Object expr = super.primary();
        if (parenWrapped && expr instanceof SQLIdentifierExpr) {
            expr = new SQLParensIdentifierExpr((SQLIdentifierExpr)expr);
        }
        return expr;
    }
}

