/*
 * Decompiled with CFR 0.152.
 */
package org.nlpcn.es4sql.domain.hints;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLParser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.elasticsearch.common.xcontent.yaml.YamlXContentParser;
import org.nlpcn.es4sql.domain.hints.Hint;
import org.nlpcn.es4sql.domain.hints.HintType;
import org.nlpcn.es4sql.exception.SqlParseException;

public class HintFactory {
    public static Hint getHintFromString(String hintAsString) throws SqlParseException {
        if (hintAsString.startsWith("! USE_NESTED_LOOPS") || hintAsString.startsWith("! USE_NL")) {
            return new Hint(HintType.USE_NESTED_LOOPS, null);
        }
        if (hintAsString.equals("! HASH_WITH_TERMS_FILTER")) {
            return new Hint(HintType.HASH_WITH_TERMS_FILTER, null);
        }
        if (hintAsString.startsWith("! JOIN_TABLES_LIMIT")) {
            String[] numbers = HintFactory.getParamsFromHint(hintAsString, "! JOIN_TABLES_LIMIT");
            ArrayList<Integer> params = new ArrayList<Integer>();
            for (String number : numbers) {
                if (number.equals("null") || number.equals("infinity")) {
                    params.add(null);
                    continue;
                }
                params.add(Integer.parseInt(number));
            }
            return new Hint(HintType.JOIN_LIMIT, params.toArray());
        }
        if (hintAsString.startsWith("! NL_MULTISEARCH_SIZE")) {
            String[] number = HintFactory.getParamsFromHint(hintAsString, "! NL_MULTISEARCH_SIZE");
            int multiSearchSize = Integer.parseInt(number[0]);
            return new Hint(HintType.NL_MULTISEARCH_SIZE, new Object[]{multiSearchSize});
        }
        if (hintAsString.startsWith("! USE_SCROLL")) {
            String[] scrollParams = HintFactory.getParamsFromHint(hintAsString, "! USE_SCROLL");
            int docsPerShardFetch = 50;
            int timeout = 60000;
            if (scrollParams != null && scrollParams.length == 2) {
                docsPerShardFetch = Integer.parseInt(scrollParams[0]);
                timeout = Integer.parseInt(scrollParams[1]);
            }
            return new Hint(HintType.USE_SCROLL, new Object[]{docsPerShardFetch, timeout});
        }
        if (hintAsString.startsWith("! IGNORE_UNAVAILABLE")) {
            return new Hint(HintType.IGNORE_UNAVAILABLE, null);
        }
        if (hintAsString.startsWith("! DOCS_WITH_AGGREGATION")) {
            String[] number = HintFactory.getParamsFromHint(hintAsString, "! DOCS_WITH_AGGREGATION");
            Object[] params = new Integer[number.length];
            for (int i = 0; i < params.length; ++i) {
                params[i] = Integer.parseInt(number[i]);
            }
            return new Hint(HintType.DOCS_WITH_AGGREGATION, params);
        }
        if (hintAsString.startsWith("! ROUTINGS")) {
            Object[] routings = HintFactory.getParamsFromHint(hintAsString, "! ROUTINGS");
            return new Hint(HintType.ROUTINGS, routings);
        }
        if (hintAsString.startsWith("! HIGHLIGHT")) {
            String[] heighlights = HintFactory.getParamsFromHint(hintAsString, "! HIGHLIGHT");
            ArrayList<Object> hintParams = new ArrayList<Object>();
            hintParams.add(heighlights[0]);
            if (heighlights.length > 1) {
                StringBuilder builder = new StringBuilder();
                for (int i = 1; i < heighlights.length; ++i) {
                    if (i != 1) {
                        builder.append("\n");
                    }
                    builder.append(heighlights[i]);
                }
                String heighlightParam = builder.toString();
                YAMLFactory yamlFactory = new YAMLFactory();
                YAMLParser yamlParser = null;
                try {
                    yamlParser = yamlFactory.createParser(heighlightParam.toCharArray());
                    YamlXContentParser yamlXContentParser = new YamlXContentParser((JsonParser)yamlParser);
                    Map map = yamlXContentParser.map();
                    hintParams.add(map);
                }
                catch (IOException e) {
                    throw new SqlParseException("could not parse heighlight hint: " + e.getMessage());
                }
            }
            return new Hint(HintType.HIGHLIGHT, hintParams.toArray());
        }
        return null;
    }

    private static String[] getParamsFromHint(String hint, String prefix) {
        if (!hint.contains("(")) {
            return null;
        }
        String onlyParams = hint.replace(prefix, "").replaceAll("\\s*\\(\\s*", "").replaceAll("\\s*\\,\\s*", ",").replaceAll("\\s*\\)\\s*", "");
        return onlyParams.split(",");
    }
}

