/*
 * Decompiled with CFR 0.152.
 */
package org.nlpcn.es4sql.domain;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.nlpcn.es4sql.domain.Where;
import org.nlpcn.es4sql.exception.SqlParseException;
import org.nlpcn.es4sql.parse.ChildrenType;
import org.nlpcn.es4sql.parse.NestedType;

public class Condition
extends Where {
    private String name;
    private Object value;
    private OPEAR opear = null;
    private Object relationshipType;
    private boolean isNested;
    private String nestedPath;
    private boolean isChildren;
    private String childType;

    public Condition(Where.CONN conn, String field, String condition, Object obj) throws SqlParseException {
        this(conn, field, condition, obj, null);
    }

    public Condition(Where.CONN conn, String field, OPEAR condition, Object obj) throws SqlParseException {
        this(conn, field, condition, obj, null);
    }

    public Condition(Where.CONN conn, String name, OPEAR oper, Object value, Object relationshipType) throws SqlParseException {
        super(conn);
        this.name = name;
        this.value = value;
        this.opear = oper;
        this.relationshipType = relationshipType;
        if (this.relationshipType != null) {
            if (this.relationshipType instanceof NestedType) {
                NestedType nestedType = (NestedType)relationshipType;
                this.isNested = true;
                this.nestedPath = nestedType.path;
                this.isChildren = false;
                this.childType = "";
            } else if (relationshipType instanceof ChildrenType) {
                ChildrenType childrenType = (ChildrenType)relationshipType;
                this.isNested = false;
                this.nestedPath = "";
                this.isChildren = true;
                this.childType = childrenType.childType;
            }
        } else {
            this.isNested = false;
            this.nestedPath = "";
            this.isChildren = false;
            this.childType = "";
        }
    }

    public Condition(Where.CONN conn, String name, String oper, Object value, Object relationshipType) throws SqlParseException {
        super(conn);
        this.name = name;
        this.value = value;
        this.relationshipType = relationshipType;
        if (this.relationshipType != null) {
            if (this.relationshipType instanceof NestedType) {
                NestedType nestedType = (NestedType)relationshipType;
                this.isNested = true;
                this.nestedPath = nestedType.path;
                this.isChildren = false;
                this.childType = "";
            } else if (relationshipType instanceof ChildrenType) {
                ChildrenType childrenType = (ChildrenType)relationshipType;
                this.isNested = false;
                this.nestedPath = "";
                this.isChildren = true;
                this.childType = childrenType.childType;
            }
        } else {
            this.isNested = false;
            this.nestedPath = "";
            this.isChildren = false;
            this.childType = "";
        }
        switch (oper) {
            case "=": {
                this.opear = OPEAR.EQ;
                break;
            }
            case ">": {
                this.opear = OPEAR.GT;
                break;
            }
            case "<": {
                this.opear = OPEAR.LT;
                break;
            }
            case ">=": {
                this.opear = OPEAR.GTE;
                break;
            }
            case "<=": {
                this.opear = OPEAR.LTE;
                break;
            }
            case "<>": {
                this.opear = OPEAR.N;
                break;
            }
            case "LIKE": {
                this.opear = OPEAR.LIKE;
                break;
            }
            case "NOT": {
                this.opear = OPEAR.N;
                break;
            }
            case "NOT LIKE": {
                this.opear = OPEAR.NLIKE;
                break;
            }
            case "IS": {
                this.opear = OPEAR.IS;
                break;
            }
            case "IS NOT": {
                this.opear = OPEAR.ISN;
                break;
            }
            case "NOT IN": {
                this.opear = OPEAR.NIN;
                break;
            }
            case "IN": {
                this.opear = OPEAR.IN;
                break;
            }
            case "BETWEEN": {
                this.opear = OPEAR.BETWEEN;
                break;
            }
            case "NOT BETWEEN": {
                this.opear = OPEAR.NBETWEEN;
                break;
            }
            case "GEO_INTERSECTS": {
                this.opear = OPEAR.GEO_INTERSECTS;
                break;
            }
            case "GEO_BOUNDING_BOX": {
                this.opear = OPEAR.GEO_BOUNDING_BOX;
                break;
            }
            case "GEO_DISTANCE": {
                this.opear = OPEAR.GEO_DISTANCE;
                break;
            }
            case "GEO_DISTANCE_RANGE": {
                this.opear = OPEAR.GEO_DISTANCE_RANGE;
                break;
            }
            case "GEO_POLYGON": {
                this.opear = OPEAR.GEO_POLYGON;
                break;
            }
            case "GEO_CELL": {
                this.opear = OPEAR.GEO_CELL;
                break;
            }
            case "NESTED": {
                this.opear = OPEAR.NESTED_COMPLEX;
                break;
            }
            case "CHILDREN": {
                this.opear = OPEAR.CHILDREN_COMPLEX;
                break;
            }
            case "SCRIPT": {
                this.opear = OPEAR.SCRIPT;
                break;
            }
            default: {
                throw new SqlParseException(oper + " is err!");
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public OPEAR getOpear() {
        return this.opear;
    }

    public void setOpear(OPEAR opear) {
        this.opear = opear;
    }

    public Object getRelationshipType() {
        return this.relationshipType;
    }

    public void setRelationshipType(Object relationshipType) {
        this.relationshipType = relationshipType;
    }

    public boolean isNested() {
        return this.isNested;
    }

    public void setNested(boolean isNested) {
        this.isNested = isNested;
    }

    public String getNestedPath() {
        return this.nestedPath;
    }

    public void setNestedPath(String nestedPath) {
        this.nestedPath = nestedPath;
    }

    public boolean isChildren() {
        return this.isChildren;
    }

    public void setChildren(boolean isChildren) {
        this.isChildren = isChildren;
    }

    public String getChildType() {
        return this.childType;
    }

    public void setChildType(String childType) {
        this.childType = childType;
    }

    @Override
    public String toString() {
        String result = "";
        if (this.isNested()) {
            result = "nested condition ";
            if (this.getNestedPath() != null) {
                result = result + "on path:" + this.getNestedPath() + " ";
            }
        } else if (this.isChildren()) {
            result = "children condition ";
            if (this.getChildType() != null) {
                result = result + "on child: " + this.getChildType() + " ";
            }
        }
        result = this.value instanceof Object[] ? result + (Object)((Object)this.conn) + " " + this.name + " " + (Object)((Object)this.opear) + " " + Arrays.toString((Object[])this.value) : result + (Object)((Object)this.conn) + " " + this.name + " " + (Object)((Object)this.opear) + " " + this.value;
        return result;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        try {
            Condition clonedCondition = new Condition(this.getConn(), this.getName(), this.getOpear(), this.getValue(), this.getRelationshipType());
            return clonedCondition;
        }
        catch (SqlParseException sqlParseException) {
            return null;
        }
    }

    public static enum OPEAR {
        EQ,
        GT,
        LT,
        GTE,
        LTE,
        N,
        LIKE,
        NLIKE,
        IS,
        ISN,
        IN,
        NIN,
        BETWEEN,
        NBETWEEN,
        GEO_INTERSECTS,
        GEO_BOUNDING_BOX,
        GEO_DISTANCE,
        GEO_DISTANCE_RANGE,
        GEO_POLYGON,
        GEO_CELL,
        IN_TERMS,
        TERM,
        IDS_QUERY,
        NESTED_COMPLEX,
        CHILDREN_COMPLEX,
        SCRIPT;

        public static Map<String, OPEAR> methodNameToOpear;
        private static BiMap<OPEAR, OPEAR> negatives;

        public OPEAR negative() throws SqlParseException {
            OPEAR negative = (OPEAR)((Object)negatives.get((Object)this));
            OPEAR oPEAR = negative = negative != null ? negative : (OPEAR)((Object)negatives.inverse().get((Object)this));
            if (negative == null) {
                throw new SqlParseException("OPEAR negative not supported: " + (Object)((Object)this));
            }
            return negative;
        }

        static {
            methodNameToOpear = new HashMap<String, OPEAR>();
            methodNameToOpear.put("term", TERM);
            methodNameToOpear.put("matchterm", TERM);
            methodNameToOpear.put("match_term", TERM);
            methodNameToOpear.put("terms", IN_TERMS);
            methodNameToOpear.put("in_terms", IN_TERMS);
            methodNameToOpear.put("ids", IDS_QUERY);
            methodNameToOpear.put("ids_query", IDS_QUERY);
            negatives = HashBiMap.create((int)7);
            negatives.put((Object)EQ, (Object)N);
            negatives.put((Object)GT, (Object)LTE);
            negatives.put((Object)LT, (Object)GTE);
            negatives.put((Object)LIKE, (Object)NLIKE);
            negatives.put((Object)IS, (Object)ISN);
            negatives.put((Object)IN, (Object)NIN);
            negatives.put((Object)BETWEEN, (Object)NBETWEEN);
        }
    }
}

