/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.plugin.nlpcn.executors;

import java.util.Map;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.admin.indices.get.GetIndexRequest;
import org.elasticsearch.action.deletebyquery.DeleteByQueryRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.plugin.nlpcn.ElasticJoinExecutor;
import org.elasticsearch.plugin.nlpcn.GetIndexRequestRestListener;
import org.elasticsearch.plugin.nlpcn.executors.RestExecutor;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.action.support.RestStatusToXContentListener;
import org.nlpcn.es4sql.query.QueryAction;
import org.nlpcn.es4sql.query.SqlElasticRequestBuilder;
import org.nlpcn.es4sql.query.join.JoinRequestBuilder;

public class ElasticDefaultRestExecutor
implements RestExecutor {
    @Override
    public void execute(Client client, Map<String, String> params, QueryAction queryAction, RestChannel channel) throws Exception {
        SqlElasticRequestBuilder requestBuilder = queryAction.explain();
        ActionRequest request = requestBuilder.request();
        if (requestBuilder instanceof JoinRequestBuilder) {
            ElasticJoinExecutor executor = ElasticJoinExecutor.createJoinExecutor(client, requestBuilder);
            executor.run();
            executor.sendResponse(channel);
        } else if (request instanceof SearchRequest) {
            client.search((SearchRequest)request, (ActionListener)new RestStatusToXContentListener(channel));
        } else {
            if (request instanceof DeleteByQueryRequest) {
                throw new UnsupportedOperationException("currently not support delete on elastic 2.x");
            }
            if (request instanceof GetIndexRequest) {
                requestBuilder.getBuilder().execute((ActionListener)new GetIndexRequestRestListener(channel, (GetIndexRequest)request));
            } else {
                throw new Exception(String.format("Unsupported ActionRequest provided: %s", request.getClass().getName()));
            }
        }
    }
}

