/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.plugin.nlpcn.executors;

import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.plugin.nlpcn.executors.CSVResult;
import org.elasticsearch.plugin.nlpcn.executors.CsvExtractorException;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHitField;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.elasticsearch.search.aggregations.bucket.SingleBucketAggregation;
import org.elasticsearch.search.aggregations.metrics.NumericMetricsAggregation;
import org.elasticsearch.search.aggregations.metrics.geobounds.GeoBounds;
import org.elasticsearch.search.aggregations.metrics.percentiles.Percentiles;
import org.elasticsearch.search.aggregations.metrics.stats.Stats;
import org.elasticsearch.search.aggregations.metrics.stats.extended.ExtendedStats;
import org.elasticsearch.search.aggregations.metrics.tophits.TopHits;
import org.nlpcn.es4sql.Util;

public class CSVResultsExtractor {
    private final boolean includeType;
    private final boolean includeScore;
    private int currentLineIndex;

    public CSVResultsExtractor(boolean includeScore, boolean includeType) {
        this.includeScore = includeScore;
        this.includeType = includeType;
        this.currentLineIndex = 0;
    }

    public CSVResult extractResults(Object queryResult, boolean flat, String separator) throws CsvExtractorException {
        if (queryResult instanceof SearchHits) {
            SearchHit[] hits = ((SearchHits)queryResult).getHits();
            ArrayList<Map<String, Object>> docsAsMap = new ArrayList<Map<String, Object>>();
            List<String> headers = this.createHeadersAndFillDocsMap(flat, hits, docsAsMap);
            List<String> csvLines = this.createCSVLinesFromDocs(flat, separator, docsAsMap, headers);
            return new CSVResult(headers, csvLines);
        }
        if (queryResult instanceof Aggregations) {
            ArrayList<String> headers = new ArrayList<String>();
            ArrayList<List<String>> lines = new ArrayList<List<String>>();
            lines.add(new ArrayList());
            this.handleAggregations((Aggregations)queryResult, headers, lines);
            ArrayList<String> csvLines = new ArrayList<String>();
            for (List list : lines) {
                csvLines.add(Joiner.on((String)separator).join((Iterable)list));
            }
            return new CSVResult(headers, csvLines);
        }
        return null;
    }

    private void handleAggregations(Aggregations aggregations, List<String> headers, List<List<String>> lines) throws CsvExtractorException {
        if (this.allNumericAggregations(aggregations)) {
            lines.get(this.currentLineIndex).addAll(this.fillHeaderAndCreateLineForNumericAggregations(aggregations, headers));
            return;
        }
        List aggregationList = aggregations.asList();
        if (aggregationList.size() > 1) {
            throw new CsvExtractorException("currently support only one aggregation at same level (Except for numeric metrics)");
        }
        Aggregation aggregation = (Aggregation)aggregationList.get(0);
        if (aggregation instanceof SingleBucketAggregation) {
            Aggregations singleBucketAggs = ((SingleBucketAggregation)aggregation).getAggregations();
            this.handleAggregations(singleBucketAggs, headers, lines);
            return;
        }
        if (aggregation instanceof NumericMetricsAggregation) {
            this.handleNumericMetricAggregation(headers, lines.get(this.currentLineIndex), aggregation);
            return;
        }
        if (aggregation instanceof GeoBounds) {
            this.handleGeoBoundsAggregation(headers, lines, (GeoBounds)aggregation);
            return;
        }
        if (aggregation instanceof TopHits) {
            // empty if block
        }
        if (aggregation instanceof MultiBucketsAggregation) {
            MultiBucketsAggregation bucketsAggregation = (MultiBucketsAggregation)aggregation;
            String name = bucketsAggregation.getName();
            if (!headers.contains(name)) {
                headers.add(name);
            }
            List buckets = bucketsAggregation.getBuckets();
            List<String> currentLine = lines.get(this.currentLineIndex);
            ArrayList<String> clonedLine = new ArrayList<String>(currentLine);
            boolean firstLine = true;
            for (MultiBucketsAggregation.Bucket bucket : buckets) {
                String key = bucket.getKeyAsString();
                if (firstLine) {
                    firstLine = false;
                } else {
                    ++this.currentLineIndex;
                    currentLine = new ArrayList<String>(clonedLine);
                    lines.add(currentLine);
                }
                currentLine.add(key);
                this.handleAggregations(bucket.getAggregations(), headers, lines);
            }
        }
    }

    private void handleGeoBoundsAggregation(List<String> headers, List<List<String>> lines, GeoBounds geoBoundsAggregation) {
        String geoBoundAggName = geoBoundsAggregation.getName();
        headers.add(geoBoundAggName + ".topLeft.lon");
        headers.add(geoBoundAggName + ".topLeft.lat");
        headers.add(geoBoundAggName + ".bottomRight.lon");
        headers.add(geoBoundAggName + ".bottomRight.lat");
        List<String> line = lines.get(this.currentLineIndex);
        line.add(String.valueOf(geoBoundsAggregation.topLeft().getLon()));
        line.add(String.valueOf(geoBoundsAggregation.topLeft().getLat()));
        line.add(String.valueOf(geoBoundsAggregation.bottomRight().getLon()));
        line.add(String.valueOf(geoBoundsAggregation.bottomRight().getLat()));
        lines.add(line);
    }

    private List<String> fillHeaderAndCreateLineForNumericAggregations(Aggregations aggregations, List<String> header) throws CsvExtractorException {
        ArrayList<String> line = new ArrayList<String>();
        List aggregationList = aggregations.asList();
        for (Aggregation aggregation : aggregationList) {
            this.handleNumericMetricAggregation(header, line, aggregation);
        }
        return line;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handleNumericMetricAggregation(List<String> header, List<String> line, Aggregation aggregation) throws CsvExtractorException {
        String name = aggregation.getName();
        if (aggregation instanceof NumericMetricsAggregation.SingleValue) {
            if (!header.contains(name)) {
                header.add(name);
            }
            line.add(((NumericMetricsAggregation.SingleValue)aggregation).getValueAsString());
            return;
        } else {
            if (!(aggregation instanceof NumericMetricsAggregation.MultiValue)) throw new CsvExtractorException("unknown NumericMetricsAggregation" + aggregation.getClass());
            if (aggregation instanceof Stats) {
                String[] statsHeaders = new String[]{"count", "sum", "avg", "min", "max"};
                boolean isExtendedStats = aggregation instanceof ExtendedStats;
                if (isExtendedStats) {
                    String[] extendedHeaders = new String[]{"sumOfSquares", "variance", "stdDeviation"};
                    statsHeaders = Util.concatStringsArrays(statsHeaders, extendedHeaders);
                }
                this.mergeHeadersWithPrefix(header, name, statsHeaders);
                Stats stats = (Stats)aggregation;
                line.add(stats.getCountAsString());
                line.add(stats.getSumAsString());
                line.add(stats.getAvgAsString());
                line.add(stats.getMinAsString());
                line.add(stats.getMaxAsString());
                if (!isExtendedStats) return;
                ExtendedStats extendedStats = (ExtendedStats)aggregation;
                line.add(extendedStats.getSumOfSquaresAsString());
                line.add(extendedStats.getVarianceAsString());
                line.add(extendedStats.getStdDeviationAsString());
                return;
            } else {
                if (!(aggregation instanceof Percentiles)) throw new CsvExtractorException("unknown NumericMetricsAggregation.MultiValue:" + aggregation.getClass());
                String[] percentileHeaders = new String[]{"1.0", "5.0", "25.0", "50.0", "75.0", "95.0", "99.0"};
                this.mergeHeadersWithPrefix(header, name, percentileHeaders);
                Percentiles percentiles = (Percentiles)aggregation;
                line.add(percentiles.percentileAsString(1.0));
                line.add(percentiles.percentileAsString(5.0));
                line.add(percentiles.percentileAsString(25.0));
                line.add(percentiles.percentileAsString(50.0));
                line.add(percentiles.percentileAsString(75.0));
                line.add(percentiles.percentileAsString(95.0));
                line.add(percentiles.percentileAsString(99.0));
            }
        }
    }

    private void mergeHeadersWithPrefix(List<String> header, String prefix, String[] newHeaders) {
        for (int i = 0; i < newHeaders.length; ++i) {
            String newHeader = newHeaders[i];
            if (prefix != null && !prefix.equals("")) {
                newHeader = prefix + "." + newHeader;
            }
            if (header.contains(newHeader)) continue;
            header.add(newHeader);
        }
    }

    private boolean allNumericAggregations(Aggregations aggregations) {
        List aggregationList = aggregations.asList();
        for (Aggregation aggregation : aggregationList) {
            if (aggregation instanceof NumericMetricsAggregation) continue;
            return false;
        }
        return true;
    }

    private Aggregation skipAggregations(Aggregation firstAggregation) {
        while (firstAggregation instanceof SingleBucketAggregation) {
            firstAggregation = this.getFirstAggregation(((SingleBucketAggregation)firstAggregation).getAggregations());
        }
        return firstAggregation;
    }

    private Aggregation getFirstAggregation(Aggregations aggregations) {
        return (Aggregation)aggregations.asList().get(0);
    }

    private List<String> createCSVLinesFromDocs(boolean flat, String separator, List<Map<String, Object>> docsAsMap, List<String> headers) {
        ArrayList<String> csvLines = new ArrayList<String>();
        for (Map<String, Object> doc : docsAsMap) {
            String line = "";
            for (String header : headers) {
                line = line + this.findFieldValue(header, doc, flat, separator);
            }
            csvLines.add(line.substring(0, line.length() - 1));
        }
        return csvLines;
    }

    private List<String> createHeadersAndFillDocsMap(boolean flat, SearchHit[] hits, List<Map<String, Object>> docsAsMap) {
        HashSet<String> csvHeaders = new HashSet<String>();
        for (SearchHit hit : hits) {
            Map doc = hit.sourceAsMap();
            Map fields = hit.getFields();
            for (SearchHitField searchHitField : fields.values()) {
                doc.put(searchHitField.getName(), searchHitField.value());
            }
            this.mergeHeaders(csvHeaders, doc, flat);
            if (this.includeScore) {
                doc.put("_score", Float.valueOf(hit.score()));
            }
            if (this.includeType) {
                doc.put("_type", hit.type());
            }
            docsAsMap.add(doc);
        }
        ArrayList<String> headersList = new ArrayList<String>(csvHeaders);
        if (this.includeScore) {
            headersList.add("_score");
        }
        if (this.includeType) {
            headersList.add("_type");
        }
        return headersList;
    }

    private String findFieldValue(String header, Map<String, Object> doc, boolean flat, String separator) {
        if (flat && header.contains(".")) {
            String[] split = header.split("\\.");
            Object innerDoc = doc;
            for (String innerField : split) {
                if (!(innerDoc instanceof Map)) {
                    return separator;
                }
                if ((innerDoc = innerDoc.get(innerField)) != null) continue;
                return separator;
            }
            return innerDoc.toString() + separator;
        }
        if (doc.containsKey(header)) {
            return doc.get(header).toString() + separator;
        }
        return separator;
    }

    private void mergeHeaders(Set<String> headers, Map<String, Object> doc, boolean flat) {
        if (!flat) {
            headers.addAll(doc.keySet());
            return;
        }
        this.mergeFieldNamesRecursive(headers, doc, "");
    }

    private void mergeFieldNamesRecursive(Set<String> headers, Map<String, Object> doc, String prefix) {
        for (Map.Entry<String, Object> field : doc.entrySet()) {
            Object value = field.getValue();
            if (value instanceof Map) {
                this.mergeFieldNamesRecursive(headers, (Map)value, prefix + field.getKey() + ".");
                continue;
            }
            headers.add(prefix + field.getKey());
        }
    }
}

