/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.plugin.nlpcn;

import java.util.Map;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.plugin.nlpcn.executors.ActionRequestRestExecuterFactory;
import org.elasticsearch.plugin.nlpcn.executors.RestExecutor;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.nlpcn.es4sql.SearchDao;
import org.nlpcn.es4sql.query.QueryAction;

public class RestSqlAction
extends BaseRestHandler {
    @Inject
    public RestSqlAction(Settings settings, Client client, RestController restController) {
        super(settings, restController, client);
        restController.registerHandler(RestRequest.Method.POST, "/_sql/_explain", (RestHandler)this);
        restController.registerHandler(RestRequest.Method.GET, "/_sql/_explain", (RestHandler)this);
        restController.registerHandler(RestRequest.Method.POST, "/_sql", (RestHandler)this);
        restController.registerHandler(RestRequest.Method.GET, "/_sql", (RestHandler)this);
    }

    protected void handleRequest(RestRequest request, RestChannel channel, Client client) throws Exception {
        String sql = request.param("sql");
        if (sql == null) {
            sql = request.content().toUtf8();
        }
        SearchDao searchDao = new SearchDao(client);
        QueryAction queryAction = searchDao.explain(sql);
        if (request.path().endsWith("/_explain")) {
            String jsonExplanation = queryAction.explain().explain();
            BytesRestResponse bytesRestResponse = new BytesRestResponse(RestStatus.OK, jsonExplanation);
            channel.sendResponse((RestResponse)bytesRestResponse);
        } else {
            Map params = request.params();
            RestExecutor restExecutor = ActionRequestRestExecuterFactory.createExecutor((String)params.get("format"));
            restExecutor.execute(client, params, queryAction, channel);
        }
    }
}

