/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.plugin.nlpcn;

import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.admin.indices.get.GetIndexRequest;
import org.elasticsearch.action.admin.indices.get.GetIndexResponse;
import org.elasticsearch.cluster.metadata.AliasMetaData;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.support.RestBuilderListener;
import org.elasticsearch.search.warmer.IndexWarmersMetaData;

public class GetIndexRequestRestListener
extends RestBuilderListener<GetIndexResponse> {
    private GetIndexRequest getIndexRequest;

    public GetIndexRequestRestListener(RestChannel channel, GetIndexRequest getIndexRequest) {
        super(channel);
        this.getIndexRequest = getIndexRequest;
    }

    public RestResponse buildResponse(GetIndexResponse getIndexResponse, XContentBuilder builder) throws Exception {
        GetIndexRequest.Feature[] features = this.getIndexRequest.featuresAsEnums();
        String[] indices = getIndexResponse.indices();
        builder.startObject();
        for (String index : indices) {
            builder.startObject(index);
            block7: for (GetIndexRequest.Feature feature : features) {
                switch (feature) {
                    case ALIASES: {
                        this.writeAliases((List)getIndexResponse.aliases().get((Object)index), builder, (ToXContent.Params)this.channel.request());
                        continue block7;
                    }
                    case MAPPINGS: {
                        this.writeMappings((ImmutableOpenMap<String, MappingMetaData>)((ImmutableOpenMap)getIndexResponse.mappings().get((Object)index)), builder, (ToXContent.Params)this.channel.request());
                        continue block7;
                    }
                    case SETTINGS: {
                        this.writeSettings((Settings)getIndexResponse.settings().get((Object)index), builder, (ToXContent.Params)this.channel.request());
                        continue block7;
                    }
                    case WARMERS: {
                        this.writeWarmers((List)getIndexResponse.warmers().get((Object)index), builder, (ToXContent.Params)this.channel.request());
                        continue block7;
                    }
                    default: {
                        throw new IllegalStateException("feature [" + feature + "] is not valid");
                    }
                }
            }
            builder.endObject();
        }
        builder.endObject();
        return new BytesRestResponse(RestStatus.OK, builder);
    }

    private void writeAliases(List<AliasMetaData> aliases, XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(Fields.ALIASES);
        if (aliases != null) {
            for (AliasMetaData alias : aliases) {
                AliasMetaData.Builder.toXContent((AliasMetaData)alias, (XContentBuilder)builder, (ToXContent.Params)params);
            }
        }
        builder.endObject();
    }

    private void writeMappings(ImmutableOpenMap<String, MappingMetaData> mappings, XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(Fields.MAPPINGS);
        if (mappings != null) {
            for (ObjectObjectCursor typeEntry : mappings) {
                builder.field((String)typeEntry.key);
                builder.map(((MappingMetaData)typeEntry.value).sourceAsMap());
            }
        }
        builder.endObject();
    }

    private void writeSettings(Settings settings, XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(Fields.SETTINGS);
        settings.toXContent(builder, params);
        builder.endObject();
    }

    private void writeWarmers(List<IndexWarmersMetaData.Entry> warmers, XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(Fields.WARMERS);
        if (warmers != null) {
            for (IndexWarmersMetaData.Entry warmer : warmers) {
                IndexWarmersMetaData.toXContent((IndexWarmersMetaData.Entry)warmer, (XContentBuilder)builder, (ToXContent.Params)params);
            }
        }
        builder.endObject();
    }

    static class Fields {
        static final XContentBuilderString ALIASES = new XContentBuilderString("aliases");
        static final XContentBuilderString MAPPINGS = new XContentBuilderString("mappings");
        static final XContentBuilderString SETTINGS = new XContentBuilderString("settings");
        static final XContentBuilderString WARMERS = new XContentBuilderString("warmers");

        Fields() {
        }
    }
}

