/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.plugin.nlpcn;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.plugin.nlpcn.HashJoinElasticExecutor;
import org.elasticsearch.plugin.nlpcn.MetaSearchResult;
import org.elasticsearch.plugin.nlpcn.NestedLoopsElasticExecutor;
import org.elasticsearch.plugin.nlpcn.SearchHitsResult;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.internal.InternalSearchHit;
import org.elasticsearch.search.internal.InternalSearchHits;
import org.nlpcn.es4sql.domain.Field;
import org.nlpcn.es4sql.exception.SqlParseException;
import org.nlpcn.es4sql.query.SqlElasticRequestBuilder;
import org.nlpcn.es4sql.query.join.HashJoinElasticRequestBuilder;
import org.nlpcn.es4sql.query.join.JoinRequestBuilder;
import org.nlpcn.es4sql.query.join.NestedLoopsElasticRequestBuilder;
import org.nlpcn.es4sql.query.join.TableInJoinRequestBuilder;

public abstract class ElasticJoinExecutor {
    protected SearchHits results;
    protected MetaSearchResult metaResults = new MetaSearchResult();
    protected final int MAX_RESULTS_ON_ONE_FETCH = 10000;
    private Set<String> aliasesOnReturn = new HashSet<String>();
    private boolean allFieldsReturn;

    protected ElasticJoinExecutor(JoinRequestBuilder requestBuilder) {
        List<Field> firstTableReturnedField = requestBuilder.getFirstTable().getReturnedFields();
        List<Field> secondTableReturnedField = requestBuilder.getSecondTable().getReturnedFields();
        this.allFieldsReturn = !(firstTableReturnedField != null && firstTableReturnedField.size() != 0 || secondTableReturnedField != null && secondTableReturnedField.size() != 0);
    }

    public void sendResponse(RestChannel channel) {
        try {
            String json = this.resultAsString();
            BytesRestResponse bytesRestResponse = new BytesRestResponse(RestStatus.OK, json);
            channel.sendResponse((RestResponse)bytesRestResponse);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void run() throws IOException, SqlParseException {
        long timeBefore = System.currentTimeMillis();
        List<InternalSearchHit> combinedSearchHits = this.innerRun();
        int resultsSize = combinedSearchHits.size();
        InternalSearchHit[] hits = combinedSearchHits.toArray(new InternalSearchHit[resultsSize]);
        this.results = new InternalSearchHits(hits, (long)resultsSize, 1.0f);
        long joinTimeInMilli = System.currentTimeMillis() - timeBefore;
        this.metaResults.setTookImMilli(joinTimeInMilli);
    }

    public String resultAsString() throws IOException {
        if (this.results == null) {
            return null;
        }
        Object[] searchHits = new Object[(int)this.results.totalHits()];
        int i = 0;
        for (SearchHit hit : this.results) {
            HashMap<String, Object> value = new HashMap<String, Object>();
            value.put("_id", hit.getId());
            value.put("_type", hit.getType());
            value.put("_score", Float.valueOf(hit.score()));
            value.put("_source", hit.sourceAsMap());
            searchHits[i] = value;
            ++i;
        }
        HashMap<String, Object> hits = new HashMap<String, Object>();
        hits.put("total", this.results.totalHits());
        hits.put("max_score", Float.valueOf(this.results.maxScore()));
        hits.put("hits", searchHits);
        XContentBuilder builder = XContentFactory.contentBuilder((XContentType)XContentType.JSON).prettyPrint();
        builder.startObject();
        builder.field("took", this.metaResults.getTookImMilli());
        builder.field("timed_out", this.metaResults.isTimedOut());
        builder.field("_shards", (Map)ImmutableMap.of((Object)"total", (Object)this.metaResults.getTotalNumOfShards(), (Object)"successful", (Object)this.metaResults.getSuccessfulShards(), (Object)"failed", (Object)this.metaResults.getFailedShards()));
        builder.field("hits", hits);
        builder.endObject();
        return builder.string();
    }

    protected abstract List<InternalSearchHit> innerRun() throws IOException, SqlParseException;

    public SearchHits getHits() {
        return this.results;
    }

    public static ElasticJoinExecutor createJoinExecutor(Client client, SqlElasticRequestBuilder requestBuilder) {
        if (requestBuilder instanceof HashJoinElasticRequestBuilder) {
            HashJoinElasticRequestBuilder hashJoin = (HashJoinElasticRequestBuilder)requestBuilder;
            return new HashJoinElasticExecutor(client, hashJoin);
        }
        if (requestBuilder instanceof NestedLoopsElasticRequestBuilder) {
            NestedLoopsElasticRequestBuilder nestedLoops = (NestedLoopsElasticRequestBuilder)requestBuilder;
            return new NestedLoopsElasticExecutor(client, nestedLoops);
        }
        throw new RuntimeException("Unsuported requestBuilder of type: " + requestBuilder.getClass());
    }

    protected void mergeSourceAndAddAliases(Map<String, Object> secondTableHitSource, InternalSearchHit searchHit, String t1Alias, String t2Alias) {
        Map<String, Object> results = this.mapWithAliases(searchHit.getSource(), t1Alias);
        results.putAll(this.mapWithAliases(secondTableHitSource, t2Alias));
        searchHit.getSource().clear();
        searchHit.getSource().putAll(results);
    }

    protected Map<String, Object> mapWithAliases(Map<String, Object> source, String alias) {
        HashMap<String, Object> mapWithAliases = new HashMap<String, Object>();
        for (Map.Entry<String, Object> fieldNameToValue : source.entrySet()) {
            if (!this.aliasesOnReturn.contains(fieldNameToValue.getKey())) {
                mapWithAliases.put(alias + "." + fieldNameToValue.getKey(), fieldNameToValue.getValue());
                continue;
            }
            mapWithAliases.put(fieldNameToValue.getKey(), fieldNameToValue.getValue());
        }
        return mapWithAliases;
    }

    protected void onlyReturnedFields(Map<String, Object> fieldsMap, List<Field> required, boolean allRequired) {
        HashMap<String, Object> filteredMap = new HashMap<String, Object>();
        if (this.allFieldsReturn || allRequired) {
            filteredMap.putAll(fieldsMap);
            return;
        }
        for (Field field : required) {
            String name;
            String returnName = name = field.getName();
            String alias = field.getAlias();
            if (alias != null && alias != "") {
                returnName = alias;
                this.aliasesOnReturn.add(alias);
            }
            filteredMap.put(returnName, this.deepSearchInMap(fieldsMap, name));
        }
        fieldsMap.clear();
        fieldsMap.putAll(filteredMap);
    }

    protected Object deepSearchInMap(Map<String, Object> fieldsMap, String name) {
        if (name.contains(".")) {
            String[] path = name.split("\\.");
            Map currentObject = fieldsMap;
            for (int i = 0; i < path.length - 1; ++i) {
                Object valueFromCurrentMap = currentObject.get(path[i]);
                if (valueFromCurrentMap == null) {
                    return null;
                }
                if (!Map.class.isAssignableFrom(valueFromCurrentMap.getClass())) {
                    return null;
                }
                currentObject = (Map)valueFromCurrentMap;
            }
            return currentObject.get(path[path.length - 1]);
        }
        return fieldsMap.get(name);
    }

    protected void addUnmatchedResults(List<InternalSearchHit> combinedResults, Collection<SearchHitsResult> firstTableSearchHits, List<Field> secondTableReturnedFields, int currentNumOfIds, int totalLimit, String t1Alias, String t2Alias) {
        boolean limitReached = false;
        for (SearchHitsResult hitsResult : firstTableSearchHits) {
            if (!hitsResult.isMatchedWithOtherTable()) {
                for (InternalSearchHit hit : hitsResult.getSearchHits()) {
                    InternalSearchHit unmachedResult = this.createUnmachedResult(secondTableReturnedFields, hit.docId(), t1Alias, t2Alias, (SearchHit)hit);
                    combinedResults.add(unmachedResult);
                    if (++currentNumOfIds < totalLimit) continue;
                    limitReached = true;
                    break;
                }
            }
            if (!limitReached) continue;
            break;
        }
    }

    protected InternalSearchHit createUnmachedResult(List<Field> secondTableReturnedFields, int docId, String t1Alias, String t2Alias, SearchHit hit) {
        String unmatchedId = hit.id() + "|0";
        Text unamatchedType = new Text(hit.getType() + "|null");
        InternalSearchHit searchHit = new InternalSearchHit(docId, unmatchedId, unamatchedType, hit.getFields());
        searchHit.sourceRef(hit.getSourceRef());
        searchHit.sourceAsMap().clear();
        searchHit.sourceAsMap().putAll(hit.sourceAsMap());
        Map<String, Object> emptySecondTableHitSource = this.createNullsSource(secondTableReturnedFields);
        this.mergeSourceAndAddAliases(emptySecondTableHitSource, searchHit, t1Alias, t2Alias);
        return searchHit;
    }

    protected Map<String, Object> createNullsSource(List<Field> secondTableReturnedFields) {
        HashMap<String, Object> nulledSource = new HashMap<String, Object>();
        for (Field field : secondTableReturnedFields) {
            if (field.getName().equals("*")) continue;
            nulledSource.put(field.getName(), null);
        }
        return nulledSource;
    }

    protected void updateMetaSearchResults(SearchResponse searchResponse) {
        this.metaResults.addSuccessfulShards(searchResponse.getSuccessfulShards());
        this.metaResults.addFailedShards(searchResponse.getFailedShards());
        this.metaResults.addTotalNumOfShards(searchResponse.getTotalShards());
        this.metaResults.updateTimeOut(searchResponse.isTimedOut());
    }

    protected SearchResponse scrollOneTimeWithMax(Client client, TableInJoinRequestBuilder tableRequest) {
        SearchRequestBuilder scrollRequest = tableRequest.getRequestBuilder().setScroll(new TimeValue(60000L)).setSize(10000);
        boolean ordered = tableRequest.getOriginalSelect().isOrderdSelect();
        if (!ordered) {
            scrollRequest.setSearchType(SearchType.SCAN);
        }
        SearchResponse responseWithHits = (SearchResponse)scrollRequest.get();
        if (!ordered) {
            responseWithHits = (SearchResponse)client.prepareSearchScroll(responseWithHits.getScrollId()).setScroll(new TimeValue(600000L)).get();
        }
        return responseWithHits;
    }
}

