/*
 * Decompiled with CFR 0.152.
 */
package io.github.tonycody.maven.plugin.sorter.wrapper.operation;

import io.github.tonycody.maven.plugin.sorter.wrapper.content.SingleNewlineInTextWrapper;
import io.github.tonycody.maven.plugin.sorter.wrapper.content.Wrapper;
import io.github.tonycody.maven.plugin.sorter.wrapper.operation.HierarchyWrapperOperation;
import io.github.tonycody.maven.plugin.sorter.wrapper.operation.ToStringOperation;
import io.github.tonycody.maven.plugin.sorter.wrapper.operation.WrapperFactory;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Element;
import org.dom4j.Node;

class HierarchyWrapper {
    private Wrapper<Element> elementContent;
    private final List<Wrapper<Node>> otherContentList = new ArrayList<Wrapper<Node>>();
    private final List<HierarchyWrapper> children = new ArrayList<HierarchyWrapper>();

    HierarchyWrapper(Wrapper<? extends Node> wrapper) {
        this.addContent(wrapper);
    }

    private void addContent(Wrapper<? extends Node> wrapper) {
        if (wrapper.isContentElement()) {
            this.elementContent = wrapper;
        } else {
            this.otherContentList.add(wrapper);
        }
    }

    void createWrappedStructure(WrapperFactory factory) {
        HierarchyWrapper currentWrapper = null;
        for (Node child : this.elementContent.getContent().content()) {
            Wrapper<Node> wrapper = factory.create(child);
            if (wrapper instanceof SingleNewlineInTextWrapper) continue;
            if (currentWrapper == null) {
                currentWrapper = new HierarchyWrapper(wrapper);
                this.children.add(currentWrapper);
            } else {
                super.addContent(wrapper);
            }
            if (!currentWrapper.containsElement()) continue;
            currentWrapper.createWrappedStructure(factory);
            currentWrapper = null;
        }
    }

    private boolean containsElement() {
        return this.elementContent != null;
    }

    Wrapper<Element> getElementContent() {
        return this.elementContent;
    }

    void processOperation(HierarchyWrapperOperation operation) {
        operation.startOfProcess();
        this.otherContentList.forEach(operation::processOtherContent);
        if (this.elementContent != null && this.elementContent.isContentElement()) {
            operation.processElement(this.elementContent);
        }
        operation.manipulateChildElements(this.children);
        HierarchyWrapperOperation subOperation = operation.createSubOperation();
        for (HierarchyWrapper child : this.children) {
            child.processOperation(subOperation);
        }
        operation.endOfProcess();
    }

    public String toString() {
        ToStringOperation operation = new ToStringOperation();
        this.processOperation(operation);
        return operation.toString();
    }
}

