/*
 * Decompiled with CFR 0.152.
 */
package io.github.tonycody.maven.plugin.sorter.wrapper.content;

import io.github.tonycody.maven.plugin.sorter.parameter.DependencySortOrder;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.dom4j.Element;

public class ChildElementSorter {
    static final ChildElementSorter EMPTY_SORTER = new ChildElementSorter();
    private static final String GROUP_ID_NAME = "GROUPID";
    private static final String EMPTY_PLUGIN_GROUP_ID_VALUE = "org.apache.maven.plugins";
    private final LinkedHashMap<String, String> childElementTextMappedBySortedNames = new LinkedHashMap();

    public ChildElementSorter(DependencySortOrder dependencySortOrder, List<Element> children) {
        Collection<String> childElementNames = dependencySortOrder.getChildElementNames();
        childElementNames.forEach(name -> this.childElementTextMappedBySortedNames.put(name.toUpperCase(), ""));
        children.forEach(element -> this.childElementTextMappedBySortedNames.replace(element.getName().toUpperCase(), element.getTextTrim()));
    }

    private ChildElementSorter() {
    }

    boolean compareTo(ChildElementSorter otherChildElementSorter) {
        Function<Map.Entry, String> getOtherTextFunc = entry -> otherChildElementSorter.childElementTextMappedBySortedNames.get(entry.getKey());
        int compare = this.childElementTextMappedBySortedNames.entrySet().stream().map(entry -> this.compareTexts((String)entry.getKey(), (String)entry.getValue(), (String)getOtherTextFunc.apply((Map.Entry)entry))).filter(i -> i != 0).findFirst().orElse(0);
        return compare < 0;
    }

    private int compareTexts(String key, String text, String otherText) {
        if ("scope".equalsIgnoreCase(key)) {
            return this.compareScope(text, otherText);
        }
        return text.compareToIgnoreCase(otherText);
    }

    private int compareScope(String childElementText, String otherChildElementText) {
        return Scope.getScope(childElementText).compareTo(Scope.getScope(otherChildElementText));
    }

    void emptyGroupIdIsFilledWithDefaultMavenGroupId() {
        this.childElementTextMappedBySortedNames.computeIfPresent(GROUP_ID_NAME, (k, oldValue) -> oldValue.isEmpty() ? EMPTY_PLUGIN_GROUP_ID_VALUE : oldValue);
    }

    public String toString() {
        return "ChildElementSorter{childElementTexts=" + this.childElementTextMappedBySortedNames.values() + '}';
    }

    private static enum Scope {
        IMPORT,
        COMPILE,
        PROVIDED,
        SYSTEM,
        RUNTIME,
        TEST,
        OTHER;


        static Scope getScope(String scope) {
            Scope[] values;
            if (scope == null || scope.isEmpty()) {
                return COMPILE;
            }
            for (Scope value : values = Scope.values()) {
                if (!scope.equalsIgnoreCase(value.name())) continue;
                return value;
            }
            return OTHER;
        }
    }
}

