/*
 * Decompiled with CFR 0.152.
 */
package io.github.tonycody.maven.plugin.sorter.wrapper;

import io.github.tonycody.maven.plugin.sorter.content.NewlineText;
import io.github.tonycody.maven.plugin.sorter.parameter.PluginParameters;
import io.github.tonycody.maven.plugin.sorter.wrapper.content.SingleNewlineInTextWrapper;
import io.github.tonycody.maven.plugin.sorter.wrapper.content.UnsortedWrapper;
import io.github.tonycody.maven.plugin.sorter.wrapper.content.Wrapper;
import org.dom4j.Node;
import org.dom4j.Text;

public class TextWrapperCreator {
    private boolean keepBlankLines;

    public void setup(PluginParameters pluginParameters) {
        this.keepBlankLines = pluginParameters.keepBlankLines;
    }

    Wrapper<Node> createWrapper(Text text) {
        if (this.isSingleNewLine(text)) {
            return SingleNewlineInTextWrapper.INSTANCE;
        }
        if (this.isBlankLineOrLines(text)) {
            return new UnsortedWrapper<NewlineText>(new NewlineText());
        }
        return new UnsortedWrapper<Text>(text);
    }

    private boolean isSingleNewLine(Text content) {
        return content.getText().matches("[\\t ]*\\r?\\n?[\\t ]*");
    }

    boolean isBlankLineOrLines(Text content) {
        if (!this.keepBlankLines) {
            return false;
        }
        return content.getText().matches("^\\s*?([\\r\\n])\\s*$");
    }
}

