/*
 * Decompiled with CFR 0.152.
 */
package io.github.tonycody.maven.plugin.sorter.wrapper;

import io.github.tonycody.maven.plugin.sorter.parameter.DependencySortOrder;
import io.github.tonycody.maven.plugin.sorter.parameter.PluginParameters;
import io.github.tonycody.maven.plugin.sorter.wrapper.ElementSortOrderMap;
import io.github.tonycody.maven.plugin.sorter.wrapper.ElementUtil;
import io.github.tonycody.maven.plugin.sorter.wrapper.content.AlphabeticalSortedWrapper;
import io.github.tonycody.maven.plugin.sorter.wrapper.content.DependencySortedWrapper;
import io.github.tonycody.maven.plugin.sorter.wrapper.content.ExclusionSortedWrapper;
import io.github.tonycody.maven.plugin.sorter.wrapper.content.ExecutionSortedWrapper;
import io.github.tonycody.maven.plugin.sorter.wrapper.content.ModuleSortedWrapper;
import io.github.tonycody.maven.plugin.sorter.wrapper.content.PluginSortedWrapper;
import io.github.tonycody.maven.plugin.sorter.wrapper.content.SortedWrapper;
import io.github.tonycody.maven.plugin.sorter.wrapper.content.UnsortedWrapper;
import io.github.tonycody.maven.plugin.sorter.wrapper.content.Wrapper;
import org.dom4j.Element;

public class ElementWrapperCreator {
    private DependencySortOrder sortDependencies;
    private DependencySortOrder sortDependencyExclusions;
    private DependencySortOrder sortDependencyManagement;
    private DependencySortOrder sortPlugins;
    private boolean sortProperties;
    private boolean sortModules;
    private boolean sortExecutions;
    private final ElementSortOrderMap elementNameSortOrderMap;

    ElementWrapperCreator(ElementSortOrderMap elementNameSortOrderMap) {
        this.elementNameSortOrderMap = elementNameSortOrderMap;
    }

    public void setup(PluginParameters pluginParameters) {
        this.sortDependencies = pluginParameters.sortDependencies;
        this.sortDependencyExclusions = pluginParameters.sortDependencyExclusions;
        this.sortDependencyManagement = pluginParameters.sortDependencyManagement;
        this.sortPlugins = pluginParameters.sortPlugins;
        this.sortProperties = pluginParameters.sortProperties;
        this.sortModules = pluginParameters.sortModules;
        this.sortExecutions = pluginParameters.sortExecutions;
    }

    Wrapper<Element> createWrapper(Element element) {
        boolean sortedBySortOrderFile = this.elementNameSortOrderMap.containsElement(element);
        if (sortedBySortOrderFile) {
            if (this.isDependencyElement(element)) {
                return this.createdDependencySortedWrapper(element);
            }
            if (this.isExclusionElement(element)) {
                ExclusionSortedWrapper exclusionSortedWrapper = new ExclusionSortedWrapper(element, this.elementNameSortOrderMap.getSortOrder(element));
                exclusionSortedWrapper.setSortOrder(this.sortDependencyExclusions);
                return exclusionSortedWrapper;
            }
            if (this.isPluginElement(element)) {
                PluginSortedWrapper pluginSortedWrapper = new PluginSortedWrapper(element, this.elementNameSortOrderMap.getSortOrder(element));
                pluginSortedWrapper.setSortOrder(this.sortPlugins);
                return pluginSortedWrapper;
            }
            if (this.isModuleElement(element)) {
                return new ModuleSortedWrapper(element, this.elementNameSortOrderMap.getSortOrder(element));
            }
            if (this.isExecutionElement(element)) {
                return new ExecutionSortedWrapper(element, this.elementNameSortOrderMap.getSortOrder(element));
            }
            return new SortedWrapper(element, this.elementNameSortOrderMap.getSortOrder(element));
        }
        if (this.isPropertyElement(element)) {
            return new AlphabeticalSortedWrapper(element);
        }
        return new UnsortedWrapper<Element>(element);
    }

    private DependencySortedWrapper createdDependencySortedWrapper(Element element) {
        DependencySortedWrapper dependencySortedWrapper = new DependencySortedWrapper(element, this.elementNameSortOrderMap.getSortOrder(element));
        if (this.isDependencyElementInManagement(element) && !this.sortDependencyManagement.isNoSorting()) {
            dependencySortedWrapper.setSortOrder(this.sortDependencyManagement);
        } else {
            dependencySortedWrapper.setSortOrder(this.sortDependencies);
        }
        return dependencySortedWrapper;
    }

    private boolean isDependencyElementInManagement(Element element) {
        return ElementUtil.isElementParentName(element.getParent(), "dependencyManagement");
    }

    private boolean isDependencyElement(Element element) {
        if (this.sortDependencies.isNoSorting() && this.sortDependencyManagement.isNoSorting()) {
            return false;
        }
        return ElementUtil.isElementName(element, "dependency") && ElementUtil.isElementParentName(element, "dependencies");
    }

    private boolean isExclusionElement(Element element) {
        if (this.sortDependencyExclusions.isNoSorting()) {
            return false;
        }
        return ElementUtil.isElementName(element, "exclusion") && ElementUtil.isElementParentName(element, "exclusions");
    }

    private boolean isPluginElement(Element element) {
        if (this.sortPlugins.isNoSorting()) {
            return false;
        }
        return ElementUtil.isElementName(element, "plugin") && (ElementUtil.isElementParentName(element, "plugins") || ElementUtil.isElementParentName(element, "reportPlugins"));
    }

    private boolean isModuleElement(Element element) {
        if (!this.sortModules) {
            return false;
        }
        return ElementUtil.isElementName(element, "module") && ElementUtil.isElementParentName(element, "modules");
    }

    private boolean isExecutionElement(Element element) {
        if (!this.sortExecutions) {
            return false;
        }
        return ElementUtil.isElementName(element, "execution") && ElementUtil.isElementParentName(element, "executions");
    }

    private boolean isPropertyElement(Element element) {
        if (!this.sortProperties) {
            return false;
        }
        String deepName = ElementUtil.getDeepName(element);
        boolean inTheRightPlace = deepName.startsWith("/project/properties/") || deepName.startsWith("/project/profiles/profile/properties/");
        return inTheRightPlace && ElementUtil.isElementParentName(element, "properties");
    }
}

