/*
 * Decompiled with CFR 0.152.
 */
package io.github.tonycody.maven.plugin.sorter.verify;

import io.github.tonycody.maven.plugin.sorter.util.XmlOrderedResult;
import java.util.List;
import org.dom4j.Element;

public class ElementComparator {
    private final Element originalElement;
    private final Element newElement;

    public ElementComparator(Element originalElement, Element newElement) {
        this.originalElement = originalElement;
        this.newElement = newElement;
    }

    public XmlOrderedResult isElementOrdered() {
        if (!this.originalElement.getName().equals(this.newElement.getName())) {
            return XmlOrderedResult.nameDiffers(this.originalElement.getName(), this.newElement.getName());
        }
        if (this.isEqualsIgnoringWhitespace()) {
            return XmlOrderedResult.textContentDiffers(this.originalElement.getName(), this.originalElement.getText(), this.newElement.getText());
        }
        return this.isChildrenOrdered(this.originalElement.getName(), this.originalElement.elements(), this.newElement.elements());
    }

    private boolean isEqualsIgnoringWhitespace() {
        return !this.originalElement.getText().replaceAll("\\s", "").equals(this.newElement.getText().replaceAll("\\s", ""));
    }

    private XmlOrderedResult isChildrenOrdered(String name, List<Element> originalElementChildren, List<Element> newElementChildren) {
        int size = Math.min(originalElementChildren.size(), newElementChildren.size());
        for (int i = 0; i < size; ++i) {
            ElementComparator elementComparator = new ElementComparator(originalElementChildren.get(i), newElementChildren.get(i));
            XmlOrderedResult elementOrdered = elementComparator.isElementOrdered();
            if (elementOrdered.isOrdered()) continue;
            return elementOrdered;
        }
        if (originalElementChildren.size() != newElementChildren.size()) {
            return XmlOrderedResult.childElementDiffers(name, originalElementChildren.size(), newElementChildren.size());
        }
        return XmlOrderedResult.ordered();
    }
}

