/*
 * Decompiled with CFR 0.152.
 */
package io.github.tonycody.maven.plugin.sorter.util;

import java.io.StringWriter;
import java.io.Writer;

public class StringLineSeparatorWriter
extends Writer {
    private static final char NEWLINE = '\n';
    private final String lineSeparator;
    private boolean wasNewLine = false;
    private final StringBuilder lineBuffer = new StringBuilder();
    private final StringWriter out;

    public StringLineSeparatorWriter(StringWriter out, String lineSeparator) {
        this.out = out;
        this.lineSeparator = lineSeparator;
    }

    @Override
    public void write(String str) {
        char[] chars;
        for (char ch : chars = str.toCharArray()) {
            this.writeOneCharacter(ch);
        }
    }

    @Override
    public void write(int c) {
        this.writeOneCharacter((char)c);
    }

    @Override
    public void write(char[] cb, int off, int len) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() {
        this.writeCharacterBuffer();
    }

    private void writeOneCharacter(char ch) {
        this.writeDelayedNewline();
        if (ch == '\n') {
            this.writeCharacterBuffer();
            this.wasNewLine = true;
        } else {
            this.lineBuffer.append(ch);
        }
    }

    public void writeDelayedNewline() {
        if (this.wasNewLine) {
            this.writeLineSeparator();
            this.wasNewLine = false;
        }
    }

    private void writeCharacterBuffer() {
        this.out.write(this.lineBuffer.toString());
        this.clearLineBuffer();
    }

    private void writeLineSeparator() {
        this.out.write(this.lineSeparator);
    }

    public void clearLineBuffer() {
        this.lineBuffer.delete(0, this.lineBuffer.length());
    }

    public String toString() {
        this.writeCharacterBuffer();
        return this.out.toString();
    }

    @Override
    public void flush() {
        throw new UnsupportedOperationException();
    }
}

