/*
 * Decompiled with CFR 0.152.
 */
package io.github.tonycody.maven.plugin.sorter.util;

import cn.hutool.core.io.IoUtil;
import io.github.tonycody.maven.plugin.sorter.exception.FailureException;
import io.github.tonycody.maven.plugin.sorter.parameter.PluginParameters;
import io.github.tonycody.maven.plugin.sorter.util.CheckedSupplier;
import io.github.tonycody.maven.plugin.sorter.util.FileAttributeUtil;
import io.github.tonycody.maven.plugin.sorter.util.UrlWrapper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;

public class FileHelper {
    private static final String BACKUP_FILE_NAME = ".sorted-pom.xml";
    private static final String XML_FILE_EXTENSION = ".xml";
    private final FileAttributeUtil fileAttrUtils = new FileAttributeUtil();
    private File originalPom;
    private File outputDirectory;
    private String encoding;
    private String customSortOrderFile;
    private String predefinedSortOrder;
    private String newName;
    private File backupFile;
    private String violationFilename;
    private long timestamp;
    private boolean keepTimestamp;

    public void setup(PluginParameters parameters) {
        this.originalPom = parameters.originalPom;
        this.outputDirectory = parameters.outputDirectory;
        this.encoding = parameters.encoding;
        this.customSortOrderFile = parameters.customSortOrderFile;
        this.predefinedSortOrder = parameters.predefinedSortOrder;
        this.violationFilename = parameters.violationFilename;
        this.keepTimestamp = parameters.keepTimestamp;
    }

    public void backupFile() {
        this.createFileHandle();
        this.checkBackupFileAccess();
        this.createBackupFile();
    }

    void createFileHandle() {
        Path outPath = this.outputDirectory.toPath();
        Path resolve = outPath.resolve(BACKUP_FILE_NAME);
        try {
            Files.createDirectories(resolve.getParent(), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.backupFile = resolve.toFile();
    }

    public Optional<Path> cleanup() {
        Path outPath = this.outputDirectory.toPath();
        Path resolve = outPath.resolve(BACKUP_FILE_NAME);
        try {
            boolean b = Files.deleteIfExists(resolve);
            if (b) {
                return Optional.of(resolve);
            }
            return Optional.empty();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void checkBackupFileAccess() {
        try {
            Files.deleteIfExists(this.backupFile.toPath());
        }
        catch (IOException e) {
            throw new FailureException("Could not remove old backup file, filename: " + this.newName, e);
        }
    }

    private void createBackupFile() {
        try {
            Files.copy(this.originalPom.toPath(), this.backupFile.toPath(), new CopyOption[0]);
        }
        catch (IOException e) {
            throw new FailureException("Could not create backup file to filename: " + this.newName, e);
        }
    }

    public String getPomFileContent() {
        String content;
        try {
            content = new String(Files.readAllBytes(this.originalPom.toPath()), Charset.forName(this.encoding));
        }
        catch (Exception ex) {
            throw new FailureException("Could not read pom file: " + this.originalPom.getAbsolutePath(), ex);
        }
        this.savePomfileTimestamp();
        return content;
    }

    private void savePomfileTimestamp() {
        if (this.keepTimestamp) {
            this.timestamp = this.fileAttrUtils.getLastModifiedTimestamp(this.originalPom);
            if (this.timestamp == 0L) {
                throw new FailureException("Could not retrieve the timestamp of the pom file: " + this.originalPom.getAbsolutePath());
            }
        }
    }

    public void saveViolationFile(String violationXml) {
        File violationFile = new File(this.violationFilename);
        this.saveFile(violationFile, violationXml, "Could not save violation file: " + violationFile.getAbsolutePath());
    }

    public void savePomFile(String sortedXml) {
        this.saveFile(this.originalPom, sortedXml, "Could not save sorted pom file: " + this.originalPom.getAbsolutePath());
        this.setPomfileTimestamp();
    }

    private void saveFile(File fileToSave, String content, String errorMessage) {
        try {
            Files.createDirectories(fileToSave.getParentFile().toPath(), new FileAttribute[0]);
            Files.write(fileToSave.toPath(), content.getBytes(this.encoding), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new FailureException(errorMessage, e);
        }
    }

    private void setPomfileTimestamp() {
        if (this.keepTimestamp) {
            try {
                this.fileAttrUtils.setTimestamps(this.originalPom, this.timestamp);
            }
            catch (IOException e) {
                throw new FailureException("Could not change timestamp of new pom file: " + this.originalPom.getAbsolutePath(), e);
            }
        }
    }

    public String getDefaultSortOrderXml() throws IOException {
        CheckedSupplier createStreamFunc = () -> {
            if (this.customSortOrderFile != null) {
                UrlWrapper urlWrapper = new UrlWrapper(this.customSortOrderFile);
                if (urlWrapper.isUrl()) {
                    return urlWrapper.openStream();
                }
                return this.openCustomSortOrderFile();
            }
            return this.getPredefinedSortOrder(this.predefinedSortOrder);
        };
        return IoUtil.read((InputStream)createStreamFunc.get(), (Charset)StandardCharsets.UTF_8);
    }

    private InputStream openCustomSortOrderFile() throws FileNotFoundException {
        InputStream inputStream;
        try {
            inputStream = new FileInputStream(this.customSortOrderFile);
        }
        catch (FileNotFoundException ex) {
            try {
                URL resource = this.getClass().getClassLoader().getResource(this.customSortOrderFile);
                if (resource == null) {
                    throw new IOException("Cannot find resource");
                }
                inputStream = resource.openStream();
            }
            catch (IOException e1) {
                throw new FileNotFoundException(String.format("Could not find %s or %s in classpath", new File(this.customSortOrderFile).getAbsolutePath(), this.customSortOrderFile));
            }
        }
        return inputStream;
    }

    private InputStream getPredefinedSortOrder(String predefinedSortOrder) throws IOException {
        Optional<URL> resourceOptional = Optional.of(this.getClass()).map(Class::getClassLoader).map(classLoader -> classLoader.getResource(predefinedSortOrder + XML_FILE_EXTENSION));
        URL resource = resourceOptional.orElseThrow(() -> new IllegalArgumentException(String.format("Cannot find %s among the predefined plugin resources", predefinedSortOrder + XML_FILE_EXTENSION)));
        return resource.openStream();
    }
}

