/*
 * Decompiled with CFR 0.152.
 */
package io.github.tonycody.maven.plugin.sorter.processinstruction;

import java.util.regex.Pattern;

enum InstructionType {
    IGNORE,
    RESUME;

    static final Pattern INSTRUCTION_PATTERN;
    static final Pattern IGNORE_SECTIONS_PATTERN;
    static final Pattern TOKEN_PATTERN;

    public InstructionType next() {
        if (this == IGNORE) {
            return RESUME;
        }
        return IGNORE;
    }

    public static boolean containsType(String instruction) {
        return IGNORE.name().equalsIgnoreCase(instruction) || RESUME.name().equalsIgnoreCase(instruction);
    }

    public boolean matches(String instruction) {
        return this.name().equalsIgnoreCase(instruction);
    }

    static {
        INSTRUCTION_PATTERN = Pattern.compile("(?i)<\\?sortpom\\s+([\\w\"'*= ]*)\\s*\\?>");
        IGNORE_SECTIONS_PATTERN = Pattern.compile("(?is)<\\?sortpom\\s+" + (Object)((Object)IGNORE) + "\\s*\\?>.*?<\\?sortpom\\s+" + (Object)((Object)RESUME) + "\\s*\\?>");
        TOKEN_PATTERN = Pattern.compile("(?i)<\\?sortpom\\s+token='(\\d+)'\\s*\\?>");
    }
}

