/*
 * Decompiled with CFR 0.152.
 */
package io.github.tonycody.maven.plugin.sorter.processinstruction;

import io.github.tonycody.maven.plugin.sorter.processinstruction.InstructionType;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;

class IgnoredSectionsStore {
    private final List<String> ignoredSections = new ArrayList<String>();

    IgnoredSectionsStore() {
    }

    public String replaceIgnoredSections(String originalXml) {
        Matcher matcher = InstructionType.IGNORE_SECTIONS_PATTERN.matcher(originalXml);
        StringBuffer returnValue = new StringBuffer();
        int i = 0;
        while (matcher.find()) {
            this.ignoredSections.add(matcher.group());
            matcher.appendReplacement(returnValue, String.format("<?sortpom token='%d'?>", i));
            ++i;
        }
        matcher.appendTail(returnValue);
        return returnValue.toString();
    }

    public String revertIgnoredSections(String sortedXml) {
        Matcher matcher = InstructionType.TOKEN_PATTERN.matcher(sortedXml);
        StringBuffer returnValue = new StringBuffer();
        while (matcher.find()) {
            int index = Integer.parseInt(matcher.group(1));
            String replacement = this.ignoredSections.get(index);
            String oneBackslashBeforeBackslash = replacement.replace("\\", "\\\\");
            String oneBackslashBeforeDollar = oneBackslashBeforeBackslash.replace("$", "\\$");
            matcher.appendReplacement(returnValue, oneBackslashBeforeDollar);
        }
        matcher.appendTail(returnValue);
        return returnValue.toString();
    }
}

