/*
 * Decompiled with CFR 0.152.
 */
package io.github.tonycody.maven.plugin.sorter.output;

import io.github.tonycody.maven.plugin.sorter.exception.FailureException;
import io.github.tonycody.maven.plugin.sorter.output.PatchedXMLWriter;
import io.github.tonycody.maven.plugin.sorter.parameter.PluginParameters;
import io.github.tonycody.maven.plugin.sorter.util.StringLineSeparatorWriter;
import java.io.IOException;
import java.io.StringWriter;
import org.dom4j.Document;
import org.dom4j.io.OutputFormat;

public class XmlOutputGenerator {
    private String encoding;
    private String indentCharacters;
    private boolean expandEmptyElements;
    private boolean indentBlankLines;
    private boolean indentSchemaLocation;
    private boolean spaceBeforeCloseEmptyElement;
    private String lineSeparator;

    public void setup(PluginParameters pluginParameters) {
        this.indentCharacters = pluginParameters.indentCharacters;
        this.encoding = pluginParameters.encoding;
        this.expandEmptyElements = pluginParameters.expandEmptyElements;
        this.indentBlankLines = pluginParameters.indentBlankLines;
        this.indentSchemaLocation = pluginParameters.indentSchemaLocation;
        this.spaceBeforeCloseEmptyElement = pluginParameters.spaceBeforeCloseEmptyElement;
        this.lineSeparator = pluginParameters.lineSeparatorUtil.toString();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public String getSortedXml(Document newDocument) {
        try (StringWriter out = new StringWriter();){
            StringLineSeparatorWriter writer = new StringLineSeparatorWriter(out, this.lineSeparator);
            try {
                PatchedXMLWriter xmlWriter = new PatchedXMLWriter(writer, this.createPrettyFormat(), this.spaceBeforeCloseEmptyElement, this.indentBlankLines, this.indentSchemaLocation);
                xmlWriter.write(newDocument);
                writer.writeDelayedNewline();
                String string = writer.toString();
                writer.close();
                return string;
            }
            catch (Throwable throwable) {
                try {
                    writer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ioex) {
            throw new FailureException("Could not format pom files content", ioex);
        }
    }

    private OutputFormat createPrettyFormat() {
        OutputFormat outputFormat = new OutputFormat(this.indentCharacters);
        outputFormat.setNewlines(true);
        outputFormat.setExpandEmptyElements(this.expandEmptyElements);
        outputFormat.setNewLineAfterDeclaration(false);
        outputFormat.setEncoding(this.encoding);
        return outputFormat;
    }
}

