/*
 * Decompiled with CFR 0.152.
 */
package io.github.swagger2markup.internal.utils;

import io.github.swagger2markup.model.PathOperation;
import io.swagger.models.HttpMethod;
import io.swagger.models.Operation;
import io.swagger.models.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class PathUtils {
    private static Map<HttpMethod, Operation> getOperationMap(Path path) {
        LinkedHashMap<HttpMethod, Operation> result = new LinkedHashMap<HttpMethod, Operation>();
        if (path.getGet() != null) {
            result.put(HttpMethod.GET, path.getGet());
        }
        if (path.getPut() != null) {
            result.put(HttpMethod.PUT, path.getPut());
        }
        if (path.getPost() != null) {
            result.put(HttpMethod.POST, path.getPost());
        }
        if (path.getDelete() != null) {
            result.put(HttpMethod.DELETE, path.getDelete());
        }
        if (path.getPatch() != null) {
            result.put(HttpMethod.PATCH, path.getPatch());
        }
        if (path.getHead() != null) {
            result.put(HttpMethod.HEAD, path.getHead());
        }
        if (path.getOptions() != null) {
            result.put(HttpMethod.OPTIONS, path.getOptions());
        }
        return result;
    }

    public static List<PathOperation> toPathOperationsList(Map<String, Path> paths, String basePath, Comparator<PathOperation> comparator) {
        ArrayList<PathOperation> pathOperations = new ArrayList<PathOperation>();
        paths.forEach((relativePath, path) -> pathOperations.addAll(PathUtils.toPathOperationsList(basePath + relativePath, path)));
        if (comparator != null) {
            Collections.sort(pathOperations, comparator);
        }
        return pathOperations;
    }

    public static List<PathOperation> toPathOperationsList(String path, Path pathModel) {
        ArrayList<PathOperation> pathOperations = new ArrayList<PathOperation>();
        PathUtils.getOperationMap(pathModel).forEach((httpMethod, operation) -> pathOperations.add(new PathOperation((HttpMethod)httpMethod, path, (Operation)operation)));
        return pathOperations;
    }
}

