/*
 * Decompiled with CFR 0.152.
 */
package io.github.swagger2markup.internal.component;

import ch.netzwerg.paleo.ColumnIds;
import ch.netzwerg.paleo.StringColumn;
import io.github.swagger2markup.Swagger2MarkupConverter;
import io.github.swagger2markup.internal.adapter.PropertyAdapter;
import io.github.swagger2markup.internal.component.TableComponent;
import io.github.swagger2markup.internal.resolver.DocumentResolver;
import io.github.swagger2markup.internal.type.ObjectType;
import io.github.swagger2markup.internal.type.Type;
import io.github.swagger2markup.internal.utils.InlineSchemaUtils;
import io.github.swagger2markup.internal.utils.MarkupDocBuilderUtils;
import io.github.swagger2markup.markup.builder.MarkupDocBuilder;
import io.github.swagger2markup.spi.MarkupComponent;
import io.swagger.models.properties.Property;
import io.swagger.util.Json;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class PropertiesTableComponent
extends MarkupComponent<Parameters> {
    private final DocumentResolver definitionDocumentResolver;
    private final TableComponent tableComponent;

    PropertiesTableComponent(Swagger2MarkupConverter.Context context, DocumentResolver definitionDocumentResolver) {
        super(context);
        this.definitionDocumentResolver = definitionDocumentResolver;
        this.tableComponent = new TableComponent(context);
    }

    public static Parameters parameters(Map<String, Property> properties, String parameterName, List<ObjectType> inlineDefinitions) {
        return new Parameters(properties, parameterName, inlineDefinitions);
    }

    public MarkupDocBuilder apply(MarkupDocBuilder markupDocBuilder, Parameters params) {
        StringColumn.Builder nameColumnBuilder = StringColumn.builder((ColumnIds.StringColumnId)ColumnIds.StringColumnId.of((String)this.labels.getLabel("name_column"))).putMetaData("widthRatio", "3");
        StringColumn.Builder descriptionColumnBuilder = StringColumn.builder((ColumnIds.StringColumnId)ColumnIds.StringColumnId.of((String)this.labels.getLabel("description_column"))).putMetaData("widthRatio", "11").putMetaData("headerColumn", "true");
        StringColumn.Builder schemaColumnBuilder = StringColumn.builder((ColumnIds.StringColumnId)ColumnIds.StringColumnId.of((String)this.labels.getLabel("schema_column"))).putMetaData("widthRatio", "4").putMetaData("headerColumn", "true");
        Map properties = params.properties;
        if (MapUtils.isNotEmpty((Map)properties)) {
            Map<String, Property> sortedProperties = io.github.swagger2markup.internal.utils.MapUtils.toSortedMap(properties, this.config.getPropertyOrdering());
            sortedProperties.forEach((propertyName, property) -> {
                PropertyAdapter propertyAdapter = new PropertyAdapter((Property)property);
                Type propertyType = propertyAdapter.getType(this.definitionDocumentResolver);
                if (this.config.isInlineSchemaEnabled()) {
                    propertyType = InlineSchemaUtils.createInlineType(propertyType, propertyName, params.parameterName + " " + propertyName, params.inlineDefinitions);
                }
                Optional<Object> optionalExample = propertyAdapter.getExample(this.config.isGeneratedExamplesEnabled(), markupDocBuilder);
                Optional<Object> optionalDefaultValue = propertyAdapter.getDefaultValue();
                Optional<Integer> optionalMaxLength = propertyAdapter.getMaxlength();
                Optional<Integer> optionalMinLength = propertyAdapter.getMinlength();
                Optional<String> optionalPattern = propertyAdapter.getPattern();
                Optional<Number> optionalMinValue = propertyAdapter.getMin();
                boolean exclusiveMin = propertyAdapter.getExclusiveMin();
                Optional<Number> optionalMaxValue = propertyAdapter.getMax();
                boolean exclusiveMax = propertyAdapter.getExclusiveMax();
                MarkupDocBuilder propertyNameContent = MarkupDocBuilderUtils.copyMarkupDocBuilder(markupDocBuilder);
                propertyNameContent.boldTextLine(propertyName, true);
                if (property.getRequired()) {
                    propertyNameContent.italicText(this.labels.getLabel("flags.required").toLowerCase());
                } else {
                    propertyNameContent.italicText(this.labels.getLabel("flags.optional").toLowerCase());
                }
                if (propertyAdapter.getReadOnly()) {
                    propertyNameContent.newLine(true);
                    propertyNameContent.italicText(this.labels.getLabel("flags.read_only").toLowerCase());
                }
                MarkupDocBuilder descriptionContent = MarkupDocBuilderUtils.copyMarkupDocBuilder(markupDocBuilder);
                String description = MarkupDocBuilderUtils.markupDescription(this.config.getSwaggerMarkupLanguage(), markupDocBuilder, property.getDescription());
                if (StringUtils.isNotBlank((CharSequence)description)) {
                    descriptionContent.text(description);
                }
                if (optionalDefaultValue.isPresent()) {
                    if (StringUtils.isNotBlank((CharSequence)descriptionContent.toString())) {
                        descriptionContent.newLine(true);
                    }
                    descriptionContent.boldText(this.labels.getLabel("default_column")).text(" : ").literalText(Json.pretty((Object)optionalDefaultValue.get()));
                }
                if (optionalMinLength.isPresent() && optionalMaxLength.isPresent()) {
                    Integer minLength = optionalMinLength.get();
                    Integer maxLength = optionalMaxLength.get();
                    if (StringUtils.isNotBlank((CharSequence)descriptionContent.toString())) {
                        descriptionContent.newLine(true);
                    }
                    String lengthRange = minLength + " - " + maxLength;
                    if (minLength.equals(maxLength)) {
                        lengthRange = minLength.toString();
                    }
                    descriptionContent.boldText(this.labels.getLabel("length_column")).text(" : ").literalText(lengthRange);
                } else {
                    if (optionalMinLength.isPresent()) {
                        if (StringUtils.isNotBlank((CharSequence)descriptionContent.toString())) {
                            descriptionContent.newLine(true);
                        }
                        descriptionContent.boldText(this.labels.getLabel("minlength_column")).text(" : ").literalText(optionalMinLength.get().toString());
                    }
                    if (optionalMaxLength.isPresent()) {
                        if (StringUtils.isNotBlank((CharSequence)descriptionContent.toString())) {
                            descriptionContent.newLine(true);
                        }
                        descriptionContent.boldText(this.labels.getLabel("maxlength_column")).text(" : ").literalText(optionalMaxLength.get().toString());
                    }
                }
                if (optionalPattern.isPresent()) {
                    if (StringUtils.isNotBlank((CharSequence)descriptionContent.toString())) {
                        descriptionContent.newLine(true);
                    }
                    descriptionContent.boldText(this.labels.getLabel("pattern_column")).text(" : ").literalText(Json.pretty((Object)optionalPattern.get()));
                }
                if (optionalMinValue.isPresent()) {
                    if (StringUtils.isNotBlank((CharSequence)descriptionContent.toString())) {
                        descriptionContent.newLine(true);
                    }
                    String minValueColumn = exclusiveMin ? this.labels.getLabel("minvalue_exclusive_column") : this.labels.getLabel("minvalue_column");
                    descriptionContent.boldText(minValueColumn).text(" : ").literalText(optionalMinValue.get().toString());
                }
                if (optionalMaxValue.isPresent()) {
                    if (StringUtils.isNotBlank((CharSequence)descriptionContent.toString())) {
                        descriptionContent.newLine(true);
                    }
                    String maxValueColumn = exclusiveMax ? this.labels.getLabel("maxvalue_exclusive_column") : this.labels.getLabel("maxvalue_column");
                    descriptionContent.boldText(maxValueColumn).text(" : ").literalText(optionalMaxValue.get().toString());
                }
                if (optionalExample.isPresent()) {
                    if (StringUtils.isNotBlank((CharSequence)description) || optionalDefaultValue.isPresent()) {
                        descriptionContent.newLine(true);
                    }
                    descriptionContent.boldText(this.labels.getLabel("example_column")).text(" : ").literalText(Json.pretty((Object)optionalExample.get()));
                }
                nameColumnBuilder.add(propertyNameContent.toString());
                descriptionColumnBuilder.add(descriptionContent.toString());
                schemaColumnBuilder.add(propertyType.displaySchema(markupDocBuilder));
            });
        }
        return this.tableComponent.apply(markupDocBuilder, TableComponent.parameters(nameColumnBuilder.build(), descriptionColumnBuilder.build(), schemaColumnBuilder.build()));
    }

    public static class Parameters {
        private final Map<String, Property> properties;
        private final String parameterName;
        private final List<ObjectType> inlineDefinitions;

        public Parameters(Map<String, Property> properties, String parameterName, List<ObjectType> inlineDefinitions) {
            this.properties = (Map)Validate.notNull(properties, (String)"Properties must not be null", (Object[])new Object[0]);
            this.parameterName = (String)Validate.notBlank((CharSequence)parameterName, (String)"ParameterName must not be blank", (Object[])new Object[0]);
            this.inlineDefinitions = (List)Validate.notNull(inlineDefinitions, (String)"InlineDefinitions must not be null", (Object[])new Object[0]);
        }
    }
}

