/*
 * Decompiled with CFR 0.152.
 */
package io.github.swagger2markup.internal.component;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.github.swagger2markup.GroupBy;
import io.github.swagger2markup.PageBreakLocations;
import io.github.swagger2markup.Swagger2MarkupConverter;
import io.github.swagger2markup.internal.component.BodyParameterComponent;
import io.github.swagger2markup.internal.component.ConsumesComponent;
import io.github.swagger2markup.internal.component.ParameterTableComponent;
import io.github.swagger2markup.internal.component.ProducesComponent;
import io.github.swagger2markup.internal.component.PropertiesTableComponent;
import io.github.swagger2markup.internal.component.ResponseComponent;
import io.github.swagger2markup.internal.component.SecuritySchemeComponent;
import io.github.swagger2markup.internal.resolver.DocumentResolver;
import io.github.swagger2markup.internal.type.ObjectType;
import io.github.swagger2markup.internal.utils.ExamplesUtil;
import io.github.swagger2markup.internal.utils.MarkupDocBuilderUtils;
import io.github.swagger2markup.markup.builder.MarkupAdmonition;
import io.github.swagger2markup.markup.builder.MarkupBlockStyle;
import io.github.swagger2markup.markup.builder.MarkupDocBuilder;
import io.github.swagger2markup.model.PathOperation;
import io.github.swagger2markup.spi.MarkupComponent;
import io.github.swagger2markup.spi.PathsDocumentExtension;
import io.swagger.models.Model;
import io.swagger.util.Json;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.math.NumberUtils;

public class PathOperationComponent
extends MarkupComponent<Parameters> {
    private final DocumentResolver definitionDocumentResolver;
    private final Map<String, Model> definitions;
    private final PropertiesTableComponent propertiesTableComponent;
    private final ParameterTableComponent parameterTableComponent;
    private final ConsumesComponent consumesComponent;
    private final ProducesComponent producesComponent;
    private final SecuritySchemeComponent securitySchemeComponent;
    private final BodyParameterComponent bodyParameterComponent;
    private final ResponseComponent responseComponent;

    public PathOperationComponent(Swagger2MarkupConverter.Context context, DocumentResolver definitionDocumentResolver, DocumentResolver securityDocumentResolver) {
        super(context);
        this.definitions = context.getSwagger().getDefinitions();
        this.definitionDocumentResolver = (DocumentResolver)Validate.notNull((Object)definitionDocumentResolver, (String)"DocumentResolver must not be null", (Object[])new Object[0]);
        this.propertiesTableComponent = new PropertiesTableComponent(context, definitionDocumentResolver);
        this.parameterTableComponent = new ParameterTableComponent(context, definitionDocumentResolver);
        this.consumesComponent = new ConsumesComponent(context);
        this.producesComponent = new ProducesComponent(context);
        this.securitySchemeComponent = new SecuritySchemeComponent(context, securityDocumentResolver);
        this.bodyParameterComponent = new BodyParameterComponent(context, definitionDocumentResolver);
        this.responseComponent = new ResponseComponent(context, definitionDocumentResolver);
    }

    public static Parameters parameters(PathOperation operation) {
        return new Parameters(operation);
    }

    public MarkupDocBuilder apply(MarkupDocBuilder markupDocBuilder, Parameters params) {
        PathOperation operation = params.operation;
        List<PageBreakLocations> locations = this.config.getPageBreakLocations();
        this.applyPathsDocumentExtension(new PathsDocumentExtension.Context(PathsDocumentExtension.Position.OPERATION_BEFORE, markupDocBuilder, operation));
        if (locations.contains((Object)PageBreakLocations.BEFORE_OPERATION)) {
            markupDocBuilder.pageBreak();
        }
        this.buildOperationTitle(markupDocBuilder, operation);
        this.applyPathsDocumentExtension(new PathsDocumentExtension.Context(PathsDocumentExtension.Position.OPERATION_BEGIN, markupDocBuilder, operation));
        this.buildDeprecatedSection(markupDocBuilder, operation);
        if (locations.contains((Object)PageBreakLocations.BEFORE_OPERATION_DESCRIPTION)) {
            markupDocBuilder.pageBreak();
        }
        this.buildDescriptionSection(markupDocBuilder, operation);
        if (locations.contains((Object)PageBreakLocations.AFTER_OPERATION_DESCRIPTION)) {
            markupDocBuilder.pageBreak();
        }
        if (locations.contains((Object)PageBreakLocations.BEFORE_OPERATION_PARAMETERS)) {
            markupDocBuilder.pageBreak();
        }
        this.inlineDefinitions(markupDocBuilder, this.buildParametersSection(markupDocBuilder, operation), operation.getPath() + " " + operation.getMethod());
        if (locations.contains((Object)PageBreakLocations.AFTER_OPERATION_PARAMETERS)) {
            markupDocBuilder.pageBreak();
        }
        this.inlineDefinitions(markupDocBuilder, this.buildBodyParameterSection(markupDocBuilder, operation), operation.getPath() + " " + operation.getMethod());
        if (locations.contains((Object)PageBreakLocations.BEFORE_OPERATION_RESPONSES)) {
            markupDocBuilder.pageBreak();
        }
        this.inlineDefinitions(markupDocBuilder, this.buildResponsesSection(markupDocBuilder, operation), operation.getPath() + " " + operation.getMethod());
        if (locations.contains((Object)PageBreakLocations.AFTER_OPERATION_RESPONSES)) {
            markupDocBuilder.pageBreak();
        }
        if (locations.contains((Object)PageBreakLocations.BEFORE_OPERATION_CONSUMES)) {
            markupDocBuilder.pageBreak();
        }
        this.buildConsumesSection(markupDocBuilder, operation);
        if (locations.contains((Object)PageBreakLocations.AFTER_OPERATION_CONSUMES)) {
            markupDocBuilder.pageBreak();
        }
        if (locations.contains((Object)PageBreakLocations.BEFORE_OPERATION_PRODUCES)) {
            markupDocBuilder.pageBreak();
        }
        this.buildProducesSection(markupDocBuilder, operation);
        if (locations.contains((Object)PageBreakLocations.AFTER_OPERATION_PRODUCES)) {
            markupDocBuilder.pageBreak();
        }
        this.buildTagsSection(markupDocBuilder, operation);
        this.buildSecuritySchemeSection(markupDocBuilder, operation);
        this.buildExamplesSection(markupDocBuilder, operation, locations);
        this.applyPathsDocumentExtension(new PathsDocumentExtension.Context(PathsDocumentExtension.Position.OPERATION_END, markupDocBuilder, operation));
        this.applyPathsDocumentExtension(new PathsDocumentExtension.Context(PathsDocumentExtension.Position.OPERATION_AFTER, markupDocBuilder, operation));
        if (locations.contains((Object)PageBreakLocations.AFTER_OPERATION)) {
            markupDocBuilder.pageBreak();
        }
        return markupDocBuilder;
    }

    private void buildOperationTitle(MarkupDocBuilder markupDocBuilder, PathOperation operation) {
        this.buildOperationTitle(markupDocBuilder, operation.getTitle(), operation.getId());
        if (operation.getTitle().equals(operation.getOperation().getSummary())) {
            markupDocBuilder.block(operation.getMethod() + " " + operation.getPath(), MarkupBlockStyle.LITERAL);
        }
    }

    private void buildOperationTitle(MarkupDocBuilder markupDocBuilder, String title, String anchor) {
        if (this.config.getPathsGroupedBy() == GroupBy.AS_IS) {
            markupDocBuilder.sectionTitleWithAnchorLevel2(title, anchor);
        } else {
            markupDocBuilder.sectionTitleWithAnchorLevel3(title, anchor);
        }
    }

    private void buildDeprecatedSection(MarkupDocBuilder markupDocBuilder, PathOperation operation) {
        if (BooleanUtils.isTrue((Boolean)operation.getOperation().isDeprecated())) {
            markupDocBuilder.block("operation.deprecated", MarkupBlockStyle.EXAMPLE, null, MarkupAdmonition.CAUTION);
        }
    }

    private void buildDescriptionSection(MarkupDocBuilder markupDocBuilder, PathOperation operation) {
        MarkupDocBuilder descriptionBuilder = MarkupDocBuilderUtils.copyMarkupDocBuilder(markupDocBuilder);
        this.applyPathsDocumentExtension(new PathsDocumentExtension.Context(PathsDocumentExtension.Position.OPERATION_DESCRIPTION_BEGIN, descriptionBuilder, operation));
        String description = operation.getOperation().getDescription();
        if (StringUtils.isNotBlank((CharSequence)description)) {
            descriptionBuilder.paragraph(MarkupDocBuilderUtils.markupDescription(this.config.getSwaggerMarkupLanguage(), markupDocBuilder, description));
        }
        this.applyPathsDocumentExtension(new PathsDocumentExtension.Context(PathsDocumentExtension.Position.OPERATION_DESCRIPTION_END, descriptionBuilder, operation));
        String descriptionContent = descriptionBuilder.toString();
        this.applyPathsDocumentExtension(new PathsDocumentExtension.Context(PathsDocumentExtension.Position.OPERATION_DESCRIPTION_BEFORE, markupDocBuilder, operation));
        if (StringUtils.isNotBlank((CharSequence)descriptionContent)) {
            this.buildSectionTitle(markupDocBuilder, this.labels.getLabel("description_column"));
            markupDocBuilder.text(descriptionContent);
        }
        this.applyPathsDocumentExtension(new PathsDocumentExtension.Context(PathsDocumentExtension.Position.OPERATION_DESCRIPTION_AFTER, markupDocBuilder, operation));
    }

    private List<ObjectType> buildParametersSection(MarkupDocBuilder markupDocBuilder, PathOperation operation) {
        ArrayList<ObjectType> inlineDefinitions = new ArrayList<ObjectType>();
        this.parameterTableComponent.apply(markupDocBuilder, ParameterTableComponent.parameters(operation, inlineDefinitions, this.getSectionTitleLevel()));
        return inlineDefinitions;
    }

    private List<ObjectType> buildBodyParameterSection(MarkupDocBuilder markupDocBuilder, PathOperation operation) {
        ArrayList<ObjectType> inlineDefinitions = new ArrayList<ObjectType>();
        this.bodyParameterComponent.apply(markupDocBuilder, BodyParameterComponent.parameters(operation, inlineDefinitions));
        return inlineDefinitions;
    }

    private List<ObjectType> buildResponsesSection(MarkupDocBuilder markupDocBuilder, PathOperation operation) {
        ArrayList<ObjectType> inlineDefinitions = new ArrayList<ObjectType>();
        this.responseComponent.apply(markupDocBuilder, ResponseComponent.parameters(operation, this.getSectionTitleLevel(), inlineDefinitions));
        return inlineDefinitions;
    }

    private void buildSectionTitle(MarkupDocBuilder markupDocBuilder, String title) {
        if (this.config.getPathsGroupedBy() == GroupBy.AS_IS) {
            markupDocBuilder.sectionTitleLevel3(title);
        } else {
            markupDocBuilder.sectionTitleLevel4(title);
        }
    }

    private void addInlineDefinitionTitle(MarkupDocBuilder markupDocBuilder, String title, String anchor) {
        markupDocBuilder.anchor(anchor);
        markupDocBuilder.newLine();
        markupDocBuilder.boldTextLine(title);
    }

    private void inlineDefinitions(MarkupDocBuilder markupDocBuilder, List<ObjectType> definitions, String uniquePrefix) {
        if (CollectionUtils.isNotEmpty(definitions)) {
            for (ObjectType definition : definitions) {
                this.addInlineDefinitionTitle(markupDocBuilder, definition.getName(), definition.getUniqueName());
                ArrayList<ObjectType> localDefinitions = new ArrayList<ObjectType>();
                this.propertiesTableComponent.apply(markupDocBuilder, PropertiesTableComponent.parameters(definition.getProperties(), uniquePrefix, localDefinitions));
                for (ObjectType localDefinition : localDefinitions) {
                    this.inlineDefinitions(markupDocBuilder, Collections.singletonList(localDefinition), localDefinition.getUniqueName());
                }
            }
        }
    }

    private void buildConsumesSection(MarkupDocBuilder markupDocBuilder, PathOperation operation) {
        List consumes = operation.getOperation().getConsumes();
        if (CollectionUtils.isNotEmpty((Collection)consumes)) {
            this.consumesComponent.apply(markupDocBuilder, ConsumesComponent.parameters(consumes, this.getSectionTitleLevel()));
        }
    }

    private void buildProducesSection(MarkupDocBuilder markupDocBuilder, PathOperation operation) {
        List produces = operation.getOperation().getProduces();
        if (CollectionUtils.isNotEmpty((Collection)produces)) {
            this.producesComponent.apply(markupDocBuilder, ProducesComponent.parameters(produces, this.getSectionTitleLevel()));
        }
    }

    private void buildTagsSection(MarkupDocBuilder markupDocBuilder, PathOperation operation) {
        List tags;
        if (this.config.getPathsGroupedBy() == GroupBy.AS_IS && CollectionUtils.isNotEmpty((Collection)(tags = operation.getOperation().getTags()))) {
            this.buildSectionTitle(markupDocBuilder, this.labels.getLabel("tags"));
            if (this.config.getTagOrdering() != null) {
                tags.sort(this.config.getTagOrdering());
            }
            markupDocBuilder.unorderedList(tags);
        }
    }

    private void buildSecuritySchemeSection(MarkupDocBuilder markupDocBuilder, PathOperation operation) {
        if (this.config.isPathSecuritySectionEnabled()) {
            this.securitySchemeComponent.apply(markupDocBuilder, SecuritySchemeComponent.parameters(operation, this.getSectionTitleLevel()));
        }
    }

    private int getSectionTitleLevel() {
        if (this.config.getPathsGroupedBy() == GroupBy.AS_IS) {
            return 3;
        }
        return 4;
    }

    private void buildExamplesSection(MarkupDocBuilder markupDocBuilder, PathOperation operation, List<PageBreakLocations> locations) {
        Map<String, Object> generatedRequestExampleMap = ExamplesUtil.generateRequestExampleMap(this.config.isGeneratedExamplesEnabled(), operation, this.definitions, this.definitionDocumentResolver, markupDocBuilder);
        Map<String, Object> generatedResponseExampleMap = ExamplesUtil.generateResponseExampleMap(this.config.isGeneratedExamplesEnabled(), operation, this.definitions, this.definitionDocumentResolver, markupDocBuilder);
        boolean beforeExampleRequestBreak = locations.contains((Object)PageBreakLocations.BEFORE_OPERATION_EXAMPLE_REQUEST);
        boolean afterExampleRequestBreak = locations.contains((Object)PageBreakLocations.AFTER_OPERATION_EXAMPLE_REQUEST);
        boolean beforeExampleResponseBreak = locations.contains((Object)PageBreakLocations.BEFORE_OPERATION_EXAMPLE_RESPONSE);
        boolean afterExampleResponseBreak = locations.contains((Object)PageBreakLocations.AFTER_OPERATION_EXAMPLE_RESPONSE);
        this.exampleMap(markupDocBuilder, generatedRequestExampleMap, this.labels.getLabel("example_request"), this.labels.getLabel("request"), beforeExampleRequestBreak, afterExampleRequestBreak);
        this.exampleMap(markupDocBuilder, generatedResponseExampleMap, this.labels.getLabel("example_response"), this.labels.getLabel("response"), beforeExampleResponseBreak, afterExampleResponseBreak);
    }

    private void exampleMap(MarkupDocBuilder markupDocBuilder, Map<String, Object> exampleMap, String operationSectionTitle, String sectionTitle, boolean beforeBreak, boolean afterBreak) {
        if (exampleMap.size() > 0) {
            if (beforeBreak) {
                markupDocBuilder.pageBreak();
            }
            this.buildSectionTitle(markupDocBuilder, operationSectionTitle);
            block0: for (Map.Entry<String, Object> entry : exampleMap.entrySet()) {
                this.buildExampleTitle(markupDocBuilder, sectionTitle + " " + entry.getKey());
                if (NumberUtils.isNumber((String)entry.getKey())) {
                    JsonNode rootNode = this.parseExample(entry.getValue());
                    Iterator fieldsIterator = rootNode.fields();
                    if (!fieldsIterator.hasNext()) {
                        String example = this.stripExampleQuotes(Json.pretty((Object)entry.getValue()));
                        example = Json.pretty((Object)example);
                        markupDocBuilder.listingBlock(example, "json");
                    }
                    while (fieldsIterator.hasNext()) {
                        String example;
                        Map.Entry field = (Map.Entry)fieldsIterator.next();
                        if (((String)field.getKey()).equals("application/json")) {
                            example = Json.pretty(field.getValue());
                            example = this.stripExampleQuotes(StringEscapeUtils.unescapeJson((String)example));
                            markupDocBuilder.listingBlock(example, "json");
                            continue;
                        }
                        if (((String)field.getKey()).equals("application/xml")) {
                            example = this.stripExampleQuotes(((JsonNode)field.getValue()).toString());
                            example = StringEscapeUtils.unescapeJava((String)example);
                            markupDocBuilder.listingBlock(example, "xml");
                            continue;
                        }
                        example = Json.pretty((Object)entry.getValue());
                        markupDocBuilder.listingBlock(example, "json");
                        continue block0;
                    }
                    continue;
                }
                if (entry.getKey().equals("path")) {
                    markupDocBuilder.listingBlock(entry.getValue().toString());
                    continue;
                }
                markupDocBuilder.listingBlock(Json.pretty((Object)entry.getValue()), "json");
            }
            if (afterBreak) {
                markupDocBuilder.pageBreak();
            }
        }
    }

    private String stripExampleQuotes(String raw) {
        return raw.replaceAll("^\"+", "").replaceAll("\"+$", "");
    }

    private JsonNode parseExample(Object raw) throws RuntimeException {
        try {
            JsonFactory factory = new JsonFactory();
            ObjectMapper mapper = new ObjectMapper(factory);
            return mapper.readTree(Json.pretty((Object)raw));
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to read example", ex);
        }
    }

    private void buildExampleTitle(MarkupDocBuilder markupDocBuilder, String title) {
        if (this.config.getPathsGroupedBy() == GroupBy.AS_IS) {
            markupDocBuilder.sectionTitleLevel4(title);
        } else {
            markupDocBuilder.sectionTitleLevel5(title);
        }
    }

    private void applyPathsDocumentExtension(PathsDocumentExtension.Context context) {
        this.extensionRegistry.getPathsDocumentExtensions().forEach(extension -> extension.apply(context));
    }

    public static class Parameters {
        private final PathOperation operation;

        public Parameters(PathOperation operation) {
            this.operation = (PathOperation)Validate.notNull((Object)operation, (String)"PathOperation must not be null", (Object[])new Object[0]);
        }
    }
}

