/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.socket.buffer;

import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.smartboot.socket.buffer.AbstractBufferPage;
import org.smartboot.socket.buffer.BufferPage;
import org.smartboot.socket.buffer.ElasticBufferPage;
import org.smartboot.socket.buffer.StaticBufferPage;

public final class BufferPagePool {
    private static final ScheduledThreadPoolExecutor BUFFER_POOL_CLEAN = new ScheduledThreadPoolExecutor(1, r -> {
        Thread thread = new Thread(r, "BufferPoolClean");
        thread.setDaemon(true);
        return thread;
    });
    public static final BufferPagePool DEFAULT_BUFFER_PAGE_POOL = new BufferPagePool(0, 1, false);
    private final AtomicInteger cursor = new AtomicInteger(0);
    private AbstractBufferPage[] bufferPages;
    private boolean enabled = true;
    private final ScheduledFuture<?> future;

    public BufferPagePool(int pageNum, boolean direct) {
        this(0, pageNum, direct);
    }

    public BufferPagePool(int pageSize, int pageNum, boolean isDirect) {
        this.bufferPages = new AbstractBufferPage[pageNum];
        for (int i = 0; i < pageNum; ++i) {
            this.bufferPages[i] = pageSize == 0 ? new ElasticBufferPage(isDirect) : new StaticBufferPage(pageSize, isDirect);
        }
        this.future = pageNum > 0 ? BUFFER_POOL_CLEAN.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                if (BufferPagePool.this.enabled) {
                    for (AbstractBufferPage bufferPage : BufferPagePool.this.bufferPages) {
                        bufferPage.tryClean();
                    }
                } else {
                    if (BufferPagePool.this.bufferPages != null) {
                        for (AbstractBufferPage page : BufferPagePool.this.bufferPages) {
                            page.release();
                        }
                        BufferPagePool.access$102(BufferPagePool.this, null);
                    }
                    BufferPagePool.this.future.cancel(false);
                }
            }
        }, 500L, 1000L, TimeUnit.MILLISECONDS) : null;
    }

    public BufferPage allocateBufferPage() {
        if (this.enabled) {
            return this.bufferPages[(this.cursor.getAndIncrement() & Integer.MAX_VALUE) % this.bufferPages.length];
        }
        throw new IllegalStateException("buffer pool is disable");
    }

    public void release() {
        this.enabled = false;
    }

    static /* synthetic */ AbstractBufferPage[] access$102(BufferPagePool x0, AbstractBufferPage[] x1) {
        x0.bufferPages = x1;
        return x1;
    }
}

