/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.ratelimiter.configure;

import io.github.resilience4j.ratelimiter.RateLimiterConfig;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;

public class RateLimiterConfigurationProperties {
    private int rateLimiterAspectOrder = Integer.MAX_VALUE;
    private Map<String, LimiterProperties> limiters = new HashMap<String, LimiterProperties>();

    public static RateLimiterConfig createRateLimiterConfig(LimiterProperties limiterProperties) {
        if (limiterProperties == null) {
            return RateLimiterConfig.ofDefaults();
        }
        RateLimiterConfig.Builder rateLimiterConfigBuilder = RateLimiterConfig.custom();
        if (limiterProperties.getLimitForPeriod() != null) {
            rateLimiterConfigBuilder.limitForPeriod(limiterProperties.getLimitForPeriod().intValue());
        }
        if (limiterProperties.getLimitRefreshPeriodInMillis() != null) {
            rateLimiterConfigBuilder.limitRefreshPeriod(Duration.ofMillis(limiterProperties.getLimitRefreshPeriodInMillis().intValue()));
        }
        if (limiterProperties.getTimeoutInMillis() != null) {
            rateLimiterConfigBuilder.timeoutDuration(Duration.ofMillis(limiterProperties.getTimeoutInMillis().intValue()));
        }
        return rateLimiterConfigBuilder.build();
    }

    private LimiterProperties getLimiterProperties(String limiter) {
        return this.limiters.get(limiter);
    }

    public RateLimiterConfig createRateLimiterConfig(String limiter) {
        return RateLimiterConfigurationProperties.createRateLimiterConfig(this.getLimiterProperties(limiter));
    }

    public int getRateLimiterAspectOrder() {
        return this.rateLimiterAspectOrder;
    }

    public void setRateLimiterAspectOrder(int rateLimiterAspectOrder) {
        this.rateLimiterAspectOrder = rateLimiterAspectOrder;
    }

    public Map<String, LimiterProperties> getLimiters() {
        return this.limiters;
    }

    public static class LimiterProperties {
        private Integer limitForPeriod;
        private Integer limitRefreshPeriodInMillis;
        private Integer timeoutInMillis;
        private Boolean subscribeForEvents = false;
        private Boolean registerHealthIndicator = false;
        private Integer eventConsumerBufferSize = 100;

        public Integer getLimitForPeriod() {
            return this.limitForPeriod;
        }

        public void setLimitForPeriod(Integer limitForPeriod) {
            this.limitForPeriod = limitForPeriod;
        }

        public Integer getLimitRefreshPeriodInMillis() {
            return this.limitRefreshPeriodInMillis;
        }

        public void setLimitRefreshPeriodInMillis(Integer limitRefreshPeriodInMillis) {
            this.limitRefreshPeriodInMillis = limitRefreshPeriodInMillis;
        }

        public Integer getTimeoutInMillis() {
            return this.timeoutInMillis;
        }

        public void setTimeoutInMillis(Integer timeoutInMillis) {
            this.timeoutInMillis = timeoutInMillis;
        }

        public Boolean getSubscribeForEvents() {
            return this.subscribeForEvents;
        }

        public void setSubscribeForEvents(Boolean subscribeForEvents) {
            this.subscribeForEvents = subscribeForEvents;
        }

        public Integer getEventConsumerBufferSize() {
            return this.eventConsumerBufferSize;
        }

        public void setEventConsumerBufferSize(Integer eventConsumerBufferSize) {
            this.eventConsumerBufferSize = eventConsumerBufferSize;
        }

        public Boolean getRegisterHealthIndicator() {
            return this.registerHealthIndicator;
        }

        public void setRegisterHealthIndicator(Boolean registerHealthIndicator) {
            this.registerHealthIndicator = registerHealthIndicator;
        }
    }
}

