/*
 * Decompiled with CFR 0.152.
 */
package atlantafx.base.layout;

import java.util.Comparator;
import java.util.Objects;
import java.util.function.Consumer;
import javafx.animation.Animation;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.ParallelTransition;
import javafx.animation.Timeline;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.WritableValue;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.layout.AnchorPane;
import javafx.scene.shape.Rectangle;
import javafx.util.Duration;
import org.jetbrains.annotations.Nullable;

public class DeckPane
extends AnchorPane {
    protected static final Comparator<Node> Z_COMPARATOR = Comparator.comparingDouble(Node::getViewOrder);
    protected static final int Z_ANIMATED_IN = -20;
    protected static final int Z_ANIMATED_OUT = -15;
    protected static final int Z_DECK_TOP = -10;
    protected static final int Z_DEFAULT = 0;
    protected final ObjectProperty<Duration> animationDuration = new SimpleObjectProperty((Object)this, "animationDuration", (Object)Duration.seconds((double)1.0));
    protected final ReadOnlyBooleanWrapper animationActive = new ReadOnlyBooleanWrapper((Object)this, "animationActive");
    protected final ObjectProperty<Consumer<Node>> beforeShowCallback = new SimpleObjectProperty((Object)this, "beforeShowCallback");
    protected final ObjectProperty<Consumer<Node>> afterHideCallback = new SimpleObjectProperty((Object)this, "afterHideCallback");

    public DeckPane() {
        this.getChildren().addListener(change -> {
            while (change.next()) {
                if (!change.wasRemoved()) continue;
                change.getRemoved().forEach(node -> node.setViewOrder(0.0));
            }
        });
    }

    public DeckPane(Node ... children) {
        this();
        this.getChildren().addAll((Object[])children);
    }

    @Nullable
    public Node getTopNode() {
        int size = this.getChildren().size();
        if (size == 0) {
            return null;
        }
        return this.getChildren().stream().reduce((o1, o2) -> Z_COMPARATOR.compare((Node)o1, (Node)o2) >= 0 ? o2 : o1).orElse((Node)this.getChildren().get(size - 1));
    }

    public void setTopNode(Node target) {
        if (!this.getChildren().contains((Object)target)) {
            return;
        }
        Node topNode = this.getTopNode();
        if (topNode == null || topNode == target) {
            return;
        }
        this.setViewOrder(topNode, 0);
        this.setViewOrder(target, -10);
    }

    public void resetTopNode() {
        Node topNode = this.getTopNode();
        if (topNode != null) {
            this.setViewOrder(topNode, 0);
        }
    }

    public void addChildren(Insets offset, Node ... nodes) {
        for (Node node : nodes) {
            AnchorPane.setTopAnchor((Node)node, (Double)offset.getTop());
            AnchorPane.setRightAnchor((Node)node, (Double)offset.getRight());
            AnchorPane.setBottomAnchor((Node)node, (Double)offset.getBottom());
            AnchorPane.setLeftAnchor((Node)node, (Double)offset.getLeft());
        }
        this.getChildren().addAll((Object[])nodes);
    }

    public void swipeUp(Node target) {
        Node topNode = this.getTopNode();
        if (!this.prepareAndCheck(topNode, target)) {
            return;
        }
        Objects.requireNonNull(topNode);
        this.setViewOrder(topNode, -15);
        this.setViewOrder(target, -20);
        ParallelTransition transition = new ParallelTransition(new Animation[]{this.moveYUpFromTopBorderToOffCanvas(topNode), this.moveYUpFromBottomBorderToTopBorder(target)});
        transition.setOnFinished(e -> this.onTransitionFinished(topNode, target));
        this.setAnimationActive(true);
        transition.play();
    }

    public void swipeDown(Node target) {
        Node topNode = this.getTopNode();
        if (!this.prepareAndCheck(topNode, target)) {
            return;
        }
        Objects.requireNonNull(topNode);
        this.setViewOrder(topNode, -15);
        this.setViewOrder(target, -20);
        ParallelTransition transition = new ParallelTransition(new Animation[]{this.moveYDownFromTopBorderToBottomBorder(topNode), this.moveYDownFromOffCanvasToTopBorder(target)});
        transition.setOnFinished(e -> this.onTransitionFinished(topNode, target));
        this.setAnimationActive(true);
        transition.play();
    }

    public void swipeLeft(Node target) {
        Node topNode = this.getTopNode();
        if (!this.prepareAndCheck(topNode, target)) {
            return;
        }
        Objects.requireNonNull(topNode);
        this.setViewOrder(topNode, -15);
        this.setViewOrder(target, -20);
        ParallelTransition transition = new ParallelTransition(new Animation[]{this.moveXLeftFromLeftBorderToOffCanvas(topNode), this.moveXLeftFromRightBorderToLeftBorder(target)});
        transition.setOnFinished(e -> this.onTransitionFinished(topNode, target));
        this.setAnimationActive(true);
        transition.play();
    }

    public void swipeRight(Node target) {
        Node topNode = this.getTopNode();
        if (!this.prepareAndCheck(topNode, target)) {
            return;
        }
        Objects.requireNonNull(topNode);
        this.setViewOrder(topNode, -15);
        this.setViewOrder(target, -20);
        ParallelTransition transition = new ParallelTransition(new Animation[]{this.moveXRightFromLeftBorderToRightBorder(topNode), this.moveXRightFromOffCanvasToLeftBorder(target)});
        transition.setOnFinished(e -> this.onTransitionFinished(topNode, target));
        this.setAnimationActive(true);
        transition.play();
    }

    public void slideUp(Node target) {
        Node topNode = this.getTopNode();
        if (!this.prepareAndCheck(topNode, target)) {
            return;
        }
        Objects.requireNonNull(topNode);
        this.setViewOrder(topNode, -15);
        this.setViewOrder(target, -20);
        Timeline transition = this.moveYUpFromBottomBorderToTopBorder(target);
        transition.setOnFinished(e -> this.onTransitionFinished(topNode, target));
        this.setAnimationActive(true);
        transition.play();
    }

    public void slideDown(Node target) {
        Node topNode = this.getTopNode();
        if (!this.prepareAndCheck(topNode, target)) {
            return;
        }
        Objects.requireNonNull(topNode);
        this.setViewOrder(topNode, -15);
        this.setViewOrder(target, -20);
        Timeline transition = this.moveYDownFromOffCanvasToTopBorder(target);
        transition.setOnFinished(e -> this.onTransitionFinished(topNode, target));
        this.setAnimationActive(true);
        transition.play();
    }

    public void slideLeft(Node target) {
        Node topNode = this.getTopNode();
        if (!this.prepareAndCheck(topNode, target)) {
            return;
        }
        Objects.requireNonNull(topNode);
        this.setViewOrder(topNode, -15);
        this.setViewOrder(target, -20);
        Timeline transition = this.moveXLeftFromRightBorderToLeftBorder(target);
        transition.setOnFinished(e -> this.onTransitionFinished(topNode, target));
        this.setAnimationActive(true);
        transition.play();
    }

    public void slideRight(Node target) {
        Node topNode = this.getTopNode();
        if (!this.prepareAndCheck(topNode, target)) {
            return;
        }
        Objects.requireNonNull(topNode);
        this.setViewOrder(topNode, -15);
        this.setViewOrder(target, -20);
        Timeline transition = this.moveXRightFromOffCanvasToLeftBorder(target);
        transition.setOnFinished(e -> this.onTransitionFinished(topNode, target));
        this.setAnimationActive(true);
        transition.play();
    }

    public ObjectProperty<Duration> animationDurationProperty() {
        return this.animationDuration;
    }

    public Duration getAnimationDuration() {
        return (Duration)this.animationDuration.get();
    }

    public void setAnimationDuration(@Nullable Duration animationDuration) {
        this.animationDuration.set((Object)Objects.requireNonNullElse(animationDuration, Duration.ZERO));
    }

    public ReadOnlyBooleanProperty animationActiveProperty() {
        return this.animationActive.getReadOnlyProperty();
    }

    public boolean isAnimationActive() {
        return this.animationActive.get();
    }

    protected void setAnimationActive(boolean animationActive) {
        this.animationActive.set(animationActive);
    }

    public ObjectProperty<Consumer<Node>> beforeShowCallbackProperty() {
        return this.beforeShowCallback;
    }

    @Nullable
    public Consumer<Node> getBeforeShowCallback() {
        return (Consumer)this.beforeShowCallback.get();
    }

    public void setBeforeShowCallback(@Nullable Consumer<Node> callback) {
        this.beforeShowCallback.set(callback);
    }

    protected void runBeforeShowCallback(Node node) {
        if (this.getBeforeShowCallback() != null) {
            this.getBeforeShowCallback().accept(node);
        }
    }

    public ObjectProperty<Consumer<Node>> afterHideCallbackProperty() {
        return this.afterHideCallback;
    }

    @Nullable
    public Consumer<Node> getAfterHideCallback() {
        return (Consumer)this.afterHideCallback.get();
    }

    public void setAfterHideCallback(@Nullable Consumer<Node> callback) {
        this.afterHideCallback.set(callback);
    }

    protected void runAfterHideCallback(Node node) {
        if (this.getAfterHideCallback() != null) {
            this.getAfterHideCallback().accept(node);
        }
    }

    protected boolean prepareAndCheck(@Nullable Node topNode, @Nullable Node target) {
        if (topNode == null || target == null || target == topNode || this.isAnimationActive()) {
            return false;
        }
        if (!this.getChildren().contains((Object)target)) {
            this.getChildren().add((Object)target);
        }
        this.runBeforeShowCallback(target);
        return true;
    }

    protected void onTransitionFinished(Node topNode, Node target) {
        this.resetNode(topNode);
        this.resetNode(target);
        this.setViewOrder(topNode, 0);
        this.setViewOrder(target, -10);
        this.runAfterHideCallback(topNode);
        this.setAnimationActive(false);
    }

    protected Timeline moveYUpFromTopBorderToOffCanvas(Node node) {
        Rectangle clip = new Rectangle();
        clip.setWidth(this.getWidth());
        node.setClip((Node)clip);
        clip.setHeight(this.getHeight());
        clip.translateYProperty().set(0.0);
        node.translateYProperty().set(0.0);
        Timeline timeline = new Timeline();
        timeline.getKeyFrames().add((Object)new KeyFrame((Duration)this.animationDuration.getValue(), new KeyValue[]{new KeyValue((WritableValue)clip.heightProperty(), (Object)0), new KeyValue((WritableValue)clip.translateYProperty(), (Object)this.getHeight()), new KeyValue((WritableValue)node.translateYProperty(), (Object)(-this.getHeight()))}));
        return timeline;
    }

    protected Timeline moveYUpFromBottomBorderToTopBorder(Node node) {
        Rectangle clip = new Rectangle();
        clip.setWidth(this.getWidth());
        node.setClip((Node)clip);
        clip.setHeight(0.0);
        node.translateYProperty().set(this.getHeight());
        Timeline timeline = new Timeline();
        timeline.getKeyFrames().add((Object)new KeyFrame((Duration)this.animationDuration.getValue(), new KeyValue[]{new KeyValue((WritableValue)clip.heightProperty(), (Object)this.getHeight()), new KeyValue((WritableValue)node.translateYProperty(), (Object)0)}));
        return timeline;
    }

    protected Timeline moveYDownFromTopBorderToBottomBorder(Node node) {
        Rectangle clip = new Rectangle();
        clip.setWidth(this.getWidth());
        node.setClip((Node)clip);
        clip.setHeight(this.getHeight());
        node.translateYProperty().set(0.0);
        Timeline timeline = new Timeline();
        timeline.getKeyFrames().add((Object)new KeyFrame((Duration)this.animationDuration.getValue(), new KeyValue[]{new KeyValue((WritableValue)clip.heightProperty(), (Object)0), new KeyValue((WritableValue)node.translateYProperty(), (Object)this.getHeight())}));
        return timeline;
    }

    protected Timeline moveYDownFromOffCanvasToTopBorder(Node node) {
        Rectangle clip = new Rectangle();
        clip.setWidth(this.getWidth());
        node.setClip((Node)clip);
        clip.setHeight(0.0);
        clip.translateYProperty().set(this.getHeight());
        node.translateYProperty().set(-this.getHeight());
        Timeline timeline = new Timeline();
        timeline.getKeyFrames().add((Object)new KeyFrame((Duration)this.animationDuration.getValue(), new KeyValue[]{new KeyValue((WritableValue)clip.heightProperty(), (Object)this.getHeight()), new KeyValue((WritableValue)clip.translateYProperty(), (Object)0), new KeyValue((WritableValue)node.translateYProperty(), (Object)0)}));
        return timeline;
    }

    protected Timeline moveXLeftFromLeftBorderToOffCanvas(Node node) {
        Rectangle clip = new Rectangle();
        clip.setHeight(this.getHeight());
        node.setClip((Node)clip);
        clip.setWidth(this.getWidth());
        clip.translateXProperty().set(0.0);
        node.translateXProperty().set(0.0);
        Timeline timeline = new Timeline();
        timeline.getKeyFrames().add((Object)new KeyFrame((Duration)this.animationDuration.getValue(), new KeyValue[]{new KeyValue((WritableValue)clip.widthProperty(), (Object)0), new KeyValue((WritableValue)clip.translateXProperty(), (Object)this.getWidth()), new KeyValue((WritableValue)node.translateXProperty(), (Object)(-this.getWidth()))}));
        return timeline;
    }

    protected Timeline moveXLeftFromRightBorderToLeftBorder(Node node) {
        Rectangle clip = new Rectangle();
        clip.setHeight(this.getHeight());
        node.setClip((Node)clip);
        clip.setWidth(0.0);
        node.translateXProperty().set(this.getWidth());
        Timeline timeline = new Timeline();
        timeline.getKeyFrames().add((Object)new KeyFrame((Duration)this.animationDuration.getValue(), new KeyValue[]{new KeyValue((WritableValue)clip.widthProperty(), (Object)this.getWidth()), new KeyValue((WritableValue)node.translateXProperty(), (Object)0)}));
        return timeline;
    }

    protected Timeline moveXRightFromLeftBorderToRightBorder(Node node) {
        Rectangle clip = new Rectangle();
        clip.setHeight(this.getHeight());
        node.setClip((Node)clip);
        clip.setWidth(this.getWidth());
        node.translateXProperty().set(0.0);
        Timeline timeline = new Timeline();
        timeline.getKeyFrames().add((Object)new KeyFrame((Duration)this.animationDuration.getValue(), new KeyValue[]{new KeyValue((WritableValue)clip.widthProperty(), (Object)0), new KeyValue((WritableValue)node.translateXProperty(), (Object)this.getWidth())}));
        return timeline;
    }

    protected Timeline moveXRightFromOffCanvasToLeftBorder(Node node) {
        Rectangle clip = new Rectangle();
        clip.setHeight(this.getHeight());
        node.setClip((Node)clip);
        clip.setWidth(0.0);
        clip.translateXProperty().set(this.getWidth());
        node.translateXProperty().set(-this.getWidth());
        Timeline timeline = new Timeline();
        timeline.getKeyFrames().add((Object)new KeyFrame((Duration)this.animationDuration.getValue(), new KeyValue[]{new KeyValue((WritableValue)clip.widthProperty(), (Object)this.getWidth()), new KeyValue((WritableValue)clip.translateXProperty(), (Object)0), new KeyValue((WritableValue)node.translateXProperty(), (Object)0)}));
        return timeline;
    }

    protected void resetNode(Node node) {
        node.setClip(null);
        node.setTranslateX(0.0);
        node.setTranslateY(0.0);
    }

    protected void setViewOrder(Node node, int viewOrder) {
        if (viewOrder != 0 && viewOrder != -10 && viewOrder != -20 && viewOrder != -15) {
            throw new IllegalArgumentException("Unknown view order value: " + viewOrder);
        }
        node.setViewOrder((double)viewOrder);
    }
}

