/*
 * Decompiled with CFR 0.152.
 */
package io.github.imfangs.dify.client.enums;

import com.fasterxml.jackson.annotation.JsonValue;
import lombok.Generated;

public enum FileType {
    DOCUMENT("document", new String[]{"TXT", "MD", "MARKDOWN", "PDF", "HTML", "XLSX", "XLS", "DOCX", "CSV", "EML", "MSG", "PPTX", "PPT", "XML", "EPUB"}),
    IMAGE("image", new String[]{"JPG", "JPEG", "PNG", "GIF", "WEBP", "SVG"}),
    AUDIO("audio", new String[]{"MP3", "M4A", "WAV", "WEBM", "AMR"}),
    VIDEO("video", new String[]{"MP4", "MOV", "MPEG", "MPGA"}),
    CUSTOM("custom");

    private final String value;
    private String[] fileExtensions;

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public static FileType getByFileExtension(String fileExtension) {
        if (fileExtension == null) {
            return CUSTOM;
        }
        if (fileExtension.contains(".")) {
            fileExtension = fileExtension.substring(fileExtension.lastIndexOf(".") + 1);
        }
        for (FileType fileType : FileType.values()) {
            if (fileType.getFileExtensions() == null) continue;
            for (String extension : fileType.getFileExtensions()) {
                if (!extension.equalsIgnoreCase(fileExtension)) continue;
                return fileType;
            }
        }
        return CUSTOM;
    }

    @Generated
    private FileType(String value, String[] fileExtensions) {
        this.value = value;
        this.fileExtensions = fileExtensions;
    }

    @Generated
    private FileType(String value) {
        this.value = value;
    }

    @Generated
    public String[] getFileExtensions() {
        return this.fileExtensions;
    }
}

