/*
 * Decompiled with CFR 0.152.
 */
package io.github.imfangs.dify.client.impl;

import io.github.imfangs.dify.client.exception.DifyApiException;
import io.github.imfangs.dify.client.util.HttpClientUtils;
import io.github.imfangs.dify.client.util.JsonUtils;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDifyClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractDifyClient.class);
    protected static final MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");
    protected static final MediaType OCTET_STREAM = MediaType.parse((String)"application/octet-stream");
    protected static final MediaType AUDIO = MediaType.parse((String)"audio/*");
    protected final OkHttpClient httpClient;
    protected final String baseUrl;
    protected final String apiKey;

    public AbstractDifyClient(String baseUrl, String apiKey) {
        this(baseUrl, apiKey, HttpClientUtils.createDefaultClient());
    }

    public AbstractDifyClient(String baseUrl, String apiKey, OkHttpClient httpClient) {
        this.baseUrl = baseUrl;
        this.apiKey = apiKey;
        this.httpClient = httpClient;
    }

    protected <T> T executeGet(String path, Class<T> responseClass) throws IOException, DifyApiException {
        Request request = this.createGetRequest(path);
        return this.executeRequest(request, responseClass);
    }

    protected <T> T executePost(String path, Object body, Class<T> responseClass) throws IOException, DifyApiException {
        RequestBody requestBody = this.createJsonRequestBody(body);
        Request request = this.createPostRequest(path, requestBody);
        return this.executeRequest(request, responseClass);
    }

    protected <T> T executePatch(String path, Object body, Class<T> responseClass) throws IOException, DifyApiException {
        RequestBody requestBody = this.createJsonRequestBody(body);
        Request request = this.createPatchRequest(path, requestBody);
        return this.executeRequest(request, responseClass);
    }

    protected <T> T executeDelete(String path, Object body, Class<T> responseClass) throws IOException, DifyApiException {
        RequestBody requestBody = this.createJsonRequestBody(body);
        Request request = this.createDeleteRequest(path, requestBody);
        return this.executeRequest(request, responseClass);
    }

    protected <T> T executeRequest(Request request, Class<T> responseClass) throws IOException, DifyApiException {
        try (Response response = this.httpClient.newCall(request).execute();){
            if (!response.isSuccessful()) {
                String errorBody = response.body() != null ? response.body().string() : "";
                throw this.createApiException(response.code(), errorBody);
            }
            String responseBody = Objects.requireNonNull(response.body()).string();
            T t = JsonUtils.fromJson(responseBody, responseClass);
            return t;
        }
    }

    protected <T> T handleResponse(Response response, Class<T> clazz) throws IOException, DifyApiException {
        if (!response.isSuccessful()) {
            String errorBody = response.body() != null ? response.body().string() : "";
            log.error("API\u8bf7\u6c42\u5931\u8d25: {}, \u72b6\u6001\u7801: {}, \u9519\u8bef\u4fe1\u606f: {}", new Object[]{response.request().url(), response.code(), errorBody});
            throw new DifyApiException(response.code(), "api_error", errorBody);
        }
        if (response.body() == null) {
            return null;
        }
        String responseBody = response.body().string();
        return JsonUtils.fromJson(responseBody, clazz);
    }

    protected byte[] executeRequestForBytes(Request request) throws IOException, DifyApiException {
        try (Response response = this.httpClient.newCall(request).execute();){
            if (!response.isSuccessful()) {
                String errorBody = response.body() != null ? response.body().string() : "";
                throw this.createApiException(response.code(), errorBody);
            }
            byte[] byArray = Objects.requireNonNull(response.body()).bytes();
            return byArray;
        }
    }

    protected Request createGetRequest(String path) {
        return new Request.Builder().url(this.baseUrl + path).get().header("Authorization", "Bearer " + this.apiKey).build();
    }

    protected Request createPostRequest(String path, RequestBody body) {
        Request.Builder request = new Request.Builder().url(this.baseUrl + path).header("Authorization", "Bearer " + this.apiKey);
        if (body != null) {
            request.post(body).header("Content-Type", "application/json");
        } else {
            request.post(RequestBody.create((byte[])"".getBytes()));
        }
        return request.build();
    }

    protected Request createPatchRequest(String path, RequestBody body) {
        return new Request.Builder().url(this.baseUrl + path).patch(body).header("Authorization", "Bearer " + this.apiKey).header("Content-Type", "application/json").build();
    }

    protected Request createDeleteRequest(String path, RequestBody body) {
        Request.Builder builder = new Request.Builder().url(this.baseUrl + path).delete().header("Authorization", "Bearer " + this.apiKey);
        if (body != null) {
            builder.delete(body).header("Content-Type", "application/json");
        }
        return builder.build();
    }

    protected RequestBody createJsonRequestBody(Object body) {
        if (body == null) {
            return null;
        }
        return RequestBody.create((MediaType)JSON, (String)JsonUtils.toJson(body));
    }

    protected DifyApiException createApiException(int code, String message) {
        String errorCode = "unknown_error";
        String errorMessage = message;
        try {
            Map errorJson;
            if (message != null && !message.isEmpty() && JsonUtils.isValidJson(message) && (errorJson = JsonUtils.fromJson(message, Map.class)) != null) {
                if (errorJson.containsKey("error_code")) {
                    errorCode = (String)errorJson.get("error_code");
                } else if (errorJson.containsKey("code")) {
                    errorCode = String.valueOf(errorJson.get("code"));
                }
                if (errorJson.containsKey("error_message")) {
                    errorMessage = (String)errorJson.get("error_message");
                } else if (errorJson.containsKey("message")) {
                    errorMessage = (String)errorJson.get("message");
                }
                if (errorJson.containsKey("params")) {
                    errorMessage = errorMessage + " \u3010" + errorJson.get("params") + "\u3011";
                }
            }
        }
        catch (Exception e) {
            log.warn("\u89e3\u6790\u9519\u8bef\u54cd\u5e94\u4f53\u5931\u8d25: {}", (Object)message, (Object)e);
        }
        return new DifyApiException(code, errorCode, errorMessage);
    }

    protected String buildUrlWithParams(String path, Map<String, Object> params) {
        if (params == null || params.isEmpty()) {
            return path;
        }
        StringBuilder urlBuilder = new StringBuilder(path);
        boolean isFirstParam = true;
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            if (entry.getValue() == null) continue;
            urlBuilder.append(isFirstParam ? "?" : "&").append(entry.getKey()).append("=").append(entry.getValue());
            isFirstParam = false;
        }
        return urlBuilder.toString();
    }

    protected void addIfNotEmpty(Map<String, Object> params, String key, String value) {
        if (value != null && !value.isEmpty()) {
            params.put(key, value);
        }
    }

    protected void addIfNotNull(Map<String, Object> params, String key, Object value) {
        if (value != null) {
            params.put(key, value);
        }
    }
}

