/*
 * Decompiled with CFR 0.152.
 */
package org.ddr.poi.html.util;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.xwpf.usermodel.BodyType;
import org.apache.poi.xwpf.usermodel.XWPFAbstractNum;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFNumbering;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.ddr.poi.html.util.ListStyle;
import org.ddr.poi.html.util.ListStyleType;
import org.ddr.poi.html.util.RenderUtils;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTAbstractNum;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTFonts;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTInd;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTLvl;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTPPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STHint;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STJc;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STLevelSuffix;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STMultiLevelType;

public class NumberingContext {
    private static final int INDENT = 360;
    private static final int HANGING = 360;
    private final XWPFDocument document;
    private int indent = 360;
    private int hanging = 360;
    private STLevelSuffix.Enum spacing;
    private int nextAbstractNumberId;
    private int nextNumberingLevel;
    private List<ListStyle> listStyles;
    private final TreeMap<String, BigInteger> numberIdMap = new TreeMap(Collections.reverseOrder());
    private List<XWPFParagraph> numberingParagraphs;

    public NumberingContext(XWPFDocument document) {
        this.document = document;
    }

    public void startLevel(ListStyle listStyle) {
        int level;
        if ((level = this.nextNumberingLevel++) == 0) {
            this.numberingParagraphs = new ArrayList<XWPFParagraph>(8);
            this.listStyles = new ArrayList<ListStyle>(4);
        }
        this.listStyles.add(listStyle);
    }

    public void endLevel() {
        XWPFParagraph paragraph;
        --this.nextNumberingLevel;
        String key = this.getFormatKey();
        BigInteger numberId = this.getNumberId(key);
        BigInteger currentLevel = BigInteger.valueOf(this.nextNumberingLevel);
        for (int i = this.numberingParagraphs.size() - 1; i >= 0 && currentLevel.equals((paragraph = this.numberingParagraphs.get(i)).getNumIlvl()); --i) {
            paragraph.setNumID(numberId);
            this.numberingParagraphs.remove(i);
        }
        if (!this.listStyles.isEmpty()) {
            this.listStyles.remove(this.listStyles.size() - 1);
        }
        if (this.nextNumberingLevel == 0) {
            this.numberingParagraphs = null;
            this.listStyles = null;
            this.numberIdMap.clear();
        }
    }

    public void add(XWPFParagraph paragraph) {
        CTPPr pPr;
        if (this.numberingParagraphs == null) {
            return;
        }
        paragraph.setNumILvl(BigInteger.valueOf(this.nextNumberingLevel - 1));
        if (paragraph.getPartType() == BodyType.TABLECELL && !(pPr = RenderUtils.getPPr(paragraph.getCTP())).isSetInd()) {
            RenderUtils.getInd(pPr).setFirstLine(BigInteger.ZERO);
        }
        this.numberingParagraphs.add(paragraph);
    }

    private BigInteger getNumberId(String key) {
        BigInteger numberId;
        block6: {
            BigInteger abstractNumberId;
            XWPFAbstractNum abstractNum;
            numberId = null;
            for (Map.Entry<String, BigInteger> entry : this.numberIdMap.entrySet()) {
                if (!entry.getKey().startsWith(key)) continue;
                numberId = entry.getValue();
                break;
            }
            if (numberId != null) break block6;
            XWPFNumbering numbering = this.document.createNumbering();
            while ((abstractNum = numbering.getAbstractNum(abstractNumberId = BigInteger.valueOf(this.nextAbstractNumberId++))) != null) {
            }
            CTAbstractNum ctAbstractNum = CTAbstractNum.Factory.newInstance();
            ctAbstractNum.setAbstractNumId(abstractNumberId);
            ctAbstractNum.addNewMultiLevelType().setVal(STMultiLevelType.HYBRID_MULTILEVEL);
            for (int i = 0; i < this.listStyles.size(); ++i) {
                ListStyle listStyle = this.listStyles.get(i);
                ListStyleType listStyleType = listStyle.getNumberFormat();
                CTLvl cTLvl = ctAbstractNum.addNewLvl();
                CTInd ind = cTLvl.addNewPPr().addNewInd();
                long left = this.indent * i + listStyle.getLeft();
                long right = listStyle.getRight();
                for (int j = 0; j < i; ++j) {
                    ListStyle previous = this.listStyles.get(j);
                    left += (long)previous.getLeft();
                    right += (long)previous.getRight();
                }
                ind.setLeft(BigInteger.valueOf(left));
                ind.setRight(BigInteger.valueOf(right));
                if (listStyle.isHanging()) {
                    ind.setHanging(BigInteger.valueOf(this.hanging));
                }
                cTLvl.addNewNumFmt().setVal(listStyleType.getFormat());
                cTLvl.addNewLvlText().setVal(this.getLevelText(listStyleType, i));
                cTLvl.addNewStart().setVal(BigInteger.ONE);
                cTLvl.setIlvl(BigInteger.valueOf(i));
                cTLvl.addNewLvlJc().setVal(STJc.LEFT);
                if (StringUtils.isNotBlank((CharSequence)listStyleType.getFont())) {
                    CTFonts ctFonts = cTLvl.addNewRPr().addNewRFonts();
                    ctFonts.setAscii(listStyleType.getFont());
                    ctFonts.setHAnsi(listStyleType.getFont());
                    ctFonts.setHint(STHint.DEFAULT);
                }
                if (this.spacing == null) continue;
                cTLvl.addNewSuff().setVal(this.spacing);
            }
            numbering.addAbstractNum(new XWPFAbstractNum(ctAbstractNum, numbering));
            numberId = numbering.addNum(abstractNumberId);
            this.numberIdMap.put(key, numberId);
        }
        return numberId;
    }

    private String getLevelText(ListStyleType listStyleType, int i) {
        if (listStyleType.getText() == null) {
            return "";
        }
        if (listStyleType.getText().length() == 0) {
            return this.getOrderedLevelText(i);
        }
        return listStyleType.getText();
    }

    private String getOrderedLevelText(int i) {
        return "%" + (i + 1) + ".";
    }

    private String getFormatKey() {
        StringBuilder sb = new StringBuilder();
        for (ListStyle listStyle : this.listStyles) {
            sb.append(listStyle.getNumberFormat().getName()).append(" ");
        }
        return sb.toString();
    }

    public void setIndent(int indent) {
        if (indent >= 0) {
            this.indent = indent;
        }
    }

    public void setHanging(int hanging) {
        if (hanging >= 0) {
            this.hanging = hanging;
        }
    }

    public void setSpacing(STLevelSuffix.Enum spacing) {
        this.spacing = spacing;
    }

    public boolean contains(XWPFParagraph paragraph) {
        return this.numberingParagraphs != null && this.numberingParagraphs.contains(paragraph);
    }
}

