/*
 * Decompiled with CFR 0.152.
 */
package org.ddr.poi.html.tag;

import java.math.BigInteger;
import org.ddr.poi.html.ElementRenderer;
import org.ddr.poi.html.HtmlConstants;
import org.ddr.poi.html.HtmlRenderContext;
import org.ddr.poi.html.util.CSSStyleUtils;
import org.ddr.poi.html.util.RenderUtils;
import org.jsoup.nodes.Element;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTDecimalNumber;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTP;

public class HeaderRenderer
implements ElementRenderer {
    private static final String[] TAGS = new String[]{"h1", "h2", "h3", "h4", "h5", "h6"};
    private static final String[] FONT_SIZES = new String[]{"24pt", "18pt", "14pt", "12pt", "10pt", "7.5pt"};

    @Override
    public boolean renderStart(Element element, HtmlRenderContext context) {
        int index = Integer.parseInt(element.normalName().substring(1)) - 1;
        String fontSizeStyle = HtmlConstants.inlineStyle("font-size", FONT_SIZES[index]);
        context.pushInlineStyle(CSSStyleUtils.parse(HtmlConstants.DEFINED_BOLD + fontSizeStyle), element.isBlock());
        CTP ctp = context.getClosestParagraph().getCTP();
        CTDecimalNumber ctDecimalNumber = CTDecimalNumber.Factory.newInstance();
        ctDecimalNumber.setVal(BigInteger.valueOf(index));
        RenderUtils.getPPr(ctp).setOutlineLvl(ctDecimalNumber);
        return true;
    }

    @Override
    public void renderEnd(Element element, HtmlRenderContext context) {
        context.popInlineStyle();
    }

    @Override
    public String[] supportedTags() {
        return TAGS;
    }

    @Override
    public boolean renderAsBlock() {
        return true;
    }
}

