/*
 * Decompiled with CFR 0.152.
 */
package org.ddr.image.heif;

import com.twelvemonkeys.imageio.spi.ImageReaderSpiBase;
import com.twelvemonkeys.imageio.spi.ReaderWriterProviderInfo;
import java.io.IOException;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import javax.imageio.ImageReader;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import org.ddr.image.heif.HeifImageReader;
import org.ddr.image.heif.HeifProviderInfo;

public final class HeifImageReaderSpi
extends ImageReaderSpiBase {
    private static final Set<String> TYPES = new HashSet<String>(8);

    public HeifImageReaderSpi() {
        super((ReaderWriterProviderInfo)new HeifProviderInfo());
    }

    public boolean canDecodeInput(Object source) throws IOException {
        return source instanceof ImageInputStream && this.canDecode((ImageInputStream)source);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean canDecode(ImageInputStream input) throws IOException {
        try {
            byte[] bytes;
            int length;
            input.mark();
            for (int i = 0; i < 4; ++i) {
                input.read();
            }
            if (input.read() == 102 && input.read() == 116 && input.read() == 121 && input.read() == 112 && (length = input.read(bytes = new byte[4])) == 4) {
                String s = new String(bytes);
                boolean bl = TYPES.contains(s);
                return bl;
            }
        }
        catch (Exception exception) {
        }
        finally {
            input.reset();
        }
        return false;
    }

    public ImageReader createReaderInstance(Object extension) throws IOException {
        return new HeifImageReader((ImageReaderSpi)((Object)this));
    }

    public String getDescription(Locale locale) {
        return "High Efficiency Image File (HEIF) format image reader";
    }

    static {
        TYPES.add("mif1");
        TYPES.add("msf1");
        TYPES.add("heic");
        TYPES.add("heix");
        TYPES.add("hevc");
        TYPES.add("hevx");
    }
}

