package org.ddr.image.gif;

import com.drew.imaging.FileType;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.gif.GifHeaderDirectory;
import org.ddr.image.ImageType;
import org.ddr.image.MetadataReader;

import java.awt.*;

public class GifMetadataReader implements MetadataReader{
    @Override
    public boolean canRead(FileType type) {
        return type == FileType.Gif;
    }

    @Override
    public ImageType getType(Metadata metadata) {
        return ImageType.GIF;
    }

    @Override
    public Dimension getDimension(Metadata metadata) {
        for (Directory directory : metadata.getDirectories()) {
            if (directory instanceof GifHeaderDirectory) {
                Integer width = directory.getInteger(GifHeaderDirectory.TAG_IMAGE_WIDTH);
                Integer height = directory.getInteger(GifHeaderDirectory.TAG_IMAGE_HEIGHT);
                if (width != null && height != null) {
                    return new Dimension(width, height);
                }
            }
        }
        return null;
    }
}
