/*
 * Decompiled with CFR 0.152.
 */
package io.apimatic.core.logger.configurations;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public abstract class SdkBaseHttpLoggingConfiguration {
    private boolean logBody = false;
    private boolean logHeaders = false;
    private List<String> headersToInclude = new ArrayList<String>();
    private List<String> headersToExclude = new ArrayList<String>();
    private List<String> headersToUnmask = new ArrayList<String>();

    public boolean shouldLogBody() {
        return this.logBody;
    }

    protected void setLogBody(boolean logBody) {
        this.logBody = logBody;
    }

    public boolean shouldLogHeaders() {
        return this.logHeaders;
    }

    protected void setLogHeaders(boolean logHeaders) {
        this.logHeaders = logHeaders;
    }

    public List<String> getHeadersToInclude() {
        return Collections.unmodifiableList(this.headersToInclude);
    }

    protected void includeHeaders(String ... includeHeaders) {
        this.headersToInclude = new ArrayList<String>(Arrays.asList(includeHeaders));
    }

    public List<String> getHeadersToExclude() {
        return Collections.unmodifiableList(this.headersToExclude);
    }

    protected void excludeHeaders(String ... excludeHeaders) {
        this.headersToExclude = new ArrayList<String>(Arrays.asList(excludeHeaders));
    }

    public List<String> getHeadersToUnmask() {
        return Collections.unmodifiableList(this.headersToUnmask);
    }

    protected void unmaskHeaders(String ... unmaskHeaders) {
        this.headersToUnmask = new ArrayList<String>(Arrays.asList(unmaskHeaders));
    }
}

